/* ArpRandomFlowFilter.cpp
 */
#include "ArpRandomFlow.h"

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <experimental/ResourceSet.h>
#include <be/interface/MenuField.h>
#include <be/interface/MenuItem.h>
#include "ArpKernel/ArpDebug.h"
#include "AmPublic/AmFilterConfigLayout.h"
#include "AmPublic/AmSongObserver.h"

ArpMOD();

static BResourceSet gResources;
static int32 gInitResources = 0;
BResourceSet& Resources()
{
	if (atomic_or(&gInitResources, 1) == 0) {
		gResources.AddResources((void*)Resources);
		atomic_or(&gInitResources, 2);
	} else {
		while ((gInitResources&2) == 0) snooze(20000);
	}
	return gResources;
}

/*****************************************************************************
 * ARP-RANDOM-FLOW-FILTER
 *****************************************************************************/
ArpRandomFlowFilter::ArpRandomFlowFilter(	ArpRandomFlowFilterAddOn* addon,
											AmFilterHolderI* holder,
											const BMessage* config)
		: AmFilterI(addon),
		  mAddOn(addon), mHolder(holder),
		  mFade(6), mPrevControlValue(64),
		  mControlNumber(10), mMinValue(0), mMaxValue(127)
{
}

ArpRandomFlowFilter::~ArpRandomFlowFilter()
{
}

AmEvent* ArpRandomFlowFilter::HandleEvent(AmEvent* event, const am_filter_params* /*params*/)
{
	if( !event ) return event;
	ArpVALIDATE(mAddOn != NULL && mHolder != NULL, return event);
	if( event->Type() != event->NOTEON_EVENT ) return event;

	if( mFade < 0 ) {
		AmTime		dist = (AmTime) (((float)mFade / 25) * PPQN);
		AmTime		resolution = PPQN / 16;
		int32		valueSteps = (abs(dist) / resolution) + 1, count = 1;
		uint8		controlValue = RandomControlValue();
		float		valueMult = ( abs(mPrevControlValue - controlValue ) / valueSteps );
		if( controlValue < mPrevControlValue ) valueMult = 0 - valueMult;
		AmEvent*	tail = 0;
		AmEvent*	head = 0;
		for( AmTime k = dist; k < 0; k += resolution ) {
			uint8	newControlValue = (uint8) (mPrevControlValue + (count * valueMult));
			AmControlChange*	cc = new AmControlChange( mControlNumber, newControlValue, event->Time() + k );
			if( cc ) {
				if( !head ) {
					head = cc;
					tail = cc;
				} else {
					tail->AppendEvent( cc );
					tail = cc;
				}
			}
			count++;
		}
		AmControlChange*	cc = new AmControlChange( mControlNumber, controlValue, event->Time() );
		if( cc ) {
			if( tail ) tail->AppendEvent( cc );
			cc->AppendEvent( event );
		}
		mPrevControlValue = controlValue;
		if( !head ) return event;
		return head;
	}

	if( mFade > 0 ) {
		AmTime		dist = (AmTime) (((float)mFade / 25) * PPQN);
		AmTime		resolution = PPQN / 16;
		int32		valueSteps = (abs(dist) / resolution) + 1, count = 1;
		uint8		controlValue = RandomControlValue();
		float		valueMult = ( abs(mPrevControlValue - controlValue ) / valueSteps );
		if( controlValue < mPrevControlValue ) valueMult = 0 - valueMult;
		AmEvent*	tail = event;
		for( AmTime k = 0; k < dist; k += resolution ) {
			uint8	newControlValue = (uint8) (mPrevControlValue + (count * valueMult));
			AmControlChange*	cc = new AmControlChange( mControlNumber, newControlValue, event->Time() + k );
			if( cc ) {
				tail->AppendEvent( cc );
				tail = cc;
			}
			count++;
		}
		AmControlChange*	cc = new AmControlChange( mControlNumber, controlValue, event->Time() + dist );
		if( cc ) tail->AppendEvent( cc );
		mPrevControlValue = controlValue;
		return event;
	}
	
	AmControlChange*	cc = new AmControlChange( mControlNumber, RandomControlValue(), event->Time() );
	if( !cc ) return event;
	cc->AppendEvent( event );
	return cc;
}

BView* ArpRandomFlowFilter::NewEditView(BPoint requestedSize) const
{
	return 0;
}

status_t ArpRandomFlowFilter::GetConfiguration(BMessage* values) const
{
	status_t err = AmFilterI::GetConfiguration(values);
	if (err != B_OK) return err;
	
	return B_OK;
}

status_t ArpRandomFlowFilter::PutConfiguration(const BMessage* values)
{
	status_t err = AmFilterI::PutConfiguration(values);
	if (err != B_OK) return err;

	return B_OK;
}

class ArpRandomFlowSettings : public AmFilterConfigLayout
{
public:
	ArpRandomFlowSettings(AmFilterHolderI* target,
						  const BMessage& initSettings)
		: AmFilterConfigLayout(target, initSettings)
	{
		try {
			AddLayoutChild((new ArpRunningBar("TopVBar"))
				->SetParams(ArpMessage()
					.SetInt32(ArpRunningBar::OrientationP, B_VERTICAL)
					.SetFloat(ArpRunningBar::IntraSpaceP, .5)
				)
				->AddLayoutChild((new ArpTextControl(
										SZ_FILTER_LABEL, "Label:","",
										mImpl.AttachTextControl(SZ_FILTER_LABEL)))
					->SetParams(ArpMessage()
						.SetString(ArpTextControl::MinTextStringP, "8")
						.SetString(ArpTextControl::PrefTextStringP, "8888888888")
					)
					->SetConstraints(ArpMessage()
						.SetFloat(ArpRunningBar::WeightC,0)
						.SetInt32(ArpRunningBar::FillC,ArpEastWest)
						.SetBool(ArpRunningBar::AlignLabelsC,false)
					)
				)
			);
		} catch(...) {
			throw;
		}
		Implementation().RefreshControls(mSettings);
	}

	void Draw(BRect update)
	{
		inherited::Draw(update);
		SetHighColor(0, 0, 0);
		StrokeRect(Bounds());
	}
	
protected:
	typedef AmFilterConfigLayout inherited;
};

status_t ArpRandomFlowFilter::Configure(ArpVectorI<BView*>& panels)
{
	BMessage config;
	status_t err = GetConfiguration(&config);
	if (err != B_OK) return err;
	panels.push_back(new ArpRandomFlowSettings(mHolder, config));
	return B_OK;
}

uint8 ArpRandomFlowFilter::RandomControlValue() const
{
	float		r = floor( ( drand48() * (mMaxValue - mMinValue) ) + mMinValue );
	if( r < mMinValue ) r = mMinValue;
	else if( r > mMaxValue ) r = mMaxValue;
	return (uint8)r;
}

/*****************************************************************************
 * ARP-RANDOM-FLOW-FILTER-ADDON
 *****************************************************************************/
void ArpRandomFlowFilterAddOn::GetVersion(int32* major, int32* minor) const
{
	*major = 1;
	*minor = 0;
}

BBitmap* ArpRandomFlowFilterAddOn::Image(BPoint requestedSize) const
{
	const BBitmap* bm = Resources().FindBitmap("Class Icon");
	if (bm) return new BBitmap(bm);
	return NULL;
}

AmFilterI* ArpRandomFlowFilterAddOn::NewInstance(	AmFilterHolderI* holder,
													const BMessage* config)
{
	return new ArpRandomFlowFilter( this, holder, config );
}

extern "C" _EXPORT AmFilterAddOn* make_nth_filter(int32 n, image_id /*you*/,
												  const void* cookie, uint32 /*flags*/, ...)
{
	if (n == 0) return new ArpRandomFlowFilterAddOn(cookie);
	return NULL;
}
