/* AmGlobalsI.h
 * Copyright (c)2000 by Eric Hackborn.
 * All rights reserved.
 *
 * This file defines classes that provide global, application-wide
 * behaviour, along with functions for accessing instances of each
 * of these classes.  The application implementing this library needs
 * to implement the accessing functions.
 *
 * This code is not public domain, nor freely distributable.
 * Please direct any questions or requests to Eric Hackborn,
 * at <hackborn@angryredplanet.com>.
 *
 * ----------------------------------------------------------------------
 *
 * To Do
 * ~~~~~~~~~~
 *
 *	- Nothing!
 *
 * ----------------------------------------------------------------------
 *
 * Known Bugs
 * ~~~~~~~~~~
 *
 *	- None!  Ha ha!
 *
 * ----------------------------------------------------------------------
 *
 * History
 * ~~~~~~~
 * 05.15.00		hackborn
 * Created this file.
 */

#ifndef AMPUBLIC_AMGLOBALSI_H
#define AMPUBLIC_AMGLOBALSI_H

#include <be/app/Handler.h>
#include <be/support/SupportDefs.h>
#include "AmPublic/AmDefs.h"
#include "AmPublic/AmSongRef.h"
class AmPhrase;
class AmPhraseEvent;
class AmSignature;
class AmTool;
class AmTrack;
class AmViewFactory;

enum {
	AM_DEFAULT_UNDO_HISTORY		= 50
};
/***************************************************************************
 * AM-GLOBALS-I
 * A class that stores all the globally-available methods and data.
 ***************************************************************************/

// Forward reference
class AmGlobalsI;
// Accessing function
AmGlobalsI& AmGlobals();

// Let application attach globals object
void SetGlobals(AmGlobalsI& globals);

class AmGlobalsI
{
public:
	virtual ~AmGlobalsI()			{ }

	virtual void	Initialize()	{ }

	/*---------------------------------------------------------
	 * CHANGE NOTIFICATION
	 *---------------------------------------------------------*/
	/* These are the events a client can register to hear about
	 * via the AddObserver() method.
	 */
	enum ObserverMessages {
		TOOL_OBS				= '#gtl'	// Clients will here when SetTool() is called
	};
	virtual void	AddObserver(uint32 code, BHandler* handler) = 0;
	virtual void	RemoveObserver(uint32 code, BHandler* handler) = 0;
	
	/*---------------------------------------------------------
	 * ACCESSING
	 *---------------------------------------------------------*/
	/* This method constructs a new song and sets the supplied ref
	 * to it.  B_OK is returned for success, B_ERROR if anything went wrong.
	 * Clients really should supply the current undo history preference.
	 */
	virtual status_t	NewSong(AmSongRef& songRef, int32 undoHistory) = 0;
	/* Remove the supplied song from the system.  If the song doesn't
	 * exist, answer with B_ERROR.
	 */
	virtual status_t	RemoveSong(song_id id) = 0;
	/* Answer a song ref for the supplied song ID.  If the ID doesn't exist,
	 * the ref will be invalid.
	 */
	virtual AmSongRef	SongRef(song_id id) const = 0;
	/* Answer the tool at the supplied index.  Clients can use this to
	 * iterate over all installed tools.
	 */
	virtual AmTool*		ToolAt(uint32 index) const = 0;
	/* Answer the tool at the supplied button.
	 */
	virtual AmTool*		Tool(uint32 button) const = 0;
	virtual AmTool*		FindTool(const char* uniqueName) const = 0;
	/* Answer the tool mapped to the supplied key, if any.
	 */
	virtual AmTool*		FindTool(int32 key) const = 0;
	virtual void		SetTool(AmTool* tool, uint32 button) = 0;
	virtual status_t	GetToolMapping(const AmTool* tool, uint32* button) const = 0;
	/* Answer the view factory at the supplied index.  Clients can use
	 * this to iterate over all installed view factories.
	 */
	virtual AmViewFactory* FactoryAt(uint32 index) const = 0;
	/* Answer the installed view factory with the supplied signature.  If you want the
	 * always-available default factory, use a BString with DEFAULT_FACTORY_SIGNATURE.
	 */
	virtual AmViewFactory* FactoryNamed(const BString& signature) const = 0;	

	/* It's useful to have a buffer between when the song actually
	 * ends and where the UI thinks it ends, otherwise scrollbars give
	 * no extra room beyond the immediate end of the song for adding events.
	 */
	virtual AmTime	EndTimeBuffer() const = 0;

	/* Answer the phrase event closest to the supplied time, provided it's
	 * within tolerance.  If none is within tolerance, answer 0.
	 */
	virtual AmPhraseEvent* PhraseEventNear(const AmTrack* track, AmTime time) const = 0;
	/* If clients wich, they can specify their own tolerance.  Note that in
	 * general, its better to take the default, which may become a user preference.
	 */
	virtual AmPhraseEvent* PhraseEventNear(	const AmTrack* track,
											AmTime time,
											AmTime tolerance) const = 0;
	/* Populate the supplied signature object with the signature information at
	 * the given time.
	 */
	virtual status_t	GetMeasure(const AmPhrase& signatures, AmTime time, AmSignature* signature) const = 0;
	/* A convenience to set the undo history size of all existing songs.
	 */
	virtual void		SetUndoHistory(int32 size) = 0;

	/* This is only temporary.  As soon as events can write themselves out
	 * to a stream, all copying and pasting will be done via the system-wide
	 * clipboard.
	 */
	virtual BClipboard*	Clipboard() const = 0;

	/* Write and read my state from the supplied message.
	 */
	virtual status_t	WriteTo(BMessage* state) const = 0;
	virtual status_t	ReadFrom(const BMessage* state) = 0;
};

#endif
