/*
 * Graph.h
 * Copyright Jonathan Booth, 1998
 *
 * Graph.h contains the classes GraphView and LoadWin, which handle the view
 * and window components of the program.
 */
 
#ifndef GRAPH_H
#define GRAPH_H

// Include files for the GraphView
#include <View.h>
#include "Data.h"

// Some default colors for the GraphView to use
const rgb_color background = { 0,0,0,0 };
const rgb_color foreground = { 200,200,200,0 };
const rgb_color cpu_colors[8] = {
	{ 0,0,255,0 },		// Blue
	{ 255,0,0,0 },		// Red
	{ 255,255,0,0 },	// Yellow
	{ 0,255,0,0 },		// Green
	{ 255,128,0,0 },	// Orange
	{ 0,255,255,0 },	// Cyan
	{ 255,0,255,0 },	// Purple
	{ 255,255,255,0 },	// White
};

struct MENU_ENTRY {
	float mul;
	const char *desc;
};

const MENU_ENTRY speed[] = {
	{ 1.0/4.0, "1/4 sec" },
	{ 1.0/2.0, "1/2 sec" },
	{ 1.0/1.0, "1 sec" },
	{ 2.0/1.0, "2 sec" },
	{ 4.0/1.0, "4 sec" },
	{ 8.0/1.0, "8 sec" },
	{ 1.0/1.0, NULL }
};

const int MAX_WIDTH = 224;
// Default area to be in
const BPoint Minimum(112,80);
const BPoint Maximum(MAX_WIDTH,160);
const BRect Default(100,100,212,180);
const BRect ViewDefault(0, 0, Minimum.x, Minimum.y);

class GraphView : public BView {
public:
	GraphView(DataGatherer *data);
	virtual void AttachedToWindow();
	virtual void DetachedFromWindow();
	virtual void Pulse();
	virtual void Draw(BRect Update);
	virtual void MessageReceived(BMessage *msg);
	virtual void MouseDown(BPoint point);
//	virtual void FrameResized(float width, float height);
protected:
	static int32 DoMenu(void *what);
	void DoMenu2();
	virtual BPopUpMenu * MakeMenu();	// Make the popup menu
	virtual void GraphData();			// Graph the data onto a bitmap

	// General stuff that we need to know for the program
	sem_id Lock;						// Locking semaphore
	DataGatherer *Data;					// Data acquisition class
	
	// This is the graph we're going to draw loads on
	BBitmap *Graph;						// Bitmap for screen buffering
	BView *Pen;							// Pen to draw in Graph with
	BRect Frame;						// Current size of the window
};

#endif /* GRAPH_H */