/*
 * Data.h
 *
 * Data.h contains the classes that provide the access routines to get the
 * data that the GraphView will draw.
 */
 
#ifndef DATA_H
#define DATA_H

#include <kernel/OS.h>

// This is the generic class type that all subclasses will inherit from
class DataGatherer {
public:
	DataGatherer();
	virtual ~DataGatherer();
	virtual float * AcquireData();
	virtual float * AcquireDataTime(int index);
	virtual int DataWidth();
};

// This is the class that gets the data based on CPU usage
class CPUGatherer : public DataGatherer {
public:
	CPUGatherer() { CPUGatherer(100); }
	CPUGatherer(int entries);
	virtual ~CPUGatherer();
	virtual float * AcquireData();
	virtual float * AcquireDataTime(int index);
	virtual int DataWidth();
protected:
	void GetData();						// To actually get the data
	
	int System_CPU;						// Number of CPUs the system has.
	int Entries;						// Number of entries history has.

	// The following two entries are for us to compute the amount of
	// CPU power used during the period between pulses
	float **History;					// List of load %s
	int Index;							// Current index in History
	bigtime_t Last_Updated;				// Last Pulse() update
	bigtime_t *Last_CPU_Time;			// Old cpu active times
};

#endif /* DATA_H */