/*
 * Data.cpp
 *
 * Class definitions for the Data.h classes.
 */
 
#include "Data.h"

DataGatherer::DataGatherer() {}
DataGatherer::~DataGatherer() {}
float * DataGatherer::AcquireData() {
	return NULL;
}
float * DataGatherer::AcquireDataTime(int index) {
	return NULL;
}
int DataGatherer::DataWidth() {
	return 1;
}

CPUGatherer::CPUGatherer(int entries)
	: DataGatherer()
{
	// Copy the entries over
	Entries = entries;
	
	// Figure the number of CPUs. This way we can react and scale
	// to the number of CPUs there.
	system_info info;
	get_system_info(&info);
	System_CPU = info.cpu_count;
	
	// Allocate the history array
	History = new float*[System_CPU];
	Last_CPU_Time = new bigtime_t[System_CPU];
	for (int cpu=0; cpu < System_CPU; cpu++) {
		History[cpu] = new float[entries];
		Last_CPU_Time[cpu] = info.cpu_infos[cpu].active_time;
		
		for (int i=0; i < entries; i++ ) {
		  History[cpu][i] = 0;
		}
	}
	
	// Now set our index, and the time of the construction of
	// this object
	Index = 0;
	Last_Updated = system_time();
}

CPUGatherer::~CPUGatherer() {
	// Super-class call
	DataGatherer::~DataGatherer;
	
	// Unallocate that bigass array
	for (int cpu=0; cpu < System_CPU; cpu++) {
		if (History[cpu]) { delete History[cpu]; }
	}
	delete History;
	delete Last_CPU_Time;
}

float * CPUGatherer::AcquireData() {
	// Grab the next piece of data and put it into the array
	// Get the system info again
	system_info info;
	get_system_info(&info);

	// Now compute the amount of CPU time spent by each CPU
	bigtime_t delta = (system_time() - Last_Updated);
	Last_Updated = system_time();
	float *data = new float[System_CPU];
	for (int cpu=0; cpu < System_CPU; cpu++) {
		History[cpu][Index] = ((float)info.cpu_infos[cpu].active_time -
				(float)Last_CPU_Time[cpu]) / (float)delta;
		Last_CPU_Time[cpu] = info.cpu_infos[cpu].active_time;
		data[cpu] = History[cpu][Index];
	}

	// Since we just filled that entry, move Index one forward
	Index = (Index + 1) % Entries;
	
	return data;
}

float * CPUGatherer::AcquireDataTime(int index) {
	// Update the data they asked for
	float *data = new float[System_CPU];
	for (int cpu=0; cpu < System_CPU; cpu++) {
		data[cpu] = History[cpu][(Index + index) % Entries];
	}
	
	return data;
}

int CPUGatherer::DataWidth() {
	return System_CPU;
}