/*

	PrefServer-client demo 
	
*/

#include "Application.h"
#include "Preference.h"


// location and size of my window
BRect winframe;

// basic window class
class mywin : public BWindow
{
	public:
		mywin(BRect rect, char *name, window_type type, uint32 flags)
			: BWindow(rect,name,type,flags)
		{};
		bool QuitRequested()
		{
			winframe=Frame();
			be_app->PostMessage(B_QUIT_REQUESTED);
			return true;
		};
};


int main()
{	
	BApplication app("application/x-marcone-prefclient");
	mywin *win;
	
	// create the Preference object and add some sensible defaults
	Preference mypref;
	mypref.AddRect("winframe",BRect(100,100,300,200));

	// load latest settings from disk (or whereever the PrefServer is storing them)
	mypref.Load();
	// extract member, note that this will not fail, since we put a default value in there
	mypref.FindRect("winframe",&winframe);
	
	// this function is included in the client code for your convenience
	// it will adjust the BRect so that it fits on the current workspace
	FitRectOnScreen(&winframe);	

	// open window at desired location
	win=new mywin(winframe,"Move me around",B_TITLED_WINDOW,0L);
	win->Show();
	app.Run();

	// store the current position in the Preference and save it
	mypref.ReplaceRect("winframe",winframe);
	mypref.Save();

	return(0);
}
