/*****************************************************************************

	Projet	: Pulsar Sample FFT AddOn

	Fichier	: sample_addon.cpp
	Partie	: End

	Auteur	: RM
	Date		: 040597 -- version 0.2 (C funcs)
	Date		: 010797 -- version 0.3 (CFilter)
	Format	: tabs==2

*****************************************************************************/

#include "CFilter.h"

#pragma export on
CFilter * filterInit(uint32 index);
#pragma export reset

//--------------------------------------------------------------------

//*************************************
class CSampleFftFilter : public CFilter
//*************************************
{
public:

	CSampleFftFilter(void) : CFilter()	{ /* nothing */ }
	virtual ~CSampleFftFilter(void) 		{ /* nothing */ }

	virtual bool load(void);
	virtual bool prepare(void)				{ return true; }
	virtual void processFrame8(SFrameInfo &frame);

}; // end of class defs for CSampleFftFilter


//*************************************
class CCentralFftFilter : public CFilter
//*************************************
{
public:

	CCentralFftFilter(void) : CFilter()	{ /* nothing */ }
	virtual ~CCentralFftFilter(void) 		{ /* nothing */ }

	virtual bool load(void);
	virtual bool prepare(void)				{ return true; }
	virtual void processFrame8(SFrameInfo &frame);

}; // end of class defs for CCentralFftFilter


//--------------------------------------------------------------------


//**********************************************
CFilter * filterInit(uint32 index)
//**********************************************
{
	// this add-on declares two filters
	if (index == 0) return new CSampleFftFilter;
	else if (index == 1) return new CCentralFftFilter;
	else return NULL;		// no more add-ons to declare
} // end of filterInit


//*******************************
bool CSampleFftFilter::load(void)
//*******************************
{
	sFilter.name = "FFT Scope";
	sFilter.author = "R'alf";
	sFilter.info = "Sample code";
	sFilter.majorVersion = 0;
	sFilter.minorVersion = 3;
	sFilter.position = kFilterPositionLast-0.21;
	sFilter.supportedMode = (color_space)(B_COLOR_8_BIT);

	sFilter.modelParam.AddRect("Bass Frame", BRect(10,10,10+255,10+99));
	sFilter.modelParam.AddRect("High Frame", BRect(640-256-10,10,640-256-10+255,10+99));
	sFilter.modelParam.AddBool("Average", true);
	sFilter.modelParam.AddFloat("Divider", 8192.0);

	return true;
}  // end of load for CSampleFftFilter


//***************************************
void CSampleFftFilter::processFrame8(SFrameInfo &frame)
//***************************************
{
float *highFft;
float *bassFft;
int i;
int y1;

	highFft	= frame.fftHigh;
	bassFft	= frame.fftBass;

	// fft droite (right)

	i = 10+100-frame.averageFftBass/8192;
	if (i<0) i=0;
	if (i>479) i=479;
	long z=i;

	for(i=0; i<255; i++)
	{
		y1 = 100-(bassFft[i])/8192;
		if (y1<0) y1=0;
		if (y1 > 99) y1=99;

		// 52 == vert pomme (apple green)
		blitLine8(10+i, 10+y1, 10+i, 10+100/*+y2*/, 52);
	}
	blitLine8(10, z, 10+256, z, 250);

	// fft gauche (left)

	i = 10+100-frame.averageFftHigh/8192;
	if (i<0) i=0;
	if (i>479) i=479;
	z=i;
	for(i=0; i<255; i++)
	{
		y1 = 100-(highFft[i])/8192;
		if (y1<0) y1=0;
		if (y1 > 99) y1=99;

		// 250 == jaune pomme
		blitLine8(640-256-10+i, 10+y1, 640-256-10+i, 10+100, 250);
	}
	blitLine8(640-256-10, z, 640-10, z, 52);

}  // end of processFrame8 for CSampleFftFilter


//*******************************
bool CCentralFftFilter::load(void)
//*******************************
{
	sFilter.name = "FFT Central";
	sFilter.author = "R'alf";
	sFilter.info = "Sample code";
	sFilter.majorVersion = 0;
	sFilter.minorVersion = 3;
	sFilter.position = kFilterPositionLast-0.22;
	sFilter.supportedMode = (color_space)(B_COLOR_8_BIT);

	return true;
}  // end of load for CCentralFftFilter


//***************************************
void CCentralFftFilter::processFrame8(SFrameInfo &frame)
//***************************************
{
float *bassFft;
int i;
long nframe;
int y1;
int h = sPrepare.sy;
int w = sPrepare.sx;
int w2 = w/2;

	bassFft	= frame.fftBass;
	nframe	= frame.frame;

	for(i=0; i<h; i++)
	{
		long a = (i+nframe)&0x1ff;
		if (a > 255) continue;
		y1 = (bassFft[a]) / 32768;
		if (y1 < 0) y1 = -y1;
		if (y1 < 3) continue;
		if (y1 > w2) y1 = w2;
		blitLine8(w2-y1, i, w2+y1, i, i+y1);
	}
}  // end of processFrame8 for CCentralFftFilter


// eoc
