//============================================================================
// main.cpp
// © Michael Pieper 02. Apr. 1999
//============================================================================
//
//	This class generates an Application which receives Messages through
//  a port and simple displays them
//
//============================================================================

#include "LogWin.h"
#include <AppKit.h>
#include <InterfaceKit.h>

//============================================================================
// Define the Application

class DebugWinApp : public BApplication {

public:
					DebugWinApp();
					~DebugWinApp(void);
	void			AboutRequested(void);
};

//============================================================================
// Start the Program

int main (void)
{
	DebugWinApp *myApp;

	myApp = new DebugWinApp();
	myApp->Run();
	
	delete(myApp);
	return(0);
}

//============================================================================
// The Constructor of the Application

DebugWinApp::DebugWinApp() : BApplication("application/x-vnd.mp-debugwin")
{
	LogWin *logWin;
	BRect	rectLogWin;
	
	rectLogWin.Set(100,100,400,400);
	logWin = new LogWin(rectLogWin);	// Create and View the Window
	logWin->Show();
}

//============================================================================
// The Destructor of the Application. (Nothing to do)

DebugWinApp::~DebugWinApp(void) {
}

//============================================================================
// If someone would know, what this program is for, and from whom it was programmed

void DebugWinApp::AboutRequested(void) {
	BAlert *alert = new BAlert("DebugWin", 
			"DebugWin 0.1ß\n\n"
			"This program shows all text written in the port \"debugwin\"\n\n"
			"Written by Michael Pieper\nmichael@augusta.de", "OK"); 
	alert->Go();
}
