//============================================================================
// LogWin.cpp
// © Michael Pieper 02. Apr. 1999
//============================================================================
//
//	This class contains the LogWindow itself.
//
//============================================================================
	
#include "LogWin.h"
#include <InterfaceKit.h>
#include <AppKit.h>
#include <stdio.h>
#include <stdlib.h>

//============================================================================
// Lets talk about the Constructor...

LogWin::LogWin(BRect frame) 
	: BWindow(frame, "DebugWin", B_TITLED_WINDOW, 0)

{
	BRect 				rect = frame;
	BRect				insrect;
	BTextView			*btview;
	BScrollView			*scv;
	thread_id			trid;
	pid_i =  create_port(10, PORT_NAME);	// Over this port we will get the messages

	rect.OffsetTo(B_ORIGIN);
	rect.right -= B_V_SCROLL_BAR_WIDTH;
	insrect = rect;
	insrect.InsetBy(5,5);
	btview = new BTextView(rect, "view", insrect, B_FOLLOW_ALL_SIDES, B_WILL_DRAW | B_FRAME_EVENTS | B_NAVIGABLE); 

	scv = new BScrollView("scr", btview, B_FOLLOW_ALL_SIDES, 0, false, true);
	AddChild(scv);

	trid = spawn_thread(read_thread, "ReadDebugWin", B_NORMAL_PRIORITY, btview);	// We need a "watcher" thread!
	if (trid < B_NO_ERROR) {
		printf("Error, while starting the read_thread!\n");
	} else {
		resume_thread(trid);
		printf("read_thread started\n");
	}
}

//============================================================================
// When the user closes the Window...

bool LogWin::QuitRequested()
{
	delete_port(pid_i);
	be_app->PostMessage(B_QUIT_REQUESTED);
	return(true);
}

//============================================================================
// This is the C-Function, which runs as a own thread! So we have to tell
// the function, where the BTextView is!

int32 read_thread(void *btv) {
	BTextView *bTextView = (BTextView *)btv;
	port_id	pid;
	char	*buffer;
	size_t	p_len;
	int32	message;
	
	if (bTextView->LockLooper()) {
		bTextView->Insert("And so it begins\n");	// Print a "Startmessage"
		bTextView->UnlockLooper();
	}
	
	pid = find_port(PORT_NAME);	// Where is the Port?
	if (pid >= B_NO_ERROR) {

		while ((p_len = port_buffer_size(pid)) >= B_NO_ERROR) {	// Lets wait....

			buffer = (char *)malloc(p_len);	// We need mem
			if (buffer != NULL) {
				if (read_port(pid, &message, buffer, p_len) < B_NO_ERROR) break;	// read the Message
				if (bTextView->LockLooper()) {
					bTextView->Insert(buffer, p_len);	// and display it!
					bTextView->UnlockLooper();
				}
			}
		}
	}
	
	return 0;
}