#include "BMainWindow.h"

BMainWindow::BMainWindow(BRect frame)
	: BWindow(frame, MAIN_WINDOW_TITLE, B_TITLED_WINDOW, B_NOT_H_RESIZABLE, 0)
{
	BRect 			aRect = frame;
	BMainView		*aView;
	
	aRect = Bounds();
	//aRect.top = aMenuBar->Bounds().bottom;
	aView = new BMainView(	aRect,
							"MainView");/*
							B_FOLLOW_TOP_BOTTOM);
							B_FULL_UPDATE_ON_RESIZE|
							B_WILL_DRAW|
							//B_FULL_UPDATE_ON_RESIZE|
							B_FRAME_EVENTS);*/
	
	// create buttons
	mStartButton = 	new BButton(BRect(START_BUTTON_POS), 
								START_BUTTON_TEXT,
								START_BUTTON_TEXT,  
								new BMessage(msgSTART),
								B_FOLLOW_LEFT|
								B_FOLLOW_TOP,
								B_WILL_DRAW|
								B_NAVIGABLE);
								
	mStopButton = 	new BButton(BRect(STOP_BUTTON_POS), 
								STOP_BUTTON_TEXT,
								STOP_BUTTON_TEXT,  
								new BMessage(msgSTOP),
								B_FOLLOW_LEFT|
								B_FOLLOW_TOP,
								B_WILL_DRAW|
								B_NAVIGABLE);
	mStopButton->SetEnabled(false);
	
	// create text view
	mTextBox = new BTextView(
								BRect(TEXT_POS),
								"type here",
								BRect(TEXTCONTENT_POS),
								B_FOLLOW_TOP_BOTTOM,	
								B_FRAME_EVENTS|
								B_WILL_DRAW|
								B_NAVIGABLE);
	mTextBox->SetMaxBytes(2048);
	mTextBox->MakeEditable(false);
	mTextBox->SetText(TEXTBOX_TEXT);
	
	// lock window, insert view then unlock
	Lock();
		AddChild(aView);
		aView->AddChild(mStartButton);
		aView->AddChild(mStopButton);
		aView->AddChild(mTextBox);
	Unlock();

	// show window
	Show();
	
	aNino = NULL;
}

void
BMainWindow::DispatchMessage(BMessage *msg, BHandler *target) 
{ 
	switch (msg->what) 
	{ 
		case msgSTART:
			if(!aNino)
			{
				aNino = new Nino;
				printf("aNino created\n");
			}
			mStopButton->SetEnabled(true);
			mStartButton->SetEnabled(false);
		break;
		
		case msgSTOP:
			if(aNino) 
			{
				delete aNino;
				aNino = NULL;
				printf("aNino deleted\n");
			}
			mStopButton->SetEnabled(false);
			mStartButton->SetEnabled(true);
		break;
	
	    default: 
        	inherited::DispatchMessage(msg, target); 
        break; 
	} 
}

bool
BMainWindow::QuitRequested()
{
	// tell application to quit
	be_app->PostMessage(B_QUIT_REQUESTED);
	return(TRUE);
} 