#ifndef AW_H
#include "aw.h"
#endif

#define MENUHT 20
#define	R_OPEN	'OPE!'
#define	R_SAVE	'SAV!'


WINDOWCLASS::WINDOWCLASS(
	BRect frame,
	const char *name,
	window_type type,
	uint32 flags
)
: BWindow(frame, name, type, flags)
{
	BRect bnds;

// move the frame to 0,0 ready to calculate bounds
	frame.OffsetTo(B_ORIGIN);

// add MsgInfoView to window
	bnds.Set (0,MENUHT,frame.right,frame.bottom);
	aView = new MsgInfoView(bnds, "MsgInfoView");
	AddChild(aView);

// add menuBar to window
	bnds.Set (0,0,frame.right,MENUHT-1);
	mbar = new BMenuBar (bnds, "milkybar");
	MakeMenus (mbar);
	AddChild(mbar);

// File Panels
	msngr = new BMessenger(this);
	saver = new BFilePanel (
		B_SAVE_PANEL, msngr, NULL, 0, false,
		new BMessage(B_SAVE_REQUESTED), NULL, false, true
	);
	opener = new BFilePanel (
		B_OPEN_PANEL, msngr, NULL, 0, false,
		new BMessage(B_REFS_RECEIVED), NULL, false, true
	);
}

WINDOWCLASS::~WINDOWCLASS ()
{
	delete opener;
	delete saver;
	delete msngr;
}

#include <interface/Alert.h>
#include <be/storage/NodeInfo.h>

#define MSG_MIME_TYPE	"application/x-vnd.Be-message"

void
WINDOWCLASS::MessageReceived (
	BMessage *msg
)
{
	switch(msg->what)
	{
	case B_ABOUT_REQUESTED:
		{
		BAlert *wash_and = new BAlert ("About", 
			"freeware written by John Cooke\n" // strings will join
			"drag and drop to AND from the window!",
			"Go Back", "Take Sword", "Kill Monster"
		);
		wash_and->Go();
		}
		break;
	case R_SAVE:
		saver->Show();
		break;
	case R_OPEN:
		opener->Show();
		break;
	case B_REFS_RECEIVED:
		{
			entry_ref ref;
			msg->FindRef("refs", &ref);
			BFile refile (&ref, B_READ_ONLY);
			BNodeInfo noddy (&refile);
			char buf[256];
			status_t st = noddy.GetType(buf);
			/*
			if(st == B_OK)
				printf("TYPE: [%s]\n", buf);
			else
				printf("error %08x getting MIME type\n");
			*/
			aView->BlowJob(&refile);
		}
		break;
	case B_SAVE_REQUESTED:
		{
		// extract directory
			entry_ref ref;
			msg->FindRef("directory", &ref);
			BDirectory dir;
			dir.SetTo(&ref);
		// extract file name
			const char *name;
			msg->FindString("name", &name);
		// create new file
			BFile *newfile = new BFile;
			dir.CreateFile(name, newfile);
		// set MIME type
			BNodeInfo noddy (newfile);
			noddy.SetType(MSG_MIME_TYPE);
		// Flatten the message
			ssize_t size;
			status_t st = aView->HedgeHog(newfile, &size);
		// cleanup
			delete newfile;
		}
		break;
	case MSG_CHANGED:
		{
		// set the Window Zoom limits
			BRect osbmframe;
			if(msg->FindRect("osbmframe", &osbmframe) == B_OK)
				SetZoomLimits (osbmframe.Width(), MENUHT + osbmframe.Height());

		// set window title
			char *title;
			if(msg->FindString("newtitle", &title) == B_OK)
				SetTitle(title);
		
		// enable milky bar
			BMenu *bm = mbar->SubmenuAt(0);
			bm->ItemAt(1)->SetEnabled(TRUE);
		}
		break;
	default:
		BWindow::MessageReceived (msg);
		break;
	}
}

bool
WINDOWCLASS::QuitRequested()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return(TRUE);
}

void
WINDOWCLASS::MakeMenus (
	BMenuBar *bar
)
{
	BMenu * file = new BMenu("File");
	file->AddItem(new BMenuItem("Open", new BMessage(R_OPEN), 'O'));
	file->AddItem(new BMenuItem("Save", new BMessage(R_SAVE), 'S'));
	file->ItemAt(1)->SetEnabled(FALSE);
	file->AddItem(new BMenuItem("Close", new BMessage(B_QUIT_REQUESTED), 'W'));
	file->AddSeparatorItem();
	file->AddItem(new BMenuItem("About", new BMessage(B_ABOUT_REQUESTED)));
	bar->AddItem(file);

	file = bar->SubmenuAt(0);
}

//   
// _||________________________________________________________________________
//
APPCLASS::APPCLASS(const char *sig)
: BApplication(sig)
{
	BRect			aRect;

// set up a rectangle and instantiate a new window
	aRect.Set(100, 80, 100+360-1, 80+74-1);
	aWindow = new WINDOWCLASS(aRect, "Message", B_TITLED_WINDOW, 0);

// make window visible
	aWindow->Show();
}

void
APPCLASS::RefsReceived (
	BMessage *msg
)
{
	if(aWindow != 0)
	{
		BMessage * msgcopy = new BMessage (msg);
		aWindow->PostMessage (msgcopy);
	}
}

//   
// _||________________________________________________________________________
//

main()
{	
	APPCLASS *app;

	app = new APPCLASS("application/x-vnd.JohnCooke-message");
	app->Run();
	
	delete(app);

	return(0);
}

