#ifndef MESSAGE_VIEW_H
#include "MsgView.h"
#endif

//   _________________________
// _| Supplementary Functions |_______________________________________________
//
#include <stdio.h>
#include <string.h>
#include <ctype.h>

//--[convert a uint32 into 4 ASCII chars or 8 hex digits]--
// only if all bytes are printable will the former apply
void
seewhat (
	uint32 in,
	char *out	// must be 9 chars at least
)
{
	char buf4[4];
	char buf8[8];
	uint8 *ptr = (uint8 *)&in;
	bool ean=true;
	static char *hex = "0123456789abcdef";

//--[load both char arrays]--
	for(int i=0; i<4; i++,ptr++)
	{
		if(ean && isprint(*ptr))
			buf4[i] = (char)*ptr;
		else
			ean = false;

		uint8 nibble = *ptr >> 4;
		buf8[i*2] = hex[nibble];
		nibble = *ptr & 15;
		buf8[i*2+1] = hex[nibble];
	}

//--[copy output]--
	if(ean)
	{
		memcpy(out, buf4, 4);
		out[4] = '\0';
	}
	else
	{
		memcpy(out, buf8, 8);
		out[8] = '\0';
	}
}

#include <be/storage/Path.h>

void
DecodeMsg (
	BView *view,
	BMessage *hmsg,
	float ascent,
	float lineht,
	uint32 *nitem_ptr,
	float *maxx_ptr
)
{
	char *name;
	uint32 type;
	int32 count;
	char buf[64];
	char typestr[8+1];
	BPoint penpos (0,0);
	float maxx = 0.0;

	uint32 nitem = 0;
	for(int32 i=0;
		hmsg->GetInfo(B_ANY_TYPE, i, &name, &type, &count) == B_NO_ERROR;
		i++
	)
	{
		seewhat(type, typestr);
		for(int32 j=0; j<count; j++,nitem++)
		{
			view->MovePenTo(2,ascent+lineht*nitem);
			view->DrawString(name, 12);
			view->MovePenTo(88,ascent+lineht*nitem);
			view->DrawString(typestr);
			view->MovePenTo(128,ascent+lineht*nitem);

			switch(type)
			{
			case B_BOOL_TYPE:
				bool ean;
				hmsg->FindBool(name, j, &ean);
				sprintf(buf, "%s", ean?"true":"false");
				break;
			case B_INT8_TYPE:
				int8 i8;
				hmsg->FindInt8(name, j, &i8);
				sprintf(buf, "%d", i8);
				break;
			case B_INT16_TYPE:
				int16 i16;
				hmsg->FindInt16(name, j, &i16);
				sprintf(buf, "%d", i16);
				break;
			case B_INT32_TYPE:
				int32 i32;
				hmsg->FindInt32(name, j, &i32);
				sprintf(buf, "%d", i32);
				break;
			case B_INT64_TYPE:
				int64 i64;
				hmsg->FindInt64(name, j, &i64);
				sprintf(buf, "%ld", i64);
				break;
			case B_FLOAT_TYPE:
				float f;
				hmsg->FindFloat(name, j, &f);
				sprintf(buf, "%f", f);
				break;
			case B_DOUBLE_TYPE:
				double d;
				hmsg->FindDouble(name, j, &d);
				sprintf(buf, "%f", d);
				break;
			case B_STRING_TYPE:
				char * str;
				hmsg->FindString(name, j, &str);
				sprintf(buf, "[%.60s]", str);
				break;
			case B_POINT_TYPE:
				BPoint point;
				hmsg->FindPoint(name, j, &point);
				sprintf(buf, "%.1f,%.1f", point.x, point.y);
				break;
			case B_RECT_TYPE:
				BRect rect;
				hmsg->FindRect(name, j, &rect);
				sprintf(buf, "%.1f,%.1f %.1f,%.1f", rect.left, rect.top, rect.right, rect.bottom);
				break;
			case B_RGB_COLOR_TYPE:
			{
				rgb_color *col;
				ssize_t nbyte;
				hmsg->FindData(name, type, j, (void **)&col, &nbyte);
				sprintf(buf, "R%d G%d B%d A%d", col->red, col->green, col->blue, col->alpha);
			}
				break;
			case B_REF_TYPE:
			{
				entry_ref ref;
				hmsg->FindRef(name, j, &ref);

				BEntry entry(&ref);
				BPath path;
				entry.GetPath(&path);
				sprintf(buf, "[%.60s]", path.Path());
			}
				break;
			case B_POINTER_TYPE:
			{
				void *ptr;
				ssize_t nbyte;
				hmsg->FindData(name, type, j, &ptr, &nbyte);
				sprintf(buf, "%p", ptr);
			}
				break;
			case B_MIME_TYPE:
			{
				void *ptr;
				ssize_t nbyte;
				hmsg->FindData(name, type, j, &ptr, &nbyte);
				sprintf(buf, "%.60s", (char *)ptr);
			}
				break;
			default:
				void *data;
				ssize_t nbyte;

				hmsg->FindData(name, type, j, &data, &nbyte);
				sprintf(buf, "%d bytes at %p", nbyte, data);
				break;
			}
			view->DrawString(buf);

			penpos = view->PenLocation();
			if(penpos.x > maxx)
				maxx = penpos.x;
		}
	}
	*nitem_ptr = nitem;
	*maxx_ptr = maxx;
}

//   ______________________________
// _| MsgInfoView Member Functions |__________________________________________
//

MsgInfoView::MsgInfoView(
	BRect rect,
	char *name
) : BView(rect, name, B_FOLLOW_ALL, B_WILL_DRAW)
{
	hmsg = 0;
	msg_changed = false;
// set spacing to something sensible - change at Attach time
	ascent = 10;
	lineht = ascent+4;
// set item count
	nitem=0;
// zero offscreen bitmap and view
	osbm = 0;
	osvw = 0;
}

MsgInfoView::~MsgInfoView()
{
	if(hmsg)
		delete hmsg;
	if(osbm)
		delete osbm;
}

void
MsgInfoView::AttachedToWindow()
{
	BFont font (be_plain_font);
	SetFont(&font);

	font_height fh[1];

	be_fixed_font->GetHeight(fh);

// change spacing info according to font
	ascent = fh->ascent;
	lineht = fh->ascent + fh->descent + fh->leading;

	SetViewColor (153,203,255);
	SetLowColor (153,203,255);
}

#include <Window.h>
#include <Region.h>

void
MsgInfoView::Draw(BRect /*updrect*/)
{
/*
	BRegion temp;
	GetClippingRegion(&temp);
*/

	if(hmsg == 0)
	{
		MovePenTo(2, lineht);
		DrawString("No Messages");
	}
	else if(msg_changed)
	{
		float maxx;

		msg_changed = false;	// ok, we've taken note that the msg changed

	//--[decode the message, and write it to the view]--
		DecodeMsg (this, hmsg, ascent, lineht, &nitem, &maxx);

	//--[delete the old offscreen-bitmap]--
		if(osbm != 0)
		{
			delete osbm; // osvw is also deleted by osbm decsructor
			osbm = 0;
			osvw = 0;
		}
		BRect osbmframe (0,0, floor(maxx), floor(nitem*lineht) );
	
	//--[now we have enough info to tell the Window]--
		{
			char whatstr[8+1];
			seewhat(hmsg->what, whatstr);
			BMessage *chg_msg = new BMessage (MSG_CHANGED);
			chg_msg->AddString("newtitle", whatstr);
			chg_msg->AddRect("osbmframe", osbmframe);
			Window()->PostMessage (chg_msg);
		}

	//--[create the new offscreen-bitmap and view]--
		osbm = new BBitmap (osbmframe, B_RGB_32_BIT, TRUE);
		osvw = new BView (osbmframe, "offscreen", B_FOLLOW_NONE, B_WILL_DRAW);

	// make the view a child of the bitmap
		osbm->AddChild(osvw);
	
	// now draw in the bitmap
		osbm->Lock();
		osvw->SetLowColor (LowColor());
		osvw->FillRect (osbmframe, B_SOLID_LOW );

		DecodeMsg (osvw, hmsg, ascent, lineht, &nitem, &maxx);

		osvw->Sync();
		osbm->Unlock();
	}
	else
	{
	// BLIT!
		BRect bnds = osbm->Bounds();
		DrawBitmap (osbm, bnds, bnds);
	}
}

void
MsgInfoView::MessageReceived (
	BMessage *msg
)
{
// ignore replies - they are full of junk!
	if( msg->WasDropped() && !msg->IsReply() )
	{
	// replace held msg with this one
	// delete old held-msg first
		delete hmsg;	// zero-safe
		hmsg = new BMessage (msg);
		msg_changed = true;

	// remove drop-point info from copy
		hmsg->RemoveName("_drop_point_");
		hmsg->RemoveName("_drop_offset_");

	// tell the view of the change
		Invalidate();
	}
	else 
	{
	// pass it on like a good boy
		BView::MessageReceived(msg);
	}
}

#include <math.h>

#define STARTDRAG 10.0

void
MsgInfoView::MouseDown (
	BPoint droppt
)
{
	BPoint dragpt = droppt;
	uint32 buttons;
	double pyth = 0.0;

// determine mouse action
	do {
		snooze(30*1000);
		GetMouse(&dragpt, &buttons);
		if(buttons)
		{
			pyth = hypot(dragpt.x-droppt.x, dragpt.y-droppt.y);
		}
	} while ( buttons && pyth < STARTDRAG );

// if the mouse moved, start draggin'
	if(pyth >= STARTDRAG)
	{
	// bitmap for dragging
		BRect lettershape(0,0, 31,19);
		BBitmap *letter_bm = new BBitmap (lettershape, B_MONOCHROME_1_BIT);
	// exception possible!!
		extern uint32 letter_bits[];
		letter_bm->SetBits (letter_bits, 20*4, 0, B_MONOCHROME_1_BIT);

		DragMessage(hmsg, letter_bm, BPoint(30,18));
	// DragMessage deletes the BitMap!!
	}

#ifdef INTERPRET_BYTES	//-[
// otherwise interpret bytes of item
	else
	{
		float cell = floor(droppt.y / lineht);
		int32 icell = (int32)cell;
		if(icell < nitem)
		{
			char *name;
			type_code code;
			int32 count;
			int32 jindex;

		// since BMessage doesn't let us get what we want directly,
		// we have to loop round :-(

			icell++; // need the 'natural' position of the item!

			for(int32 i=0,n=0;
				n<icell &&
				hmsg->GetInfo(B_ANY_TYPE, i, &name, &code, &count) == B_NO_ERROR;
				i++
			)
			{
			// loop round grouped items
				for(jindex=0; n<icell && jindex<count; jindex++,n++)
					;
			}
			void *data;
			ssize_t nbyte;
			jindex--; // jindex is 'natural' - convert to C numbering
			hmsg->FindData(name, code, jindex, &data, &nbyte);

				char whatstr[8+1];
				seewhat(code, whatstr);
printf("[%s|%s|%d/%d|%d bytes at %p]\n", name, whatstr, jindex, count, nbyte, data);
		}
	}
#endif // INTERPRET_BYTES-]
}

status_t
MsgInfoView::HedgeHog(
	BDataIO *obj,
	ssize_t * nbyteptr
)
{
	return hmsg->Flatten(obj, nbyteptr);
}

status_t
MsgInfoView::BlowJob (
	BDataIO *obj
)
{
	if(hmsg == 0)
		hmsg = new BMessage ('crap');
	msg_changed = true;
	Invalidate();
	return hmsg->Unflatten(obj);
}

