#ifndef MESSAGE_VIEW_H
#define MESSAGE_VIEW_H

#ifndef _VIEW_H
#include <View.h>
#endif

#include <Bitmap.h>

class MsgInfoView : public BView
{
	bool msg_changed;	// flag to tell Draw that another message was dropped
	BMessage *hmsg;	// the current (held) message
	float ascent;	// font ascent
	float lineht;	// line height
	uint32 nitem;	// number of items in message
	//BBitmap *letter_bm;	// bitmap for D&D
	BBitmap *osbm;	// offscreen bitmap
	BView *osvw;	// offscreen view
public:
	MsgInfoView(BRect frame, char *name); 
	~MsgInfoView(); 
	virtual void AttachedToWindow();
	virtual void Draw(BRect);
	virtual void MessageReceived (BMessage *);
	virtual void MouseDown (BPoint);

	void SetMessage (BMessage *x) { hmsg = new BMessage(x); };

	status_t HedgeHog(BDataIO *, ssize_t *);
	status_t BlowJob(BDataIO *);
};

#define MSG_CHANGED '\247chg'

#endif
