//******************************************************************************
//
//	File:		main.cpp
//
//	Copyright 1993-95, Be Incorporated
//
//******************************************************************************


#include <Debug.h>

#ifndef _OS_H
#include <OS.h>
#endif
#ifndef _APPLICATION_H
#include <Application.h>
#endif
#ifndef _ROSTER_H
#include <Roster.h>
#endif
#ifndef	_BITMAP_H
#include <Bitmap.h>
#endif
#ifndef _MENU_ITEM_H
#include <MenuItem.h>
#endif
#ifndef _MENU_H
#include <Menu.h>
#endif
#ifndef _MENU_BAR_H
#include <MenuBar.h>
#endif
#ifndef	_SCROLL_VIEW_H
#include <ScrollView.h>
#endif
#ifndef	_ALERT_H
#include <Alert.h>
#endif
#ifndef _APPLICATION_H
#include <Application.h>
#endif
#ifndef _BOX_H
#include <Box.h>
#endif

#include <stdio.h>


#include "tsb.h"
#include "lyp10.h"

#include <math.h>

/*------------------------------------------------------------*/
/* Those are the menu item id's of the main window	      */

#define	P1		0x60
#define	P2		0x61
#define	P3		0x62
#define	P4		0x63



/*------------------------------------------------------------*/

class	TMainWindow : public BWindow {
public:
					TMainWindow(BRect bound, char *name, window_type type,
				    			long flags);
virtual		void	MessageReceived(BMessage *an_event);
virtual		bool	QuitRequested();

private:
		TShowBit	*the_view;
};

/*------------------------------------------------------------*/

TMainWindow::TMainWindow(BRect bound, char *name, window_type type, long flags)
	: BWindow(bound, name, type, flags)
{
	BMenu		*a_menu;
	BRect		a_rect;
	BMenuBar	*menubar;
	TShowBit	*my_view;
	BMenuItem	*item;

	Lock();

	a_rect.Set( 0, 0, 1000, 15);
	menubar = new BMenuBar(a_rect, "MB");



	a_menu = new BMenu("File");
	a_menu->AddItem(new BMenuItem("About...", new BMessage(8192)));
	menubar->AddItem(a_menu);
	a_menu->SetRadioMode(TRUE);

	
	a_menu = new BMenu("Palette");
	a_menu->AddItem(item = new BMenuItem("Palette1", new BMessage(P1)));
	a_menu->AddItem(new BMenuItem("Palette2", new BMessage(P2)));
	a_menu->AddItem(new BMenuItem("Palette3", new BMessage(P3)));
	a_menu->AddItem(new BMenuItem("Palette4", new BMessage(P4)));
	menubar->AddItem(a_menu);

	item->SetMarked(TRUE);
	a_menu->SetRadioMode(TRUE);
	
	a_menu = new BMenu("Iterations");
	a_menu->AddItem(new BMenuItem("2", new BMessage(2)));
	a_menu->AddItem(new BMenuItem("4", new BMessage(4)));
	a_menu->AddItem(new BMenuItem("8", new BMessage(8)));
	a_menu->AddItem(item = new BMenuItem("16", new BMessage(16)));
	a_menu->AddItem(new BMenuItem("32", new BMessage(32)));
	a_menu->AddItem(new BMenuItem("64", new BMessage(64)));

	a_menu->AddItem(new BMenuItem("128", new BMessage(128)));
	a_menu->AddItem(new BMenuItem("256", new BMessage(256)));
	a_menu->AddItem(new BMenuItem("384", new BMessage(384)));
	a_menu->AddItem(new BMenuItem("512", new BMessage(512)));

	menubar->AddItem(a_menu);

	item->SetMarked(TRUE);
	a_menu->SetRadioMode(TRUE);

	
	a_menu = new BMenu("Fractal type");
	//a_menu->AddItem(new BMenuItem("Mandelbrot", new BMessage(2048)));
	a_menu->AddItem(item = new BMenuItem("Lyapunov Space", new BMessage(2049)));
	menubar->AddItem(a_menu);

	item->SetMarked(TRUE);
	a_menu->SetRadioMode(TRUE);

	AddChild(menubar);
	double mb_height = menubar->Bounds().Height();

	a_rect.Set(0, mb_height + 1, 188,
									 188);

	the_view = my_view = new TShowBit(a_rect, B_FOLLOW_ALL | B_WILL_DRAW);
  
	AddChild(the_view);
    //AddFloater(the_view->bw);
    
	SetSizeLimits(80, size_x, 80 + 20, size_y + mb_height + 1);
	ResizeTo(size_x, size_y + mb_height + 1);

	SetPulseRate(100000);
	Show();
	Unlock();


}

/*------------------------------------------------------------*/

bool	TMainWindow::QuitRequested()
{
	if (the_view->busy) {
		the_view->stop();
		the_view->exit_now = TRUE;
		PostMessage(B_QUIT_REQUESTED);
		return FALSE;
	}
	
	be_app->PostMessage(B_QUIT_REQUESTED);

	return(TRUE);
}

/*------------------------------------------------------------*/

void	TMainWindow::MessageReceived(BMessage *an_event)
{

	switch(an_event->what) {
		case	P1 :
		case	P2 :
		case	P3 :
		case	P4 :
			the_view->set_palette(an_event->what - P1);
			break;
       
        case 2:
        case 4:
        case 8:
        case 16:
        case 32:
        case 64:
        
		case	128  :
		case	256  :
		case	384  :
		case	512  :
		case	768  :
		case	1024 :
			the_view->set_iter(an_event->what);
			break;
			
			case 2048:
			the_view->stop();
			the_view->jfrac->type=ft_mandelbrot;
			the_view->redraw_fractal();
			break;
			
			case 2049:
			the_view->stop();
			the_view->jfrac->type=ft_lyapunov;
			the_view->jfrac->reset();
			the_view->setcontrols();
			the_view->redraw_fractal();
			break;
	
			case 4096:
			the_view->killthreads();
			break;
			
			case 8192:
			dialog("Lyapunovia 0.10 for BeOS PPC.\n(C) 1997-98 Jesper Juul (jj@pobox.com)\nPPC Recompile by James Dessart (dessart@moebius.qc.ca)\n\nCheck us out for graphics, code and game design: The Planet\nhttp://www.planet.dk");
			break;
	
	}
}




/*------------------------------------------------------------*/

 main()
{
	BApplication	* my_app;
	TMainWindow	*a_window;
	BRect		a_rect;

	set_thread_priority(find_thread(NIL), B_DISPLAY_PRIORITY);
	
	my_app = new BApplication("application/x-vnd.Be-LYAP");

	a_rect.Set(100, 100, 288, 288);
	a_window = new TMainWindow(a_rect, "Lyapunovia 0.10", B_TITLED_WINDOW,
		B_WILL_ACCEPT_FIRST_CLICK);
	my_app->Run();

	delete my_app;
}
