/*
Lille fraktal-program.
00...
01... Og nu har jeg forstet message/quit-strukturen.
02... Fungerer ogs med resize af vinduer.
03... Meget hurtigere-
04... Masser af extra lyap-parametre.
		(Morph, firstx, split, contrast, show.)
		Zoom-funktion.
		Hjre mus genstarter.
      Zoom inkluderer de ekstra parametre...
04... BeOS

*/

#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include <interface/Alert.h> 
 
#include "lyp10.h"




long dialog(char * txt)
{
   BAlert *alert; 
   long result; 
   
   alert = new BAlert("Info", txt, 
                          "OK", 0, NULL, 
                          B_WIDTH_FROM_WIDEST, B_INFO_ALERT); 
   alert->SetShortcut(0, B_ESCAPE); 
   result = alert->Go();
   return result;
   }



JFRACTAL::JFRACTAL()
{
type=ft_lyapunov;
	 doublemin=pow(10,-307);

reset();
}

JFRACTAL::~JFRACTAL()
{
}


void JFRACTAL::setsize(char * _pixels,int _width,int _height,int _widthbytes)
{
pixels=_pixels;
width=_width;
height=_height;
widthbytes=_widthbytes;
exit=exit_restart;

char s[256];
sprintf(s,"setsize - x: %d, y: %d",width,height);
//dialog(s);

}







int JFRACTAL::lyap(uchar * palette,int ylinestep,int ystart)
{
long xpixel,ypixel;
double ypos,xpos;
double morph_ypos;
double firstx_ypos;

double xstep,ystep;

char * pointer;


MSG msg;

char s[256];
sprintf(s,"lyap - x: %d, y: %d",width,height);
//dialog(s);

restart:
exit=exit_no;

if (y_min<doublemin) y_min=doublemin;
if (x_min<doublemin) x_min=doublemin;

if (x_max>8) x_max=8;
if (y_max>8) y_max=8;

x_dx=x_max-x_min;
y_dy=y_max-y_min;

xstep=x_dx/width;
ystep=y_dy/height;

idle:

totalmul=(log(pow(10,split))+log(2))*iterations;
morph2=morph/2;
ynum=iterations/2;
xnum=iterations-ynum;

/*!!!*/
morph2=(morph_min)/2;
yval=y_min+ystart*ystep;
firstx=(firstx_min);

for (ypixel=ystart;(ypixel<height);ypixel+=ylinestep)
 {

/*
  ypos=((double)ypixel/(double)height);
  yval=y_min+ypos*y_dy;

  morph_ypos=morph_min+morph_dy*ypos;
  firstx_ypos=firstx_min+firstx_dy*ypos;
*/

 pointer=pixels+ypixel*widthbytes;
 ymul=log(yval)*ynum;

/*!!!*/
xval=x_min;
 
  for (xpixel=0;(xpixel<width);xpixel++)
	{

/*
	 xpos=((double)xpixel/(double)width);
	 xval=x_min+xpos*x_dx;

	 morph2=(morph_ypos+morph_dx*xpos)/2;
	 firstx=(firstx_ypos+firstx_dx*xpos);
*/
      *pointer++=palette[lyappixel()];
      xval+=xstep;

	if (exit!=exit_no) goto endit;
	}
yval+=ystep*ylinestep;

  }

endit:
if (exit==exit_restart) goto restart;

exit=exit_no;
return TRUE;

}




int JFRACTAL::lyappixel()
{
double  register x=firstx;
double  register total=1;
int  register i=iterations;

double register _yval=yval;
double register _xval=xval;
double register _morph2=morph2;


if (!i) return 0;

do
{
 if (i&1)
  {
	x=x*_yval*(1-x);
	total*=(_morph2-x);
  }
 else
  {
	x=x*_xval*(1-x);
	total*=(_morph2-x)*_xval;
  }
}
while(--i);



total=fabs(total);

if (total<doublemin) total=doublemin;

total=(log(total)+totalmul+ymul)/iterations;

if (total>0)
 {
  if (show&show_plus)
	total=-total;
  else
	return 255;
 }
else
 {
  if (show&show_minus)
	{
	}
  else
	{
	 return 255;
	}
 }

i=(int)(-contrast*total);
if (i>255) i=255;
return i;
}


void JFRACTAL::zoom_out(int x,int y,double scale)
{
double xc,yc;
double dx,dy;

//!!! Ikke komplet ift. morph etc...
dx=(x_max-x_min);
dy=(y_max-y_min);

//xc=x_min+(dx*width)/x;
//yc=y_min+(dy*height)/y;

xc=x_min+dx/2;
yc=y_min+dy/2;

dx*=scale;
dy*=scale;

x_min=xc-dx/2;
x_max=xc+dx/2;
y_min=yc-dy/2;
y_max=yc+dy/2;
}


void JFRACTAL::zoom_setstart(int x,int y)
{
zoom_xmin=x;
zoom_ymin=y;
}


void JFRACTAL::zoom_setend(int x,int y)
{
zoom_xmax=x;
zoom_ymax=y;

int temp;
double xpos,ypos;

		  if (zoom_xmin<0) return;
		  if (zoom_xmax<zoom_xmin)
			{
			 temp=zoom_xmax;
			 zoom_xmax=zoom_xmin;
			 zoom_xmin=temp;
			}
		  if (zoom_ymax<zoom_ymin)
			{
			 temp=zoom_ymax;
			 zoom_ymax=zoom_ymin;
			 zoom_ymin=temp;
			}

		  xpos=((double)zoom_xmin/(double)width);
		  ypos=((double)zoom_ymin/(double)height);
		  morph_min=
			morph_min+xpos*morph_dx+ypos*morph_dy;
		  firstx_min=
			firstx_min+xpos*firstx_dx+ypos*firstx_dy;

		  xpos=((double)zoom_xmax/(double)width);
		  x_max=x_min+xpos*x_dx;
		  xpos=((double)zoom_xmin/(double)width);
		  x_min=x_min+xpos*x_dx;

		  xpos=((zoom_xmax-zoom_xmin)/(double)width);
		  morph_dx=xpos*morph_dx;
		  firstx_dx=xpos*firstx_dx;

		  ypos=((double)zoom_ymax/(double)height);
		  y_max=y_min+ypos*y_dy;
		  ypos=((double)zoom_ymin/(double)height);
		  y_min=y_min+ypos*y_dy;

		  ypos=((zoom_ymax-zoom_ymin)/(double)height);
		  morph_dy=ypos*morph_dy;
		  firstx_dy=ypos*firstx_dy;

		  exit=exit_restart;
}


void JFRACTAL::reset()
{
switch(type)
{
 case ft_lyapunov:
 x_min=2;
 x_max=4;
 y_min=2;
 y_max=4;
 iterations=16;

morph=1;
 morph_min=1;
 morph_dx=0;
 morph_dy=0;

 firstx_min=0.5;
 firstx_dx=.1;
 firstx_dy=.2;

 split=0;
 contrast=128;
 exit=exit_no;
 show=show_minus;
 break;

 default:
 break;
}
exit=exit_restart;
}

