//uInt32ReqWindow.cpp

#define BUILDING_LIB 1

#include <stdio.h>
#include <memory>
//#include <string>
#include <SupportDefs.h>
#include <String.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <float.h>
#include <errno.h>
#include <ctype.h>
#include <Application.h>
#include <Rect.h>
#include <Message.h>
#include <MenuItem.h>
#include <MenuBar.h>
#include <PopUpMenu.h>
#include <Window.h>
#include <View.h>
#include <SupportDefs.h>
#include <Beep.h>
#include <List.h>
#include <TextControl.h>
#include <TextView.h>
#include <ScrollView.h>
#include <Font.h>
#include <OS.h>
#include <Button.h>
#include <StatusBar.h>
#include <CheckBox.h>
#include <PictureButton.h>
#include <ColorControl.h>
#include <RadioButton.h>
#include <Point.h>
#include <TypeConstants.h>
#include <ListView.h>
#include <GraphicsDefs.h>
#include <File.h>
#include <Screen.h>
#include <Alert.h>
#include <Resources.h>
#include <StringView.h>
#include "DmenuMsg.h"
#include "DnumSpecificWindows.h"
#include "s2uint32.h"
#include "warning.h"
#include "windowGuts.h"
#include "uInt32ReqWindow.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "Preferences.h"
#include "myPreferences.h"
#include "verify.h"
#include "uInt32Gadget.h"

UInt32ReqWindow	::	UInt32ReqWindow(	BRect paramBound,
										const char * paramWindowTitle,
										const char * paramScrollViewName,
										const char * paramNamePrefFrame, 
										uint32 * ui32pparamNumber,
										const char * paramGadgetLabel,
										WindowGuts * pparamOwnerWindow)
				: 
					WindowGuts(	paramBound, 
								paramWindowTitle, 
								paramScrollViewName,
								paramNamePrefFrame,
								myPrefs->PrefSignature,
								myPrefs->mpPreferenceSet),
					mpOwnerWindow(pparamOwnerWindow),
					mpUInt32Gadget(NULL),
					number(ui32pparamNumber)
{
	SetFeel(B_FLOATING_SUBSET_WINDOW_FEEL);
	SetFeel(B_FLOATING_SUBSET_WINDOW_FEEL);
	AddToSubset(mpOwnerWindow);
	sem_id calc_sem;
	if ((calc_sem = create_sem(1, "calc_sem")) < B_NO_ERROR)
	{
		warning(myPrefs->FailCreateSemaphore);
		return;
	}
	acquire_sem(calc_sem);
	try 
	{
		LayoutMatrix *	pLayoutMatrix = new LayoutMatrix(BESTSIZE, 1, 1, this);//rows,columns
////////////////////////////////////////////////////////////////////////////////////////////
		mpUInt32Gadget = new UInt32Gadget(	*number,
											"uInt32Gadget", 
											paramGadgetLabel, 
											UINT32GADGETMSG, 
											0,
											pLayoutMatrix);
		release_sem(calc_sem);
		pLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, MATRIXVERTICALOFFSET, calc_sem);
	}	
	catch (...)
	{
		warning(myPrefs->CaughtUInt32ReqWindowCTOR);
		release_sem(calc_sem);
		throw;
	}
	try 
	{
		BMenuItem *	menuItem;
		BMenu * APPMenu = new BMenu(myPrefs->AppMenuLabel);
		menuItem = new BMenuItem(	myPrefs->AboutMenuLabel, 
									new BMessage(ABOUT_INTREQWINDOW));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	myPrefs->PreferenceMenuLabel, 
									new BMessage(PREFSMSG));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	myPrefs->CloseWindow, 
									new BMessage(B_QUIT_REQUESTED));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	myPrefs->QuitMenuLabel, 
									new BMessage(QUIT_APP));
		APPMenu->AddItem(menuItem);
		pMenuBar->AddItem(APPMenu);
	}
	catch(...) 
	{
		warning(myPrefs->CaughtUInt32ReqWindowCTOR);
		throw;
	}
}//end


void 
UInt32ReqWindow	::	MessageReceived(	BMessage *message) 
{
	switch (message->what) 
	{
		case ABOUT_INTREQWINDOW:
			warning(myPrefs->AboutUInt32ReqWindow);
		break;
		case PREFSMSG:
			myPrefs->OpenPreferencesPanel();
		break;
		case QUIT_APP:
			if (Verify(myPrefs->ReallyQuitApp))
			{
				be_app->PostMessage(B_QUIT_REQUESTED);
			}
		break;
		default:
			WindowGuts::MessageReceived(message);
		break;
	}
}//end


UInt32ReqWindow	::	~UInt32ReqWindow() 
{
	BRect frame = Frame();
	myPrefs->SetPreferredUInt32ReqWindowRect(frame);
	if (mpUInt32Gadget) 
	{
		int32 i = s2uint32(mpUInt32Gadget->Text());
		*number = i;
		mpUInt32Gadget->RemoveSelf();
		delete mpUInt32Gadget;
	}
}//end
