//myStringDrawer.cpp

#define BUILDING_LIB 1

#include <stdio.h>
#include <memory>
//#include <string>
#include <SupportDefs.h>
#include <String.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <float.h>
#include <errno.h>
#include <ctype.h>
#include <Application.h>
#include <Rect.h>
#include <Message.h>
#include <MenuItem.h>
#include <MenuBar.h>
#include <PopUpMenu.h>
#include <Window.h>
#include <View.h>
#include <SupportDefs.h>
#include <Beep.h>
#include <List.h>
#include <TextControl.h>
#include <TextView.h>
#include <ScrollView.h>
#include <Font.h>
#include <OS.h>
#include <Button.h>
#include <StatusBar.h>
#include <CheckBox.h>
#include <PictureButton.h>
#include <ColorControl.h>
#include <RadioButton.h>
#include <Point.h>
#include <TypeConstants.h>
#include <ListView.h>
#include <GraphicsDefs.h>
#include <File.h>
#include <Screen.h>
#include <Alert.h>
#include <Resources.h>
#include <StringView.h>
#include "DnumSpecificWindows.h"
#include "layoutMatrixItem.h"
#include "Preferences.h"
#include "myroColour.h"
#include "myStringDrawer.h"
#include "layoutMatrix.h"
#include "textItem.h"
#include "myPreferences.h"
#include "warning.h"

MyStringDrawer	::	~MyStringDrawer() 
{
	delete textItem;
	delete font;
};//end


//ctor
MyStringDrawer	::	MyStringDrawer(	const char * paramName, 
									const char * paramText,
									BFont * pparamFont,
									LayoutMatrix * lpparamLayoutMatrix) 
				: 
					BStringView(	BRect(0, 0, 32, 32),
									paramName, 
									paramText,
									B_FOLLOW_NONE,
									B_WILL_DRAW),
					textItem(	new TextItem(	paramText,
												NULL/*lpparamLayoutMatrix*/))
{
	try
	{
		LayoutMatrixItem * lmi = new LayoutMatrixItem(	(void *)this,
														lpparamLayoutMatrix,
														KIND_STRINGDRAWER);
		lpparamLayoutMatrix->mpLayoutMatrixItems->AddItem((void *)lmi);
	}
	catch (...)
	{
		warning(myPrefs->FailMemory);
		return;
	}
	lpparamLayoutMatrix->AddToChildren((void *)this);
	if (pparamFont)
	{
		font = pparamFont;
	}
	else
	{
		font = new BFont(myPrefs->GetPreferredFont());
	}
	SetFont(font);
}//end


void 
MyStringDrawer	::	AttachedToWindow() 
{
	BView::AttachedToWindow();
	rgb_color tempRgbColor;
	myPrefs->GetPreferredMyStringDrawerHighColor(&tempRgbColor);
	SetHighColor(tempRgbColor);
	myPrefs->GetPreferredMyStringDrawerLowColor(&tempRgbColor);
	SetLowColor(tempRgbColor);
	myPrefs->GetPreferredMyStringDrawerViewColor(&tempRgbColor);
	SetViewColor(tempRgbColor);
}//end


void
MyStringDrawer	::	MyGetPreferredSize(	float * fpparamWidth,
										float * fpparamHeight)
{
	BView	bv(BRect(0, 0, 32, 32), "NoShowView", B_FOLLOW_NONE, 0);
	bv.SetFont(font);
	font_height	fontHeight;
	bv.GetFontHeight(&fontHeight);
	descender = fontHeight.descent + fontHeight.leading;
	*fpparamHeight = fontHeight.ascent + descender;
	*fpparamWidth = bv.StringWidth(((BStringView *)this)->Text());
	float shear = font->Shear();
	//shear will always be between 45 and 135
	if (shear < 90)
	{
		SetAlignment(B_ALIGN_RIGHT);
	}
	else if (shear > 90)
	{
		SetAlignment(B_ALIGN_LEFT);
	}
}//end


BFont *
MyStringDrawer	::	GetFont(	void) const
{
	return font;
}//end


TextItem *
MyStringDrawer	::	GetTextItem(	void) const
{
	return textItem;
}//end
