//myRadioView

#define BUILDING_LIB 1

#include <stdio.h>
#include <memory>
//#include <string>
#include <SupportDefs.h>
#include <String.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <float.h>
#include <errno.h>
#include <ctype.h>
#include <Application.h>
#include <Rect.h>
#include <Message.h>
#include <MenuItem.h>
#include <MenuBar.h>
#include <PopUpMenu.h>
#include <Window.h>
#include <View.h>
#include <SupportDefs.h>
#include <Beep.h>
#include <List.h>
#include <TextControl.h>
#include <TextView.h>
#include <ScrollView.h>
#include <Font.h>
#include <OS.h>
#include <Button.h>
#include <StatusBar.h>
#include <CheckBox.h>
#include <PictureButton.h>
#include <ColorControl.h>
#include <RadioButton.h>
#include <Point.h>
#include <TypeConstants.h>
#include <ListView.h>
#include <GraphicsDefs.h>
#include <File.h>
#include <Screen.h>
#include <Alert.h>
#include <Resources.h>
#include <StringView.h>
#include "DnumSpecificWindows.h"
#include "layoutMatrixItem.h"
#include "myRadioView.h"
#include "warning.h"
#include "Preferences.h"
#include "layoutMatrix.h"
#include "myPreferences.h"

MyRadioView	::	~MyRadioView() 
{
	//left blank
	//pmList deleted in Initialize()
};//end


//ctor
MyRadioView	::	MyRadioView(	const char * paramName, 
								bool bparamVertical,
								BList * pparamList,
								BFont * pparamFont,
								LayoutMatrix * lpparamLayoutMatrix) 
			: 
				BView(	BRect(0, 0, 32, 32), 
						paramName, 
						B_FOLLOW_NONE, 
						B_WILL_DRAW),
				bmVertical(bparamVertical),
				pmList(pparamList),
				pmFont(pparamFont)
{
	lpparamLayoutMatrix->AddToChildren((void *)this);
	try
	{
		LayoutMatrixItem * lmi = new LayoutMatrixItem(	(void *)this,
														lpparamLayoutMatrix,
														KIND_MYRADIOVIEW);
		lpparamLayoutMatrix->mpLayoutMatrixItems->AddItem((void *)lmi);
	}
	catch (...)
	{
		warning(myPrefs->FailMemory);
		return;
	}
}//end


//do all the real work of construction so we can Fail gracefully
bool 
MyRadioView	::	Initialize(	void) 
{
	//sanity check:
	if (	!pmList 
			|| 
			!pmFont)
	{
		warning(myPrefs->FailRadioInit);
		return false;
	}
	int32 numItems = pmList->CountItems();
	if (!numItems) return true;
	SetFont(pmFont);
	try
	{
		auto_ptr<BList> apButtonList(new BList(/*numItems*/));
		BList * pButtonList = apButtonList.get();
		for (	int i = 0;
				i < numItems;
				i++)
		{
			RadioViewData * rvd = (RadioViewData *)pmList->ItemAt(i);
			BRadioButton * brb = new BRadioButton(	BRect(0, 0, 32, 32), 
													rvd->mLabel,
													rvd->mLabel,
													rvd->pmMsg,
													B_FOLLOW_NONE,
													B_WILL_DRAW);
			AddChild(brb);
			brb->ResizeToPreferred();
			pButtonList->AddItem((void *)brb);
		}
		float pad = 2;
		float localLeft = pad;
		float localTop = pad;
		float widest = 0;
		float tallest = 0;
		float width;
		float height;
		for (	int i = 0;
				i < numItems;
				i++)
		{
			BRadioButton * brb = (BRadioButton *)pButtonList->ItemAt(i);
			brb->MoveTo(localLeft, localTop);
			width = brb->Frame().IntegerWidth();
			height = brb->Frame().IntegerHeight();
			if (width > widest) widest = width;
			if (height > tallest) tallest = height;
			if (bmVertical)
			{
				localTop = localTop + pad + height;
			}
			else//orient horizontal
			{
				localLeft = localLeft + pad + width;
			}
		}
		if (localTop != pad)
		{
			ResizeTo(widest + pad, localTop - pad);
		}
		else//orient horizontal
		{
			ResizeTo(localLeft - pad, tallest + pad);
		}
	}
	catch (...)
	{
		for (	int i = 0;
				i < numItems;
				i++)
		{
			RadioViewData * rvd = (RadioViewData *)pmList->ItemAt(i);
			delete rvd;
		}
		delete pmList;
		warning(myPrefs->FailMemory);
		return false;
	}
	for (	int i = 0;
			i < numItems;
			i++)
	{
		RadioViewData * rvd = (RadioViewData *)pmList->ItemAt(i);
		delete rvd;
	}
	delete pmList;
	return true;
}//end


void 
MyRadioView	::	AttachedToWindow() 
{
	BView::AttachedToWindow();
	rgb_color tempRgbColor;
	myPrefs->GetPreferredMyRadioViewHighColor(&tempRgbColor);
	SetHighColor(tempRgbColor);
	myPrefs->GetPreferredMyRadioViewLowColor(&tempRgbColor);
	SetLowColor(tempRgbColor);
	myPrefs->GetPreferredMyRadioViewViewColor(&tempRgbColor);
	SetViewColor(tempRgbColor);
}//end