//myPreferences.cpp

#define BUILDING_LIB 1
#define NOTX_MYPREF 1
#include <stdio.h>
#include <memory>
//#include <string>
#include <SupportDefs.h>

#include <String.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <float.h>
#include <errno.h>
#include <ctype.h>
#include <Application.h>
#include <Rect.h>
#include <Message.h>
#include <MenuItem.h>
#include <MenuBar.h>
#include <PopUpMenu.h>
#include <Window.h>
#include <View.h>
#include <SupportDefs.h>
#include <Beep.h>
#include <List.h>
#include <TextControl.h>
#include <TextView.h>
#include <ScrollView.h>
#include <Font.h>
#include <OS.h>
#include <Button.h>
#include <StatusBar.h>
#include <CheckBox.h>
#include <PictureButton.h>
#include <ColorControl.h>
#include <RadioButton.h>
#include <Point.h>
#include <TypeConstants.h>
#include <ListView.h>
#include <GraphicsDefs.h>
#include <File.h>
#include <Screen.h>
#include <Alert.h>
#include <Resources.h>
#include <StringView.h>
#include <Path.h>
#include <Entry.h>
#include <Directory.h>
#include "DnumSpecificWindows.h"
#include "DmenuMsg.h"
#include "beGUI_Version.h"
#include "Preferences.h"
#include "myroColour.h"
#include "myPreferences.h"
#include "myButton.h"
#include "stringGadget.h"
#include "uInt32Gadget.h"
#include "warning.h"
#include "fontData.h"
#include "layoutMatrix.h"
#include "colorWell.h"
#include "myColorControl.h"
#include "myTextView.h"
#include "myListView.h"
#include "windowGuts.h"
#include "myCheckBox.h"
#include "specificColorWindow.h"
#include "windowGuts.h"
#include "prefPanelWindow.h"
	

//the following array is also duplicated in specificColorWindow.cpp as lNamePrefFrame[NUMSPECIFICWINDOWS]
const char * namePrefFrame[NUMSPECIFICWINDOWS] = 
{
	"SPECIFICCOLORBUTTON",
	"SPECIFICCOLORPICTURE",
	"SPECIFICCOLORRADIOVIEW",
	"SPECIFICCOLORCHECKBOX",
	"SPECIFICCOLORSTATUSBAR",
	"SPECIFICCOLORCOLORCONTROL",
	"SPECIFICCOLORTEXTVIEW",
	"SPECIFICCOLORINTGADG",
	"SPECIFICCOLORSTRINGGADG",
	"SPECIFICCOLORCOLORWELL",
	"SPECIFICCOLORSTRINGDRAWER",
	"SPECIFICCOLORLISTVIEW",
	"SPECIFICCOLORFLOATGADG"
};

MyPreferences	::	MyPreferences()
				:	preferredFont(new BFont()),
					pPrefPanelWindow(NULL),
					mpPreferenceSet(NULL),
					bPrefChangesMade(false)
{
	myPrefs = this;
	image_info info;
	int32 cookie = 0;
	bool got = get_next_image_info(0, &cookie, &info);
	BEntry theAppEntry(info.name);
	BEntry theAppDir;
	theAppEntry.GetParent(&theAppDir);
	char appLib[MAXPATHLEN + 20];
	BPath appLibPath;
	theAppDir.GetPath(&appLibPath);
	strcpy(appLib, appLibPath.Path());
	strcat(appLib, "/lib");
	BFile refFile;
	BDirectory libDir;
	status_t hasLib = libDir.SetTo(appLib);
	if (hasLib == B_NO_ERROR)
	{
		if (libDir.Contains("libBeGUI.so"))
		{
			strcat(appLib, "/libBeGUI.so");
			refFile.SetTo(appLib, B_READ_ONLY);
		}
		else
		{
			refFile.SetTo("/boot/home/config/lib/libBeGUI.so", B_READ_ONLY);
		}
	}
	else
	{
		refFile.SetTo("/boot/home/config/lib/libBeGUI.so", B_READ_ONLY);
	}
	status_t stat = refFile.InitCheck();
	if (stat == B_NO_ERROR)
	{
		BResources resources;
		stat = resources.SetTo(&refFile);
		if (stat == B_NO_ERROR)
		{
			size_t len;
			VerifyCancel = (const char *)resources.FindResource('CSTR', "VerifyCancel", &len);
			VerifyDoNot = (const char *)resources.FindResource('CSTR', "VerifyDoNot", &len);
			PrefSignature = (const char *)resources.FindResource('CSTR', "BeGUIPreference", &len);
			VerifyDo = (const char *)resources.FindResource('CSTR', "VerifyDo", &len);
			AboutMenuLabel = (const char *)resources.FindResource('CSTR', "AboutMenuLabel", &len);
			FontFamilyPUMLabel = (const char *)resources.FindResource('CSTR', "FontFamilyPUMLabel", &len);
			FontStylePUMLabel = (const char *)resources.FindResource('CSTR', "FontStylePUMLabel", &len);
			AboutPrefPanelWindow = (const char *)resources.FindResource('CSTR', "AboutPrefPanelWindow", &len);
			AboutUInt32ReqWindow = (const char *)resources.FindResource('CSTR', "AboutUInt32ReqWindow", &len);
			AboutFontPrefWindowMsg1 = (const char *)resources.FindResource('CSTR', "AboutFontPrefWindowMsg1", &len);
			AboutFontPrefWindowMsg2 = (const char *)resources.FindResource('CSTR', "AboutFontPrefWindowMsg2", &len);
			AboutFontPrefWindowMsg3 = (const char *)resources.FindResource('CSTR', "AboutFontPrefWindowMsg3", &len);
			AboutFontPrefWindowMsg4 = (const char *)resources.FindResource('CSTR', "AboutFontPrefWindowMsg4", &len);
			AboutFontPrefWindowMsg5 = (const char *)resources.FindResource('CSTR', "AboutFontPrefWindowMsg5", &len);
			AboutFontPrefWindowMsg6 = (const char *)resources.FindResource('CSTR', "AboutFontPrefWindowMsg6", &len);
			AboutGutMsg = (const char *)resources.FindResource('CSTR', "AboutGutMsg", &len);
			AboutBasicColorWindowMsg1 = (const char *)resources.FindResource('CSTR', "AboutBasicColorWindowMsg1", &len);
			AboutBasicColorWindowMsg2 = (const char *)resources.FindResource('CSTR', "AboutBasicColorWindowMsg2", &len);
			AboutSpecColorWindow = (const char *)resources.FindResource('CSTR', "AboutSpecColorWindow", &len);
			AboutFontDisplayWindow = (const char *)resources.FindResource('CSTR', "AboutFontDisplayWindow", &len);
			FailLockLooper = (const char *)resources.FindResource('CSTR', "FailLockLooper", &len);
			ReallyQuitApp = (const char *)resources.FindResource('CSTR', "ReallyQuitApp", &len);
			CaughtFontPrefWindowCTOR = (const char *)resources.FindResource('CSTR', "CaughtFontPrefWindowCTOR", &len);
			CaughtPrefPanelWindowCTOR = (const char *)resources.FindResource('CSTR', "CaughtPrefPanelWindowCTOR", &len);
			NoPrefPanelWindow = (const char *)resources.FindResource('CSTR', "NoPrefPanelWindow", &len);
			CaughtBasicColorWindowCTOR = (const char *)resources.FindResource('CSTR', "CaughtBasicColorWindowCTOR", &len);
			CaughtSpecificColorWindowCTOR = (const char *)resources.FindResource('CSTR', "CaughtSpecificColorWindowCTOR", &len);
			BadSpecColorKindView = (const char *)resources.FindResource('CSTR', "BadSpecColorKindView", &len);
			BadSpecColorKindHigh = (const char *)resources.FindResource('CSTR', "BadSpecColorKindHigh", &len);
			BadSpecColorKindLow = (const char *)resources.FindResource('CSTR', "BadSpecColorKindLow", &len);
			CaughtUInt32ReqWindowCTOR = (const char *)resources.FindResource('CSTR', "CaughtUInt32ReqWindowCTOR", &len);
			WarningOKLabel = (const char *)resources.FindResource('CSTR', "WarningOKLabel", &len);
			FailMemory = (const char *)resources.FindResource('CSTR', "FailMemory", &len);
			FailScrollView = (const char *)resources.FindResource('CSTR', "FailScrollView", &len);
			PreferenceMenuLabel = (const char *)resources.FindResource('CSTR', "PreferenceMenuLabel", &len);
			PrefFailInit = (const char *)resources.FindResource('CSTR', "PrefFailInit", &len);
			PrefFailGetSettings = (const char *)resources.FindResource('CSTR', "PrefFailGetSettings", &len);
			PrefFailSetSettings = (const char *)resources.FindResource('CSTR', "PrefFailSetSettings", &len);
			PreferencePanelWindowTitle = (const char *)resources.FindResource('CSTR', "PreferencePanelWindowTitle", &len);
			PrefsNoSetColorWellHighColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetColorWellHighColor", &len);
			PrefsNoSetolorWellLowColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetolorWellLowColor", &len);
			PrefsNoSetColorWellViewColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetColorWellViewColor", &len);
			PrefsNoSetMyButtonHighColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetMyButtonHighColor", &len);
			PrefsNoSetMyButtonLowColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetMyButtonLowColor", &len);
			PrefsNoSetMyButtonViewColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetMyButtonViewColor", &len);
			PrefsNoSetMyPictureButtonHighColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetMyPictureButtonHighColor", &len);
			PrefsNoSetMyPictureButtonLowColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetMyPictureButtonLowColor", &len);
			PrefsNoSetMyPictureButtonViewColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetMyPictureButtonViewColor", &len);
			PrefsNoSetMyCheckBoxHighColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetMyCheckBoxHighColor", &len);
			PrefsNoSetMyCheckBoxLowColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetMyCheckBoxLowColor", &len);
			PrefsNoSetMyCheckBoxViewColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetMyCheckBoxViewColor", &len);
			PrefsNoSetMyStatusBarHighColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetMyStatusBarHighColor", &len);
			PrefsNoSetMyStatusBarLowColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetMyStatusBarLowColor", &len);
			PrefsNoSetMyStatusBarViewColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetMyStatusBarViewColor", &len);
			PrefsNoSetMyBarColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetMyBarColor", &len);
			PrefsNoSetMyColorControlHighColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetMyColorControlHighColor", &len);
			PrefsNoSetMyColorControlLowColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetMyColorControlLowColor", &len);
			PrefsNoSetMyColorControlViewColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetMyColorControlViewColor", &len);
			PrefsNoSetMyStringDrawerHighColor  = (const char *)resources.FindResource('CSTR', "PrefsNoSetMyStringDrawerHighColor", &len);
			PrefsNoSetMyStringDrawerLowColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetMyStringDrawerLowColor", &len);
			PrefsNoSetMyStringDrawerViewColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetMyStringDrawerViewColor", &len);
			PrefsNoSetMyRadioViewHighColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetMyRadioViewHighColor", &len);
			PrefsNoSetMyRadioViewLowColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetMyRadioViewLowColor", &len);
			PrefsNoSetMyRadioViewViewColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetMyRadioViewViewColor", &len);
			PrefsNoSetMyTextViewHighColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetMyTextViewHighColor", &len);
			PrefsNoSetMyTextViewLowColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetMyTextViewLowColor", &len);
			PrefsNoSetMyTextViewViewColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetMyTextViewViewColor", &len);
			PrefsNoSetUInt32GadgetHighColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetUInt32GadgetHighColor", &len);
			PrefsNoSetUInt32GadgetLowColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetUInt32GadgetLowColor", &len);
			PrefsNoSetUInt32GadgetViewColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetUInt32GadgetViewColor", &len);
			PrefsNoSetFloatGadgetHighColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetFloatGadgetHighColor", &len);
			PrefsNoSetFloatGadgetLowColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetFloatGadgetLowColor", &len);
			PrefsNoSetFloatGadgetViewColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetFloatGadgetViewColor", &len);
			PrefsNoSetHighColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetHighColor", &len);
			PrefsNoSetLowColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetLowColor", &len);
			PrefsNoSetViewColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetViewColor", &len);
			FontPrefWindowTitle = (const char *)resources.FindResource('CSTR', "FontPrefWindowTitle", &len);
			FontPrefWindowHeading1 = (const char *)resources.FindResource('CSTR', "FontPrefWindowHeading1", &len);
			BiggerFontButtonLabel = (const char *)resources.FindResource('CSTR', "BiggerFontButtonLabel", &len);
			SmallerFontButtonLabel = (const char *)resources.FindResource('CSTR', "SmallerFontButtonLabel", &len);
			EnterFontSizeLabel = (const char *)resources.FindResource('CSTR', "EnterFontSizeLabel", &len);
			DisplayFontCheckBoxLabel = (const char *)resources.FindResource('CSTR', "DisplayFontCheckBoxLabel", &len);
			FontDisplayNotNull = (const char *)resources.FindResource('CSTR', "FontDisplayNotNull", &len);
			FontDisplayWindowTitle = (const char *)resources.FindResource('CSTR', "FontDisplayWindowTitle", &len);
			FailFontDisplayWindow = (const char *)resources.FindResource('CSTR', "FailFontDisplayWindow", &len);
			FailMinFontSize = (const char *)resources.FindResource('CSTR', "FailMinFontSize", &len);
			FailMaxFontSize = (const char *)resources.FindResource('CSTR', "FailMaxFontSize", &len);
			PrefsNoSetFont = (const char *)resources.FindResource('CSTR', "PrefsNoSetFont", &len);
			PrefsNoSetOpenFontDisplay = (const char *)resources.FindResource('CSTR', "PrefsNoSetOpenFontDisplay", &len);
			PrefsNoSetUseColorWell = (const char *)resources.FindResource('CSTR', "PrefsNoSetUseColorWell", &len);
			PrefsNoSetUseColorControl = (const char *)resources.FindResource('CSTR', "PrefsNoSetUseColorControl", &len);
			PrefsNoSaveSet = (const char *)resources.FindResource('CSTR', "PrefsNoSaveSet", &len);
			PrefPanelWindowHeading1 = (const char *)resources.FindResource('CSTR', "PrefPanelWindowHeading1", &len);
			PrefPanelFontButtonLabel = (const char *)resources.FindResource('CSTR', "PrefPanelFontButtonLabel", &len);
			PrefPanelWindowHeading2 = (const char *)resources.FindResource('CSTR', "PrefPanelWindowHeading2", &len);
			BarCWLabel = (const char *)resources.FindResource('CSTR', "BarCWLabel", &len);
			BarCCLabel = (const char *)resources.FindResource('CSTR', "BarCCLabel", &len);
			PrefsNoSetMyListViewHighColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetMyListViewHighColor", &len);
			PrefsNoSetMyListViewLowColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetMyListViewLowColor", &len);
			PrefsNoSetMyListViewViewColor = (const char *)resources.FindResource('CSTR', "PrefsNoSetMyListViewViewColor", &len);
			FailCreateSemaphore = (const char *)resources.FindResource('CSTR', "FailCreateSemaphore", &len);
			FailAqSem = (const char *)resources.FindResource('CSTR', "FailAqSem", &len);
			AppMenuLabel = (const char *)resources.FindResource('CSTR', "AppMenuLabel", &len);
			QuitMenuLabel = (const char *)resources.FindResource('CSTR', "QuitMenuLabel", &len);
			CloseWindow = (const char *)resources.FindResource('CSTR', "CloseWindow", &len);
			ScreenNotValid = (const char *)resources.FindResource('CSTR', "ScreenNotValid", &len);
			NotFoundScrollView = (const char *)resources.FindResource('CSTR', "NotFoundScrollView", &len);
			PrefNoSetGutFrame = (const char *)resources.FindResource('CSTR', "PrefNoSetGutFrame", &len);
			S2UI32Neg = (const char *)resources.FindResource('CSTR', "S2UI32Neg", &len);
			S2UI32TooBig = (const char *)resources.FindResource('CSTR', "S2UI32TooBig", &len);
			S2UI32Invalid = (const char *)resources.FindResource('CSTR', "S2UI32Invalid", &len);
			BasicColorWindowHeading1 = (const char *)resources.FindResource('CSTR', "BasicColorWindowHeading1", &len);
			ColorWindowHeading2 = (const char *)resources.FindResource('CSTR', "ColorWindowHeading2", &len);
			ColorWindowHeading3 = (const char *)resources.FindResource('CSTR', "ColorWindowHeading3", &len);
			ColorWindowHeading4 = (const char *)resources.FindResource('CSTR', "ColorWindowHeading4", &len);
			ColorWindowHeading5 = (const char *)resources.FindResource('CSTR', "ColorWindowHeading5", &len);
			ColorWindowHeading6 = (const char *)resources.FindResource('CSTR', "ColorWindowHeading6", &len);
			ColorWindowHeading7 = (const char *)resources.FindResource('CSTR', "ColorWindowHeading7", &len);
			DemoRoNo = (const char *)resources.FindResource('CSTR', "DemoRoNo", &len);
			RoBadMsg = (const char *)resources.FindResource('CSTR', "RoBadMsg", &len);
			BarColorTitle = (const char *)resources.FindResource('CSTR', "BarColorTitle", &len);
			DemoButtonLabel = (const char *)resources.FindResource('CSTR', "DemoButtonLabel", &len);
			DemoRadio1Label = (const char *)resources.FindResource('CSTR', "DemoRadio1Label", &len);
			DemoRadio2Label = (const char *)resources.FindResource('CSTR', "DemoRadio2Label", &len);
			DemoRadio3Label = (const char *)resources.FindResource('CSTR', "DemoRadio3Label", &len);
			DemoRadioFailInit = (const char *)resources.FindResource('CSTR', "DemoRadioFailInit", &len);
			DemoCheckBoxLabel = (const char *)resources.FindResource('CSTR', "DemoCheckBoxLabel", &len);
			DemoSTatusBarLeadLabel = (const char *)resources.FindResource('CSTR', "DemoSTatusBarLeadLabel", &len);
			DemoSTatusBarTrailLabel = (const char *)resources.FindResource('CSTR', "DemoSTatusBarTrailLabel", &len);
			StringGadgetLabel = (const char *)resources.FindResource('CSTR', "StringGadgetLabel", &len);
			TextGadgetLabel = (const char *)resources.FindResource('CSTR', "TextGadgetLabel", &len);
			ListViewSample1 = (const char *)resources.FindResource('CSTR', "ListViewSample1", &len);
			ListViewSample2 = (const char *)resources.FindResource('CSTR', "ListViewSample2", &len);
			ListViewSample3 = (const char *)resources.FindResource('CSTR', "ListViewSample3", &len);
			SelectFromList = (const char *)resources.FindResource('CSTR', "SelectFromList", &len);
			InvokeFromList = (const char *)resources.FindResource('CSTR', "InvokeFromList", &len);
			UInt32GadgetLabel = (const char *)resources.FindResource('CSTR', "UInt32GadgetLabel", &len);
			FloatGadgetLabel = (const char *)resources.FindResource('CSTR', "FloatGadgetLabel", &len);
			DemoRoLabel = (const char *)resources.FindResource('CSTR', "DemoRoLabel", &len);
			DemoTextItemText = (const char *)resources.FindResource('CSTR', "DemoTextItemText", &len);
			BadSpecItemKind = (const char *)resources.FindResource('CSTR', "BadSpecItemKind", &len);
			BadSpecKindQR = (const char *)resources.FindResource('CSTR', "BadSpecKindQR", &len);
			BadSpecKindColorSetView = (const char *)resources.FindResource('CSTR', "BadSpecKindColorSetView", &len);
			BadSpecKindColorSetHigh = (const char *)resources.FindResource('CSTR', "BadSpecKindColorSetHigh", &len);
			BadSpecKindColorSetLow = (const char *)resources.FindResource('CSTR', "BadSpecKindColorSetLow", &len);
			DisplayBColorControls = (const char *)resources.FindResource('CSTR', "DisplayBColorControls", &len);
			DisplayroColourWells = (const char *)resources.FindResource('CSTR', "DisplayroColourWells", &len);
			BasicColorWindowTitle = (const char *)resources.FindResource('CSTR', "BasicColorWindowTitle", &len);
			NoBasicColorWindow = (const char *)resources.FindResource('CSTR', "NoBasicColorWindow", &len);
			NoSpecColorWindow = (const char *)resources.FindResource('CSTR', "NoSpecColorWindow", &len);
			FailPUMInitFontWindow = (const char *)resources.FindResource('CSTR', "FailPUMInitFontWindow", &len);
			FailPUMInit = (const char *)resources.FindResource('CSTR', "FailPUMInit", &len);
			FailRadioInit = (const char *)resources.FindResource('CSTR', "FailRadioInit", &len);
			truncShort = (const char *)resources.FindResource('CSTR', "trunc2short", &len);
			noCCenabled = (const char *)resources.FindResource('CSTR', "noCCenabled", &len);
			NoAdditem = (const char *)resources.FindResource('CSTR', "NoAdditem", &len);
			failMenu = (const char *)resources.FindResource('CSTR', "failMenu", &len);
			AntiAliasFont = (const char *)resources.FindResource('CSTR', "AntiAliasFont", &len);
			EnterBarHeightLabel = (const char *)resources.FindResource('CSTR', "EnterBarHeightLabel", &len);
			PrefsNoSetBarHeight = (const char *)resources.FindResource('CSTR', "PrefsNoSetBarHeight", &len);
			PrefsNoSetAntiAliasFont = (const char *)resources.FindResource('CSTR', "PrefsNoSetAntiAliasFont", &len);
			BMsgAddXFailPUMInit = (const char *)resources.FindResource('CSTR', "BMsgAddXFailPUMInit", &len);
			int32 i = 0;
			buttonLabels[i++] = (const char *)resources.FindResource('CSTR', "buttonLabelsUnderlyingview", &len);
			buttonLabels[i++] = (const char *)resources.FindResource('CSTR', "buttonLabelsButton", &len);
			buttonLabels[i++] = (const char *)resources.FindResource('CSTR', "buttonLabelsPictureButton", &len);
			buttonLabels[i++] = (const char *)resources.FindResource('CSTR', "buttonLabelsRadioButtons", &len);
			buttonLabels[i++] = (const char *)resources.FindResource('CSTR', "buttonLabelsCheckBox", &len);
			buttonLabels[i++] = (const char *)resources.FindResource('CSTR', "buttonLabelsStatusBar", &len);
			buttonLabels[i++] = (const char *)resources.FindResource('CSTR', "buttonLabelsColorControl", &len);
			buttonLabels[i++] = (const char *)resources.FindResource('CSTR', "buttonLabelsText View", &len);
			buttonLabels[i++] = (const char *)resources.FindResource('CSTR', "buttonLabelsUInt32Gadget", &len);
			buttonLabels[i++] = (const char *)resources.FindResource('CSTR', "buttonLabelsStringGadget", &len);
			buttonLabels[i++] = (const char *)resources.FindResource('CSTR', "buttonLabelsroColourColorWell", &len);
			buttonLabels[i++] = (const char *)resources.FindResource('CSTR', "buttonLabelsStringDraw", &len);
			buttonLabels[i++] = (const char *)resources.FindResource('CSTR', "buttonLabelsListView", &len);
			buttonLabels[i] = (const char *)resources.FindResource('CSTR', "buttonLabelsFloatGadget", &len);
			i = 0;
			lvwTitleStr[i++] = (const char *)resources.FindResource('CSTR', "lccpWindowTitleButtonCP", &len);
			lvwTitleStr[i++] = (const char *)resources.FindResource('CSTR', "lccpWindowTitlePictureCP", &len);
			lvwTitleStr[i++] = (const char *)resources.FindResource('CSTR', "lccpWindowTitleRadioButtonCP", &len);
			lvwTitleStr[i++] = (const char *)resources.FindResource('CSTR', "lccpWindowTitleCheckBoxCP", &len);
			lvwTitleStr[i++] = (const char *)resources.FindResource('CSTR', "lccpWindowTitleStatusBarCP", &len);
			lvwTitleStr[i++] = (const char *)resources.FindResource('CSTR', "lccpWindowTitleColorControlCP", &len);
			lvwTitleStr[i++] = (const char *)resources.FindResource('CSTR', "lccpWindowTitleTextviewCP", &len);
			lvwTitleStr[i++] = (const char *)resources.FindResource('CSTR', "lccpWindowTitleUInt32GadgetCP", &len);
			lvwTitleStr[i++] = (const char *)resources.FindResource('CSTR', "lccpWindowTitleString GadgetCP", &len);
			lvwTitleStr[i++] = (const char *)resources.FindResource('CSTR', "lccpWindowTitleroColourColorWellCP", &len);
			lvwTitleStr[i++] = (const char *)resources.FindResource('CSTR', "lccpWindowTitleStringDrawerCP", &len);
			lvwTitleStr[i++] = (const char *)resources.FindResource('CSTR', "lccpWindowTitleListviewCP", &len);
			lvwTitleStr[i] = (const char *)resources.FindResource('CSTR', "lccpWindowTitleFloatGadgetCP", &len);
		}
	}
	mpPreferences = new Preferences(PrefSignature);
	Preferences& mrPreferences = *mpPreferences;
	mpPreferenceSet = new PreferenceSet(	mrPreferences,  
											"hierarchical/extendable/settings", 
											true);
	if (mpPreferences->InitCheck())
	{
		puts(PrefFailInit);
		exit(1);
	}
	if (mpPreferenceSet->InitCheck())
	{
		puts(PrefFailGetSettings);
		exit(2);
	}
	//following is a bunch of prefs stuff set to default if file not found:
	const void * prefData;
	ssize_t prefDataSize;
	uint32 prefDataType = '    ';
	FontData fontData;
	float floatData;
	if (	mpPreferenceSet->GetData(	"FONTDATA_SIZE_TYPE", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != FONTDATA_SIZE_TYPE))
	{
		//fontData.size = use default;
	}
	else
	{
		memcpy(	&floatData, 
				prefData, 
				prefDataSize);
		fontData.size = floatData;
	}
	if (	mpPreferenceSet->GetData(	"FONTDATA_SHEAR_TYPE", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != FONTDATA_SHEAR_TYPE))
	{
		//fontData.shear = use default;
	}
	else
	{
		memcpy(	&floatData, 
				prefData, 
				prefDataSize);
		fontData.shear = floatData;
	}
	if (	mpPreferenceSet->GetData(	"FONTDATA_ROTATION_TYPE", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != FONTDATA_ROTATION_TYPE))
	{
		//fontData.rotation = use default;
	}
	else
	{
		memcpy(	&floatData, 
				prefData, 
				prefDataSize);
		fontData.rotation = floatData;
	}
	uint32 ui32Data;
	if (	mpPreferenceSet->GetData(	"FONTDATA_FLAGS_TYPE", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != FONTDATA_FLAGS_TYPE))
	{
		//fontData.flags = use default;
	}
	else
	{
		memcpy(	&ui32Data, 
				prefData, 
				prefDataSize);
		fontData.flags = ui32Data;
	}
	if (	mpPreferenceSet->GetData(	"FONTDATA_FANDS_TYPE", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != FONTDATA_FANDS_TYPE))
	{
		//fontData.familyAndStyle = use default;
	}
	else
	{
		memcpy(	&ui32Data, 
				prefData, 
				prefDataSize);
		fontData.familyAndStyle = ui32Data;
	}
	uint16 ui16Data;
	if (	mpPreferenceSet->GetData(	"FONTDATA_FACE_TYPE", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != FONTDATA_FACE_TYPE))
	{
		//fontData.face = use default;
	}
	else
	{
		memcpy(	&ui16Data, 
				prefData, 
				prefDataSize);
		fontData.face = ui16Data;
	}
	uint8 ui8Data;
	if (	mpPreferenceSet->GetData(	"FONTDATA_SPACING_TYPE", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != FONTDATA_SPACING_TYPE))
	{
		//fontData.face = use default;
	}
	else
	{
		memcpy(	&ui8Data, 
				prefData, 
				prefDataSize);
		fontData.spacing = ui8Data;
	}
	if (	mpPreferenceSet->GetData(	"FONTDATA_ENOCDING_TYPE", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != FONTDATA_ENOCDING_TYPE))
	{
		//fontData.encoding = use default;
	}
	else
	{
		memcpy(	&ui8Data, 
				prefData, 
				prefDataSize);
		fontData.encoding = ui8Data;
	}
	SetPreferredFontFromData(&fontData);
	if (	mpPreferenceSet->GetData(	"BARHEIGHT", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != BARHEIGHT))
	{
		SetPreferredBarHeight(20);
	}
	else
	{
		memcpy(	&floatData, 
				prefData, 
				prefDataSize);
		SetPreferredBarHeight(floatData);
	}
	bool boolData;
	if (	mpPreferenceSet->GetData(	"OPENFONTDISPLAY_TYPE", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != OPENFONTDISPLAY_TYPE))
	{
		bOpenFontDisplay = true;
	}
	else
	{
		memcpy(	&boolData, 
				prefData, 
				prefDataSize);
		bOpenFontDisplay = boolData;
	}
	if (	mpPreferenceSet->GetData(	"ANTIALIASFONT_TYPE", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != ANTIALIASFONT_TYPE))
	{
		bAntiAliasFont = true;
	}
	else
	{
		memcpy(	&boolData, 
				prefData, 
				prefDataSize);
		bAntiAliasFont = boolData;
	}
	if (	mpPreferenceSet->GetData(	"USECOLORWELL", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != USECOLORWELL))
	{
		bUseColorWell = true;
	}
	else
	{
		memcpy(	&boolData, 
				prefData, 
				prefDataSize);
		bUseColorWell = boolData;
	}
	if (	mpPreferenceSet->GetData(	"USECOLORCONTROL", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != USECOLORCONTROL))
	{
		bUseColorControl = true;
	}
	else
	{
		memcpy(	&boolData, 
				prefData, 
				prefDataSize);
		bUseColorControl = boolData;
	}
	rgb_color prefsColor;
	if (	mpPreferenceSet->GetData(	"PreferredHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 188;
		prefsColor.green = 188;
		prefsColor.blue = 188;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredHighColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 133;
		prefsColor.green = 180;
		prefsColor.blue = 255;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredLowColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{

		prefsColor.red = 188;
		prefsColor.green = 188;
		prefsColor.blue = 188;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredViewColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredColorWellHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 20;
		prefsColor.green = 70;
		prefsColor.blue = 225;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredColorWellHighColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredColorWellLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 15;
		prefsColor.green = 241;
		prefsColor.blue = 22;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredColorWellLowColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredColorWellViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 221;
		prefsColor.green = 28;
		prefsColor.blue = 28;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredColorWellViewColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredUInt32GadgetHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 250;
		prefsColor.green = 0;
		prefsColor.blue = 43;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredUInt32GadgetHighColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredUInt32GadgetLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 250;
		prefsColor.green = 215;
		prefsColor.blue = 250;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredUInt32GadgetLowColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredUInt32GadgetViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 0;
		prefsColor.green = 0;
		prefsColor.blue = 79;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredUInt32GadgetViewColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredFloatGadgetHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 250;
		prefsColor.green = 0;
		prefsColor.blue = 43;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredFloatGadgetHighColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredFloatGadgetLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 250;
		prefsColor.green = 215;
		prefsColor.blue = 250;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredFloatGadgetLowColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredFloatGadgetViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 0;
		prefsColor.green = 0;
		prefsColor.blue = 79;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredFloatGadgetViewColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredStringGadgetHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 250;
		prefsColor.green = 0;
		prefsColor.blue = 43;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredStringGadgetHighColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredStringGadgetLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 250;
		prefsColor.green = 215;
		prefsColor.blue = 250;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredStringGadgetLowColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredStringGadgetViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 0;
		prefsColor.green = 0;
		prefsColor.blue = 79;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredStringGadgetViewColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredColorWellHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 0;
		prefsColor.green = 243;
		prefsColor.blue = 0;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredColorWellHighColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredColorWellLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 0;
		prefsColor.green = 0;
		prefsColor.blue = 250;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredColorWellLowColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredColorWellViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 223;
		prefsColor.green = 0;
		prefsColor.blue = 0;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredColorWellViewColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredMyButtonHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 0;
		prefsColor.green = 250;
		prefsColor.blue = 0;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyButtonHighColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredMyButtonLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 221;
		prefsColor.green = 0;
		prefsColor.blue = 0;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyButtonLowColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredMyButtonViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 232;
		prefsColor.green = 232;
		prefsColor.blue = 232;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyButtonViewColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredMyPictureButtonHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 209;
		prefsColor.green = 209;
		prefsColor.blue = 250;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyPictureButtonHighColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredMyPictureButtonLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 0;
		prefsColor.green = 0;
		prefsColor.blue = 250;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyPictureButtonLowColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredMyPictureButtonViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 188;
		prefsColor.green = 188;
		prefsColor.blue = 188;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyPictureButtonViewColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredMyCheckBoxHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 180;
		prefsColor.green = 221;
		prefsColor.blue = 122;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyCheckBoxHighColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredMyCheckBoxLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 34;
		prefsColor.green = 81;
		prefsColor.blue = 23;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyCheckBoxLowColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredMyCheckBoxViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 4;
		prefsColor.green = 7;
		prefsColor.blue = 38;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyCheckBoxViewColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredMyStatusBarHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 240;
		prefsColor.green = 230;
		prefsColor.blue = 0;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyStatusBarHighColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredMyStatusBarLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 200;
		prefsColor.green = 164;
		prefsColor.blue = 11;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyStatusBarLowColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredMyStatusBarViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 230;
		prefsColor.green = 120;
		prefsColor.blue = 44;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyStatusBarViewColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredMyBarColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 23;
		prefsColor.green = 12;
		prefsColor.blue = 164;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyBarColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredMyColorControlHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 212;
		prefsColor.green = 192;
		prefsColor.blue = 223;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyColorControlHighColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredMyColorControlLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 143;
		prefsColor.green = 243;
		prefsColor.blue = 43;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyColorControlLowColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredMyColorControlViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 192;
		prefsColor.green = 192;
		prefsColor.blue = 113;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyColorControlViewColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredMyStringDrawerHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
//		prefsColor.red = 209;
//		prefsColor.green = 23;
//		prefsColor.blue = 209;
		prefsColor.red = 0;
		prefsColor.green = 0;
		prefsColor.blue = 0;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyStringDrawerHighColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredMyStringDrawerLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{

		prefsColor.red = 200;
		prefsColor.green = 200;
		prefsColor.blue = 200;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyStringDrawerLowColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredMyStringDrawerViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 143;
		prefsColor.green = 0;
		prefsColor.blue = 145;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyStringDrawerViewColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredMyRadioViewHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 0;
		prefsColor.green = 0;
		prefsColor.blue = 0;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyRadioViewHighColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredMyRadioViewLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{

		prefsColor.red = 0;
		prefsColor.green = 0;
		prefsColor.blue = 0;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyRadioViewLowColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredMyRadioViewViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 122;
		prefsColor.green = 23;
		prefsColor.blue = 110;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyRadioViewViewColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredMyTextViewHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{

		prefsColor.red = 250;
		prefsColor.green = 250;
		prefsColor.blue = 250;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyTextViewHighColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredMyTextViewLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{

		prefsColor.red = 25;
		prefsColor.green = 25;
		prefsColor.blue = 25;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyTextViewLowColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredMyTextViewViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 25;
		prefsColor.green = 25;
		prefsColor.blue = 25;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyTextViewViewColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredMyListViewHighColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{

		prefsColor.red = 0;
		prefsColor.green = 0;
		prefsColor.blue = 0;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyListViewHighColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredMyListViewLowColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{

		prefsColor.red = 240;
		prefsColor.green = 240;
		prefsColor.blue = 240;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyListViewLowColor(&prefsColor);
	if (	mpPreferenceSet->GetData(	"PreferredMyListViewViewColor", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_RGB_COLOR_TYPE))
	{
		prefsColor.red = 255;
		prefsColor.green = 255;
		prefsColor.blue = 255;
		prefsColor.alpha = 255;
	}
	else
	{
		memcpy(	&prefsColor, 
				prefData, 
				prefDataSize);
	}
	SetPreferredMyListViewViewColor(&prefsColor);
	BRect	screenResolutionRect;
	{//I do screen like this so it goes away fast
		BScreen	screen(B_MAIN_SCREEN_ID);
		if(!screen.IsValid()) 
		{//may not be valid, if not, this is not a critical app--bail out as best we can
			puts(ScreenNotValid);
			exit(4);
		}
		screenResolutionRect = screen.Frame();
	}
	BRect windowPrefArea;
	const void * windowPrefAreaData;
	ssize_t windowPrefAreaSize;
	uint32 windowPrefAreaType = '    ';
	if (	mpPreferenceSet->GetData(	"PrefPanelFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
					//the - 17 and - 37 were determined based upon trial and error
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredPrefPanelWindowRect(windowPrefArea);
	if (	mpPreferenceSet->GetData(	"FontPrefFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredFontPrefWindowRect(windowPrefArea);
	if (	mpPreferenceSet->GetData(	"FontDisplayWindowFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredFontDisplayWindowRect(windowPrefArea);
	if (	mpPreferenceSet->GetData(	"BasicColorWindowFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredBasicColorWindowRect(windowPrefArea);
	if (	mpPreferenceSet->GetData(	namePrefFrame[SPECIFIC_COLOR_BUTTON], 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredSpecificColorButtonWindowRect(windowPrefArea);
	if (	mpPreferenceSet->GetData(	namePrefFrame[SPECIFIC_COLOR_PICTURE], 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredSpecificColorPictureButtonWindowRect(windowPrefArea);
	if (	mpPreferenceSet->GetData(	namePrefFrame[SPECIFIC_COLOR_RADIOVIEW], 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredSpecificColorRadioButtonWindowRect(windowPrefArea);
	if (	mpPreferenceSet->GetData(	namePrefFrame[SPECIFIC_COLOR_CHECKBOX], 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredSpecificColorCheckBoxWindowRect(windowPrefArea);
	if (	mpPreferenceSet->GetData(	namePrefFrame[SPECIFIC_COLOR_STATUSBAR], 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredSpecificColorStatusBarWindowRect(windowPrefArea);
	if (	mpPreferenceSet->GetData(	namePrefFrame[SPECIFIC_COLOR_COLORCONTROL], 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredSpecificColorColorControlWindowRect(windowPrefArea);
	if (	mpPreferenceSet->GetData(	namePrefFrame[SPECIFIC_COLOR_TEXTVIEW], 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredSpecificColorTextViewWindowRect(windowPrefArea);
	if (	mpPreferenceSet->GetData(	namePrefFrame[SPECIFIC_COLOR_LISTVIEW], 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredSpecificColorListViewWindowRect(windowPrefArea);
	if (	mpPreferenceSet->GetData(	namePrefFrame[SPECIFIC_COLOR_INTGADG], 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredSpecificColorUInt32GadgetWindowRect(windowPrefArea);
	if (	mpPreferenceSet->GetData(	namePrefFrame[SPECIFIC_COLOR_FLOATGADG], 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredSpecificColorFloatGadgetWindowRect(windowPrefArea);
	if (	mpPreferenceSet->GetData(	namePrefFrame[SPECIFIC_COLOR_STRINGGADG], 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredSpecificColorStringGadgetWindowRect(windowPrefArea);
	if (	mpPreferenceSet->GetData(	namePrefFrame[SPECIFIC_COLOR_COLORWELL], 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredSpecificColorColorWellWindowRect(windowPrefArea);
	if (	mpPreferenceSet->GetData(	namePrefFrame[SPECIFIC_COLOR_STRINGDRAWER], 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredSpecificColorStringDrawerWindowRect(windowPrefArea);
	if (	mpPreferenceSet->GetData(	"UInt32ReqWindowFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredUInt32ReqWindowRect(windowPrefArea);
	if (	mpPreferenceSet->GetData(	"ListViewWindowFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredListViewWindowRect(windowPrefArea);
}//end


MyPreferences	::	~MyPreferences() 
{
	bool allSetsOK = true;
	rgb_color tempRgbColor;
	GetPreferredColorWellHighColor(&tempRgbColor);
	if (mpPreferenceSet->SetData(	"PreferredColorWellHighColor", 
									&tempRgbColor, 
									sizeof(tempRgbColor), 
									B_RGB_COLOR_TYPE))
	{
		warning(PrefsNoSetColorWellHighColor);
		allSetsOK = false;
	}
	if (allSetsOK) 
	{
		GetPreferredColorWellLowColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredColorWellLowColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetolorWellLowColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredColorWellViewColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredColorWellViewColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetColorWellViewColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredUInt32GadgetHighColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredUInt32GadgetHighColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetUInt32GadgetHighColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredFloatGadgetHighColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredFloatGadgetHighColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetFloatGadgetHighColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyButtonHighColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredMyButtonHighColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyButtonHighColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyButtonLowColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredMyButtonLowColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyButtonLowColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyButtonViewColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredMyButtonViewColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyButtonViewColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyPictureButtonHighColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredMyPictureButtonHighColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyPictureButtonHighColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyPictureButtonLowColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredMyPictureButtonLowColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyPictureButtonLowColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyPictureButtonViewColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredMyPictureButtonViewColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyPictureButtonViewColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyCheckBoxHighColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredMyCheckBoxHighColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyCheckBoxHighColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyCheckBoxLowColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredMyCheckBoxLowColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyCheckBoxLowColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyCheckBoxViewColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredMyCheckBoxViewColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyCheckBoxViewColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyBarColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredMyBarColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyBarColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyStatusBarHighColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredMyStatusBarHighColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyStatusBarHighColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyStatusBarLowColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredMyStatusBarLowColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyStatusBarLowColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyStatusBarViewColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredMyStatusBarViewColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyStatusBarViewColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyColorControlHighColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredMyColorControlHighColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyColorControlHighColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyColorControlLowColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredMyColorControlLowColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyColorControlLowColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyColorControlViewColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredMyColorControlViewColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyColorControlViewColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyStringDrawerHighColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredMyStringDrawerHighColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyStringDrawerHighColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyStringDrawerLowColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredMyStringDrawerLowColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyStringDrawerLowColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyStringDrawerViewColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredMyStringDrawerViewColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyStringDrawerViewColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyRadioViewHighColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredMyRadioViewHighColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyRadioViewHighColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyRadioViewLowColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredMyRadioViewLowColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyRadioViewLowColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyRadioViewViewColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredMyRadioViewViewColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyRadioViewViewColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyTextViewHighColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredMyTextViewHighColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyTextViewHighColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyTextViewLowColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredMyTextViewLowColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyTextViewLowColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyTextViewViewColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredMyTextViewViewColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyTextViewViewColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyListViewHighColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredMyListViewHighColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyListViewHighColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyListViewLowColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredMyListViewLowColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyListViewLowColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredMyListViewViewColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredMyListViewViewColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetMyListViewViewColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredUInt32GadgetLowColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredUInt32GadgetLowColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetUInt32GadgetLowColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredUInt32GadgetViewColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredUInt32GadgetViewColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetUInt32GadgetViewColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredFloatGadgetLowColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredFloatGadgetLowColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetFloatGadgetLowColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredFloatGadgetViewColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredFloatGadgetViewColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetFloatGadgetViewColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredHighColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredHighColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetHighColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredLowColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredLowColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetLowColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		GetPreferredViewColor(&tempRgbColor);
		if (mpPreferenceSet->SetData(	"PreferredViewColor", 
										&tempRgbColor, 
										sizeof(tempRgbColor), 
										B_RGB_COLOR_TYPE))
		{
			warning(PrefsNoSetViewColor);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		FontData windowFontData(GetPreferredFont());
		if (mpPreferenceSet->SetData(	"FONTDATA_SIZE_TYPE", 
										&windowFontData.size, 
										sizeof(windowFontData.size), 
										FONTDATA_SIZE_TYPE))
		{
			warning(PrefsNoSetFont);
			allSetsOK = false;
		}
		if (allSetsOK) 
		{
			if (mpPreferenceSet->SetData(	"FONTDATA_SHEAR_TYPE", 
											&windowFontData.shear, 
											sizeof(windowFontData.shear), 
											FONTDATA_SHEAR_TYPE))
			{
				warning(PrefsNoSetFont);
				allSetsOK = false;
			}
		}
		if (allSetsOK) 
		{
			if (mpPreferenceSet->SetData(	"FONTDATA_ROTATION_TYPE", 
											&windowFontData.rotation, 
											sizeof(windowFontData.rotation), 
											FONTDATA_ROTATION_TYPE))
			{
				warning(PrefsNoSetFont);
				allSetsOK = false;
			}
		}
		if (allSetsOK) 
		{
			if (mpPreferenceSet->SetData(	"FONTDATA_FLAGS_TYPE", 
											&windowFontData.flags, 
											sizeof(windowFontData.flags), 
											FONTDATA_FLAGS_TYPE))
			{
				warning(PrefsNoSetFont);
				allSetsOK = false;
			}
		}
		if (allSetsOK) 
		{
			if (mpPreferenceSet->SetData(	"FONTDATA_FACE_TYPE", 
											&windowFontData.face, 
											sizeof(windowFontData.face), 
											FONTDATA_FACE_TYPE))
			{
				warning(PrefsNoSetFont);
				allSetsOK = false;
			}
		}
		if (allSetsOK) 
		{
			if (mpPreferenceSet->SetData(	"FONTDATA_SPACING_TYPE", 
											&windowFontData.spacing, 
											sizeof(windowFontData.spacing), 
											FONTDATA_SPACING_TYPE))
			{
				warning(PrefsNoSetFont);
				allSetsOK = false;
			}
		}
		if (allSetsOK) 
		{
			if (mpPreferenceSet->SetData(	"FONTDATA_ENOCDING_TYPE", 
											&windowFontData.encoding, 
											sizeof(windowFontData.encoding), 
											FONTDATA_ENOCDING_TYPE))
			{
				warning(PrefsNoSetFont);
				allSetsOK = false;
			}
		}
		if (allSetsOK) 
		{
			if (mpPreferenceSet->SetData(	"FONTDATA_FANDS_TYPE", 
											&windowFontData.familyAndStyle, 
											sizeof(windowFontData.familyAndStyle), 
											FONTDATA_FANDS_TYPE))
			{
				warning(PrefsNoSetFont);
				allSetsOK = false;
			}
		}
	}
	if (allSetsOK) 
	{
		if (mpPreferenceSet->SetData(	"OPENFONTDISPLAY_TYPE", 
										&bOpenFontDisplay, 
										sizeof(bOpenFontDisplay), 
										OPENFONTDISPLAY_TYPE))
		{
			warning(PrefsNoSetOpenFontDisplay);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		if (mpPreferenceSet->SetData(	"ANTIALIASFONT_TYPE", 
										&bAntiAliasFont, 
										sizeof(bAntiAliasFont), 
										ANTIALIASFONT_TYPE))
		{
			warning(PrefsNoSetAntiAliasFont);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		float barHeight = GetPreferredBarHeight();
		if (mpPreferenceSet->SetData(	"BARHEIGHT", 
										&barHeight, 
										sizeof(barHeight), 
										BARHEIGHT))
		{
			warning(PrefsNoSetBarHeight);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		if (mpPreferenceSet->SetData(	"USECOLORWELL", 
										&bUseColorWell, 
										sizeof(bUseColorWell), 
										USECOLORWELL))
		{
			warning(PrefsNoSetUseColorWell);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		if (mpPreferenceSet->SetData(	"USECOLORCONTROL", 
										&bUseColorControl, 
										sizeof(bUseColorControl), 
										USECOLORCONTROL))
		{
			warning(PrefsNoSetUseColorControl);
			allSetsOK = false;
		}
	}
	if (allSetsOK)
	{
		if (mpPreferenceSet->Save())
		{
			warning(PrefsNoSaveSet);
		}
	}
	delete preferredFont;
	if (pPrefPanelWindow)
	{
		pPrefPanelWindow->PostMessage(B_QUIT_REQUESTED);
	}
	free ((char *)VerifyCancel);
	free ((char *)AntiAliasFont);
	free ((char *)NoAdditem);
	free ((char *)failMenu);
	free ((char *)PrefsNoSetAntiAliasFont);
	free ((char *)EnterBarHeightLabel);
	free ((char *)PrefsNoSetBarHeight);
	free ((char *)BMsgAddXFailPUMInit);
	free ((char *)VerifyDoNot);
	free ((char *)PrefSignature);
	free ((char *)VerifyDo);
	free ((char *)AboutMenuLabel);
	free ((char *)FontFamilyPUMLabel);
	free ((char *)FontStylePUMLabel);
	free ((char *)AboutPrefPanelWindow);
	free ((char *)AboutUInt32ReqWindow);
	free ((char *)AboutFontPrefWindowMsg1);
	free ((char *)AboutFontPrefWindowMsg2);
	free ((char *)AboutFontPrefWindowMsg3);
	free ((char *)AboutFontPrefWindowMsg4);
	free ((char *)AboutFontPrefWindowMsg5);
	free ((char *)AboutFontPrefWindowMsg6);
	free ((char *)AboutGutMsg);
	free ((char *)AboutBasicColorWindowMsg1);
	free ((char *)AboutBasicColorWindowMsg2);
	free ((char *)AboutSpecColorWindow);
	free ((char *)AboutFontDisplayWindow);
	free ((char *)FailLockLooper);
	free ((char *)ReallyQuitApp);
	free ((char *)CaughtFontPrefWindowCTOR);
	free ((char *)CaughtPrefPanelWindowCTOR);
	free ((char *)NoPrefPanelWindow);
	free ((char *)CaughtBasicColorWindowCTOR);
	free ((char *)CaughtSpecificColorWindowCTOR);
	free ((char *)BadSpecColorKindView);
	free ((char *)BadSpecColorKindHigh);
	free ((char *)BadSpecColorKindLow);
	free ((char *)CaughtUInt32ReqWindowCTOR);
	free ((char *)WarningOKLabel);
	free ((char *)FailMemory);
	free ((char *)FailScrollView);
	free ((char *)PreferenceMenuLabel);
	free ((char *)PrefFailInit);
	free ((char *)PrefFailGetSettings);
	free ((char *)PrefFailSetSettings);
	free ((char *)PreferencePanelWindowTitle);
	free ((char *)PrefsNoSetColorWellHighColor);
	free ((char *)PrefsNoSetolorWellLowColor);
	free ((char *)PrefsNoSetColorWellViewColor);
	free ((char *)PrefsNoSetMyButtonHighColor);
	free ((char *)PrefsNoSetMyButtonLowColor);
	free ((char *)PrefsNoSetMyButtonViewColor);
	free ((char *)PrefsNoSetMyPictureButtonHighColor);
	free ((char *)PrefsNoSetMyPictureButtonLowColor);
	free ((char *)PrefsNoSetMyPictureButtonViewColor);
	free ((char *)PrefsNoSetMyCheckBoxHighColor);
	free ((char *)PrefsNoSetMyCheckBoxLowColor);
	free ((char *)PrefsNoSetMyCheckBoxViewColor);
	free ((char *)PrefsNoSetMyStatusBarHighColor);
	free ((char *)PrefsNoSetMyStatusBarLowColor);
	free ((char *)PrefsNoSetMyStatusBarViewColor);
	free ((char *)PrefsNoSetMyBarColor);
	free ((char *)PrefsNoSetMyColorControlHighColor);
	free ((char *)PrefsNoSetMyColorControlLowColor);
	free ((char *)PrefsNoSetMyColorControlViewColor);
	free ((char *)PrefsNoSetMyStringDrawerHighColor);
	free ((char *)PrefsNoSetMyStringDrawerLowColor);
	free ((char *)PrefsNoSetMyStringDrawerViewColor);
	free ((char *)PrefsNoSetMyRadioViewHighColor);
	free ((char *)PrefsNoSetMyRadioViewLowColor);
	free ((char *)PrefsNoSetMyRadioViewViewColor);
	free ((char *)PrefsNoSetMyTextViewHighColor);
	free ((char *)PrefsNoSetMyTextViewLowColor);
	free ((char *)PrefsNoSetMyTextViewViewColor);
	free ((char *)PrefsNoSetUInt32GadgetHighColor);
	free ((char *)PrefsNoSetUInt32GadgetLowColor);
	free ((char *)PrefsNoSetUInt32GadgetViewColor);
	free ((char *)PrefsNoSetFloatGadgetHighColor);
	free ((char *)PrefsNoSetFloatGadgetLowColor);
	free ((char *)PrefsNoSetFloatGadgetViewColor);
	free ((char *)PrefsNoSetHighColor);
	free ((char *)PrefsNoSetLowColor);
	free ((char *)PrefsNoSetViewColor);
	free ((char *)FontPrefWindowTitle);
	free ((char *)FontPrefWindowHeading1);
	free ((char *)BiggerFontButtonLabel);
	free ((char *)SmallerFontButtonLabel);
	free ((char *)EnterFontSizeLabel);
	free ((char *)DisplayFontCheckBoxLabel);
	free ((char *)FontDisplayNotNull);
	free ((char *)FontDisplayWindowTitle);
	free ((char *)FailFontDisplayWindow);
	free ((char *)FailMinFontSize);
	free ((char *)FailMaxFontSize);
	free ((char *)PrefsNoSetFont);
	free ((char *)PrefsNoSetOpenFontDisplay);
	free ((char *)PrefsNoSetUseColorWell);
	free ((char *)PrefsNoSetUseColorControl);
	free ((char *)PrefsNoSaveSet);
	free ((char *)PrefPanelWindowHeading1);
	free ((char *)PrefPanelFontButtonLabel);
	free ((char *)PrefPanelWindowHeading2);
	free ((char *)BarCWLabel);
	free ((char *)BarCCLabel);
	free ((char *)PrefsNoSetMyListViewHighColor);
	free ((char *)PrefsNoSetMyListViewLowColor);
	free ((char *)PrefsNoSetMyListViewViewColor);
	free ((char *)FailCreateSemaphore);
	free ((char *)FailAqSem);
	free ((char *)AppMenuLabel);
	free ((char *)QuitMenuLabel);
	free ((char *)CloseWindow);
	free ((char *)ScreenNotValid);
	free ((char *)NotFoundScrollView);
	free ((char *)PrefNoSetGutFrame);
	free ((char *)S2UI32Neg);
	free ((char *)S2UI32TooBig);
	free ((char *)S2UI32Invalid);
	free ((char *)BasicColorWindowHeading1);
	free ((char *)ColorWindowHeading2);
	free ((char *)ColorWindowHeading3);
	free ((char *)ColorWindowHeading4);
	free ((char *)ColorWindowHeading5);
	free ((char *)ColorWindowHeading6);
	free ((char *)ColorWindowHeading7);
	free ((char *)DemoRoNo);
	free ((char *)RoBadMsg);
	free ((char *)BarColorTitle);
	free ((char *)DemoButtonLabel);
	free ((char *)DemoRadio1Label);
	free ((char *)DemoRadio2Label);
	free ((char *)DemoRadio3Label);
	free ((char *)DemoRadioFailInit);
	free ((char *)DemoCheckBoxLabel);
	free ((char *)DemoSTatusBarLeadLabel);
	free ((char *)DemoSTatusBarTrailLabel);
	free ((char *)StringGadgetLabel);
	free ((char *)TextGadgetLabel);
	free ((char *)ListViewSample1);
	free ((char *)ListViewSample2);
	free ((char *)ListViewSample3);
	free ((char *)SelectFromList);
	free ((char *)InvokeFromList);
	free ((char *)UInt32GadgetLabel);
	free ((char *)FloatGadgetLabel);
	free ((char *)DemoRoLabel);
	free ((char *)DemoTextItemText);
	free ((char *)BadSpecItemKind);
	free ((char *)BadSpecKindQR);
	free ((char *)BadSpecKindColorSetView);
	free ((char *)BadSpecKindColorSetHigh);
	free ((char *)BadSpecKindColorSetLow);
	free ((char *)DisplayBColorControls);
	free ((char *)DisplayroColourWells);
	free ((char *)BasicColorWindowTitle);
	free ((char *)NoBasicColorWindow);
	free ((char *)NoSpecColorWindow);
	free ((char *)FailPUMInitFontWindow);
	free ((char *)FailPUMInit);
	free ((char *)FailRadioInit);
	free ((char *)truncShort);
	free((char *)noCCenabled);
	uint32 i;
	for (	i = 0;
			i < NUMPREFPANELS;
			i++)
	{	
		free ((char *)buttonLabels[i]);
		free ((char *)lvwTitleStr[i]);
	}
	delete mpPreferenceSet;
	delete mpPreferences;
}//end


BFont *	
MyPreferences	::	GetPreferredFont(		void) const
{
	return preferredFont;
}//end


void
MyPreferences	::	SetPreferredFont(		const BFont * pparamFont)
{
	*preferredFont = *pparamFont;
}//end


void
MyPreferences	::	SetToPreferredFont(		BFont * pparamFont)
{
	pparamFont->SetFamilyAndStyle(	preferredFont->FamilyAndStyle());
	pparamFont->SetSize(	preferredFont->Size());
	pparamFont->SetShear(	preferredFont->Shear());
	pparamFont->SetRotation(	preferredFont->Rotation());
	pparamFont->SetSpacing(	preferredFont->Spacing());
	pparamFont->SetEncoding(	preferredFont->Encoding());
	pparamFont->SetFace(	preferredFont->Face());
	pparamFont->SetFlags(	preferredFont->Flags());
	//?? pparamFont->Direction = preferredFont->Direction;
}//end


void
MyPreferences	::	SetPreferredFontFromData(	FontData * pparamFontData)
{
	preferredFont->SetFamilyAndStyle(pparamFontData->familyAndStyle);
	preferredFont->SetSize(pparamFontData->size);
	preferredFont->SetShear(pparamFontData->shear);
	preferredFont->SetRotation(pparamFontData->rotation);
	preferredFont->SetSpacing(pparamFontData->spacing);
	preferredFont->SetFace(pparamFontData->face);
	preferredFont->SetFlags(pparamFontData->flags);
}//end


void
MyPreferences	::	GetPreferredPrefPanelWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredPrefPanelWindowRect;
}//end


void
MyPreferences	::	SetPreferredPrefPanelWindowRect(	const BRect paramWindowRect)
{
	preferredPrefPanelWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredFontPrefWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredFontPrefWindowRect;
}//end


void
MyPreferences	::	SetPreferredFontPrefWindowRect(	const BRect paramWindowRect)
{
	preferredFontPrefWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredFontDisplayWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredFontDisplayWindowRect;
}//end


void
MyPreferences	::	SetPreferredFontDisplayWindowRect(	const BRect paramWindowRect)
{
	preferredFontDisplayWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredBasicColorWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredBasicColorWindowRect;
}//end


void
MyPreferences	::	SetPreferredBasicColorWindowRect(	const BRect paramWindowRect)
{
	preferredBasicColorWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredSpecificColorButtonWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredSpecificColorButtonWindowRect;
}//end


void
MyPreferences	::	SetPreferredSpecificColorButtonWindowRect(	const BRect paramWindowRect)
{
	preferredSpecificColorButtonWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredSpecificColorPictureButtonWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredSpecificColorPictureButtonWindowRect;
}//end


void
MyPreferences	::	SetPreferredSpecificColorPictureButtonWindowRect(	const BRect paramWindowRect)
{
	preferredSpecificColorPictureButtonWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredSpecificColorRadioButtonWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredSpecificColorRadioButtonWindowRect;
}//end


void
MyPreferences	::	SetPreferredSpecificColorRadioButtonWindowRect(	const BRect paramWindowRect)
{
	preferredSpecificColorRadioButtonWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredSpecificColorCheckBoxWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredSpecificColorCheckBoxWindowRect;
}//end


void
MyPreferences	::	SetPreferredSpecificColorCheckBoxWindowRect(	const BRect paramWindowRect)
{
	preferredSpecificColorCheckBoxWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredSpecificColorStringDrawerWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredSpecificColorStringDrawerWindowRect;
}//end


void
MyPreferences	::	SetPreferredSpecificColorStringDrawerWindowRect(	const BRect paramWindowRect)
{
	preferredSpecificColorStringDrawerWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredUInt32ReqWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredUInt32ReqWindowRect;
}//end


void
MyPreferences	::	SetPreferredUInt32ReqWindowRect(	const BRect paramWindowRect)
{
	preferredUInt32ReqWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredListViewWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredListViewWindowRect;
}//end


void
MyPreferences	::	SetPreferredListViewWindowRect(	const BRect paramWindowRect)
{
	preferredListViewWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredSpecificColorStatusBarWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredSpecificColorStatusBarWindowRect;
}//end


void
MyPreferences	::	SetPreferredSpecificColorStatusBarWindowRect(	const BRect paramWindowRect)
{
	preferredSpecificColorStatusBarWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredSpecificColorColorControlWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredSpecificColorColorControlWindowRect;
}//end


void
MyPreferences	::	SetPreferredSpecificColorColorControlWindowRect(	const BRect paramWindowRect)
{
	preferredSpecificColorColorControlWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredSpecificColorTextViewWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredSpecificColorTextViewWindowRect;
}//end


void
MyPreferences	::	SetPreferredSpecificColorTextViewWindowRect(	const BRect paramWindowRect)
{
	preferredSpecificColorTextViewWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredSpecificColorListViewWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredSpecificColorListViewWindowRect;
}//end


void
MyPreferences	::	SetPreferredSpecificColorListViewWindowRect(	const BRect paramWindowRect)
{
	preferredSpecificColorListViewWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredSpecificColorUInt32GadgetWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredSpecificColorUInt32GadgetWindowRect;
}//end


void
MyPreferences	::	SetPreferredSpecificColorUInt32GadgetWindowRect(	const BRect paramWindowRect)
{
	preferredSpecificColorUInt32GadgetWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredSpecificColorFloatGadgetWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredSpecificColorFloatGadgetWindowRect;
}//end


void
MyPreferences	::	SetPreferredSpecificColorFloatGadgetWindowRect(	const BRect paramWindowRect)
{
	preferredSpecificColorFloatGadgetWindowRect = paramWindowRect;
}//end



void
MyPreferences	::	GetPreferredSpecificColorStringGadgetWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredSpecificColorStringGadgetWindowRect;
}//end


void
MyPreferences	::	SetPreferredSpecificColorStringGadgetWindowRect(	const BRect paramWindowRect)
{
	preferredSpecificColorStringGadgetWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredSpecificColorColorWellWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredSpecificColorColorWellWindowRect;
}//end


void
MyPreferences	::	SetPreferredSpecificColorColorWellWindowRect(	const BRect paramWindowRect)
{
	preferredSpecificColorColorWellWindowRect = paramWindowRect;
}//end


void
MyPreferences	::	GetPreferredHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredHighColor.red;
	pparamRGBColor->green = preferredHighColor.green;
	pparamRGBColor->blue = preferredHighColor.blue;
	pparamRGBColor->alpha = preferredHighColor.alpha;
}//end


void
MyPreferences	::	SetPreferredHighColor(	const rgb_color * pparamRGBColor)
{
	preferredHighColor.red = pparamRGBColor->red;
	preferredHighColor.green = pparamRGBColor->green;
	preferredHighColor.blue = pparamRGBColor->blue;
	preferredHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredLowColor.red;
	pparamRGBColor->green = preferredLowColor.green;
	pparamRGBColor->blue = preferredLowColor.blue;
	pparamRGBColor->alpha = preferredLowColor.alpha;
}//end


void
MyPreferences	::	SetPreferredLowColor(	const rgb_color * pparamRGBColor)
{
	preferredLowColor.red = pparamRGBColor->red;
	preferredLowColor.green = pparamRGBColor->green;
	preferredLowColor.blue = pparamRGBColor->blue;
	preferredLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredViewColor.red;
	pparamRGBColor->green = preferredViewColor.green;
	pparamRGBColor->blue = preferredViewColor.blue;
	pparamRGBColor->alpha = preferredViewColor.alpha;
}//end


void
MyPreferences	::	SetPreferredViewColor(	const rgb_color * pparamRGBColor)
{
	preferredViewColor.red = pparamRGBColor->red;
	preferredViewColor.green = pparamRGBColor->green;
	preferredViewColor.blue = pparamRGBColor->blue;
	preferredViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredUInt32GadgetHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredUInt32GadgetHighColor.red;
	pparamRGBColor->green = preferredUInt32GadgetHighColor.green;
	pparamRGBColor->blue = preferredUInt32GadgetHighColor.blue;
	pparamRGBColor->alpha = preferredUInt32GadgetHighColor.alpha;
}//end


void
MyPreferences	::	SetPreferredUInt32GadgetHighColor(	const rgb_color * pparamRGBColor)
{
	preferredUInt32GadgetHighColor.red = pparamRGBColor->red;
	preferredUInt32GadgetHighColor.green = pparamRGBColor->green;
	preferredUInt32GadgetHighColor.blue = pparamRGBColor->blue;
	preferredUInt32GadgetHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredUInt32GadgetLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredUInt32GadgetLowColor.red;
	pparamRGBColor->green = preferredUInt32GadgetLowColor.green;
	pparamRGBColor->blue = preferredUInt32GadgetLowColor.blue;
	pparamRGBColor->alpha = preferredUInt32GadgetLowColor.alpha;
}//end


void
MyPreferences	::	SetPreferredUInt32GadgetLowColor(	const rgb_color * pparamRGBColor)
{
	preferredUInt32GadgetLowColor.red = pparamRGBColor->red;
	preferredUInt32GadgetLowColor.green = pparamRGBColor->green;
	preferredUInt32GadgetLowColor.blue = pparamRGBColor->blue;
	preferredUInt32GadgetLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredUInt32GadgetViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredUInt32GadgetViewColor.red;
	pparamRGBColor->green = preferredUInt32GadgetViewColor.green;
	pparamRGBColor->blue = preferredUInt32GadgetViewColor.blue;
	pparamRGBColor->alpha = preferredUInt32GadgetViewColor.alpha;
}//end


void
MyPreferences	::	SetPreferredUInt32GadgetViewColor(	const rgb_color * pparamRGBColor)
{
	preferredUInt32GadgetViewColor.red = pparamRGBColor->red;
	preferredUInt32GadgetViewColor.green = pparamRGBColor->green;
	preferredUInt32GadgetViewColor.blue = pparamRGBColor->blue;
	preferredUInt32GadgetViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredFloatGadgetHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredFloatGadgetHighColor.red;
	pparamRGBColor->green = preferredFloatGadgetHighColor.green;
	pparamRGBColor->blue = preferredFloatGadgetHighColor.blue;
	pparamRGBColor->alpha = preferredFloatGadgetHighColor.alpha;
}//end


void
MyPreferences	::	SetPreferredFloatGadgetHighColor(	const rgb_color * pparamRGBColor)
{
	preferredFloatGadgetHighColor.red = pparamRGBColor->red;
	preferredFloatGadgetHighColor.green = pparamRGBColor->green;
	preferredFloatGadgetHighColor.blue = pparamRGBColor->blue;
	preferredFloatGadgetHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredFloatGadgetLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredFloatGadgetLowColor.red;
	pparamRGBColor->green = preferredFloatGadgetLowColor.green;
	pparamRGBColor->blue = preferredFloatGadgetLowColor.blue;
	pparamRGBColor->alpha = preferredFloatGadgetLowColor.alpha;
}//end


void
MyPreferences	::	SetPreferredFloatGadgetLowColor(	const rgb_color * pparamRGBColor)
{
	preferredFloatGadgetLowColor.red = pparamRGBColor->red;
	preferredFloatGadgetLowColor.green = pparamRGBColor->green;
	preferredFloatGadgetLowColor.blue = pparamRGBColor->blue;
	preferredFloatGadgetLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredFloatGadgetViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredFloatGadgetViewColor.red;
	pparamRGBColor->green = preferredFloatGadgetViewColor.green;
	pparamRGBColor->blue = preferredFloatGadgetViewColor.blue;
	pparamRGBColor->alpha = preferredFloatGadgetViewColor.alpha;
}//end


void
MyPreferences	::	SetPreferredFloatGadgetViewColor(	const rgb_color * pparamRGBColor)
{
	preferredFloatGadgetViewColor.red = pparamRGBColor->red;
	preferredFloatGadgetViewColor.green = pparamRGBColor->green;
	preferredFloatGadgetViewColor.blue = pparamRGBColor->blue;
	preferredFloatGadgetViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyCheckBoxHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyCheckBoxHighColor.red;
	pparamRGBColor->green = preferredMyCheckBoxHighColor.green;
	pparamRGBColor->blue = preferredMyCheckBoxHighColor.blue;
	pparamRGBColor->alpha = preferredMyCheckBoxHighColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyCheckBoxHighColor(	const rgb_color * pparamRGBColor)
{
	preferredMyCheckBoxHighColor.red = pparamRGBColor->red;
	preferredMyCheckBoxHighColor.green = pparamRGBColor->green;
	preferredMyCheckBoxHighColor.blue = pparamRGBColor->blue;
	preferredMyCheckBoxHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyCheckBoxLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyCheckBoxLowColor.red;
	pparamRGBColor->green = preferredMyCheckBoxLowColor.green;
	pparamRGBColor->blue = preferredMyCheckBoxLowColor.blue;
	pparamRGBColor->alpha = preferredMyCheckBoxLowColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyCheckBoxLowColor(	const rgb_color * pparamRGBColor)
{
	preferredMyCheckBoxLowColor.red = pparamRGBColor->red;
	preferredMyCheckBoxLowColor.green = pparamRGBColor->green;
	preferredMyCheckBoxLowColor.blue = pparamRGBColor->blue;
	preferredMyCheckBoxLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyCheckBoxViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyCheckBoxViewColor.red;
	pparamRGBColor->green = preferredMyCheckBoxViewColor.green;
	pparamRGBColor->blue = preferredMyCheckBoxViewColor.blue;
	pparamRGBColor->alpha = preferredMyCheckBoxViewColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyCheckBoxViewColor(	const rgb_color * pparamRGBColor)
{
	preferredMyCheckBoxViewColor.red = pparamRGBColor->red;
	preferredMyCheckBoxViewColor.green = pparamRGBColor->green;
	preferredMyCheckBoxViewColor.blue = pparamRGBColor->blue;
	preferredMyCheckBoxViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyPictureButtonHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyPictureButtonHighColor.red;
	pparamRGBColor->green = preferredMyPictureButtonHighColor.green;
	pparamRGBColor->blue = preferredMyPictureButtonHighColor.blue;
	pparamRGBColor->alpha = preferredMyPictureButtonHighColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyPictureButtonHighColor(	const rgb_color * pparamRGBColor)
{
	preferredMyPictureButtonHighColor.red = pparamRGBColor->red;
	preferredMyPictureButtonHighColor.green = pparamRGBColor->green;
	preferredMyPictureButtonHighColor.blue = pparamRGBColor->blue;
	preferredMyPictureButtonHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyPictureButtonLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyPictureButtonLowColor.red;
	pparamRGBColor->green = preferredMyPictureButtonLowColor.green;
	pparamRGBColor->blue = preferredMyPictureButtonLowColor.blue;
	pparamRGBColor->alpha = preferredMyPictureButtonLowColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyPictureButtonLowColor(	const rgb_color * pparamRGBColor)
{
	preferredMyPictureButtonLowColor.red = pparamRGBColor->red;
	preferredMyPictureButtonLowColor.green = pparamRGBColor->green;
	preferredMyPictureButtonLowColor.blue = pparamRGBColor->blue;
	preferredMyPictureButtonLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyPictureButtonViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyPictureButtonViewColor.red;
	pparamRGBColor->green = preferredMyPictureButtonViewColor.green;
	pparamRGBColor->blue = preferredMyPictureButtonViewColor.blue;
	pparamRGBColor->alpha = preferredMyPictureButtonViewColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyPictureButtonViewColor(	const rgb_color * pparamRGBColor)
{
	preferredMyPictureButtonViewColor.red = pparamRGBColor->red;
	preferredMyPictureButtonViewColor.green = pparamRGBColor->green;
	preferredMyPictureButtonViewColor.blue = pparamRGBColor->blue;
	preferredMyPictureButtonViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyStatusBarHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyStatusBarHighColor.red;
	pparamRGBColor->green = preferredMyStatusBarHighColor.green;
	pparamRGBColor->blue = preferredMyStatusBarHighColor.blue;
	pparamRGBColor->alpha = preferredMyStatusBarHighColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyStatusBarHighColor(	const rgb_color * pparamRGBColor)
{
	preferredMyStatusBarHighColor.red = pparamRGBColor->red;
	preferredMyStatusBarHighColor.green = pparamRGBColor->green;
	preferredMyStatusBarHighColor.blue = pparamRGBColor->blue;
	preferredMyStatusBarHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyStatusBarLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyStatusBarLowColor.red;
	pparamRGBColor->green = preferredMyStatusBarLowColor.green;
	pparamRGBColor->blue = preferredMyStatusBarLowColor.blue;
	pparamRGBColor->alpha = preferredMyStatusBarLowColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyStatusBarLowColor(	const rgb_color * pparamRGBColor)
{
	preferredMyStatusBarLowColor.red = pparamRGBColor->red;
	preferredMyStatusBarLowColor.green = pparamRGBColor->green;
	preferredMyStatusBarLowColor.blue = pparamRGBColor->blue;
	preferredMyStatusBarLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyStatusBarViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyStatusBarViewColor.red;
	pparamRGBColor->green = preferredMyStatusBarViewColor.green;
	pparamRGBColor->blue = preferredMyStatusBarViewColor.blue;
	pparamRGBColor->alpha = preferredMyStatusBarViewColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyStatusBarViewColor(	const rgb_color * pparamRGBColor)
{
	preferredMyStatusBarViewColor.red = pparamRGBColor->red;
	preferredMyStatusBarViewColor.green = pparamRGBColor->green;
	preferredMyStatusBarViewColor.blue = pparamRGBColor->blue;
	preferredMyStatusBarViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyBarColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyBarColor.red;
	pparamRGBColor->green = preferredMyBarColor.green;
	pparamRGBColor->blue = preferredMyBarColor.blue;
	pparamRGBColor->alpha = preferredMyBarColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyBarColor(	const rgb_color * pparamRGBColor)
{
	preferredMyBarColor.red = pparamRGBColor->red;
	preferredMyBarColor.green = pparamRGBColor->green;
	preferredMyBarColor.blue = pparamRGBColor->blue;
	preferredMyBarColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyColorControlHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyColorControlHighColor.red;
	pparamRGBColor->green = preferredMyColorControlHighColor.green;
	pparamRGBColor->blue = preferredMyColorControlHighColor.blue;
	pparamRGBColor->alpha = preferredMyColorControlHighColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyColorControlHighColor(	const rgb_color * pparamRGBColor)
{
	preferredMyColorControlHighColor.red = pparamRGBColor->red;
	preferredMyColorControlHighColor.green = pparamRGBColor->green;
	preferredMyColorControlHighColor.blue = pparamRGBColor->blue;
	preferredMyColorControlHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyColorControlLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyColorControlLowColor.red;
	pparamRGBColor->green = preferredMyColorControlLowColor.green;
	pparamRGBColor->blue = preferredMyColorControlLowColor.blue;
	pparamRGBColor->alpha = preferredMyColorControlLowColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyColorControlLowColor(	const rgb_color * pparamRGBColor)
{
	preferredMyColorControlLowColor.red = pparamRGBColor->red;
	preferredMyColorControlLowColor.green = pparamRGBColor->green;
	preferredMyColorControlLowColor.blue = pparamRGBColor->blue;
	preferredMyColorControlLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyColorControlViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyColorControlViewColor.red;
	pparamRGBColor->green = preferredMyColorControlViewColor.green;
	pparamRGBColor->blue = preferredMyColorControlViewColor.blue;
	pparamRGBColor->alpha = preferredMyColorControlViewColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyColorControlViewColor(	const rgb_color * pparamRGBColor)
{
	preferredMyColorControlViewColor.red = pparamRGBColor->red;
	preferredMyColorControlViewColor.green = pparamRGBColor->green;
	preferredMyColorControlViewColor.blue = pparamRGBColor->blue;
	preferredMyColorControlViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredColorWellHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredColorWellHighColor.red;
	pparamRGBColor->green = preferredColorWellHighColor.green;
	pparamRGBColor->blue = preferredColorWellHighColor.blue;
	pparamRGBColor->alpha = preferredColorWellHighColor.alpha;
}//end


void
MyPreferences	::	SetPreferredColorWellHighColor(	const rgb_color * pparamRGBColor)
{
	preferredColorWellHighColor.red = pparamRGBColor->red;
	preferredColorWellHighColor.green = pparamRGBColor->green;
	preferredColorWellHighColor.blue = pparamRGBColor->blue;
	preferredColorWellHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredColorWellLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredColorWellLowColor.red;
	pparamRGBColor->green = preferredColorWellLowColor.green;
	pparamRGBColor->blue = preferredColorWellLowColor.blue;
	pparamRGBColor->alpha = preferredColorWellLowColor.alpha;
}//end


void
MyPreferences	::	SetPreferredColorWellLowColor(	const rgb_color * pparamRGBColor)
{
	preferredColorWellLowColor.red = pparamRGBColor->red;
	preferredColorWellLowColor.green = pparamRGBColor->green;
	preferredColorWellLowColor.blue = pparamRGBColor->blue;
	preferredColorWellLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredColorWellViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredColorWellViewColor.red;
	pparamRGBColor->green = preferredColorWellViewColor.green;
	pparamRGBColor->blue = preferredColorWellViewColor.blue;
	pparamRGBColor->alpha = preferredColorWellViewColor.alpha;
}//end


void
MyPreferences	::	SetPreferredColorWellViewColor(	const rgb_color * pparamRGBColor)
{
	preferredColorWellViewColor.red = pparamRGBColor->red;
	preferredColorWellViewColor.green = pparamRGBColor->green;
	preferredColorWellViewColor.blue = pparamRGBColor->blue;
	preferredColorWellViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyButtonHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyButtonHighColor.red;
	pparamRGBColor->green = preferredMyButtonHighColor.green;
	pparamRGBColor->blue = preferredMyButtonHighColor.blue;
	pparamRGBColor->alpha = preferredMyButtonHighColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyButtonHighColor(	const rgb_color * pparamRGBColor)
{
	preferredMyButtonHighColor.red = pparamRGBColor->red;
	preferredMyButtonHighColor.green = pparamRGBColor->green;
	preferredMyButtonHighColor.blue = pparamRGBColor->blue;
	preferredMyButtonHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyButtonLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyButtonLowColor.red;
	pparamRGBColor->green = preferredMyButtonLowColor.green;
	pparamRGBColor->blue = preferredMyButtonLowColor.blue;
	pparamRGBColor->alpha = preferredMyButtonLowColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyButtonLowColor(	const rgb_color * pparamRGBColor)
{
	preferredMyButtonLowColor.red = pparamRGBColor->red;
	preferredMyButtonLowColor.green = pparamRGBColor->green;
	preferredMyButtonLowColor.blue = pparamRGBColor->blue;
	preferredMyButtonLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyButtonViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyButtonViewColor.red;
	pparamRGBColor->green = preferredMyButtonViewColor.green;
	pparamRGBColor->blue = preferredMyButtonViewColor.blue;
	pparamRGBColor->alpha = preferredMyButtonViewColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyButtonViewColor(	const rgb_color * pparamRGBColor)
{
	preferredMyButtonViewColor.red = pparamRGBColor->red;
	preferredMyButtonViewColor.green = pparamRGBColor->green;
	preferredMyButtonViewColor.blue = pparamRGBColor->blue;
	preferredMyButtonViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyStringDrawerHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyStringDrawerHighColor.red;
	pparamRGBColor->green = preferredMyStringDrawerHighColor.green;
	pparamRGBColor->blue = preferredMyStringDrawerHighColor.blue;
	pparamRGBColor->alpha = preferredMyStringDrawerHighColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyStringDrawerHighColor(	const rgb_color * pparamRGBColor)
{
	preferredMyStringDrawerHighColor.red = pparamRGBColor->red;
	preferredMyStringDrawerHighColor.green = pparamRGBColor->green;
	preferredMyStringDrawerHighColor.blue = pparamRGBColor->blue;
	preferredMyStringDrawerHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyStringDrawerLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyStringDrawerLowColor.red;
	pparamRGBColor->green = preferredMyStringDrawerLowColor.green;
	pparamRGBColor->blue = preferredMyStringDrawerLowColor.blue;
	pparamRGBColor->alpha = preferredMyStringDrawerLowColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyStringDrawerLowColor(	const rgb_color * pparamRGBColor)
{
	preferredMyStringDrawerLowColor.red = pparamRGBColor->red;
	preferredMyStringDrawerLowColor.green = pparamRGBColor->green;
	preferredMyStringDrawerLowColor.blue = pparamRGBColor->blue;
	preferredMyStringDrawerLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyStringDrawerViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyStringDrawerViewColor.red;
	pparamRGBColor->green = preferredMyStringDrawerViewColor.green;
	pparamRGBColor->blue = preferredMyStringDrawerViewColor.blue;
	pparamRGBColor->alpha = preferredMyStringDrawerViewColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyStringDrawerViewColor(	const rgb_color * pparamRGBColor)
{
	preferredMyStringDrawerViewColor.red = pparamRGBColor->red;
	preferredMyStringDrawerViewColor.green = pparamRGBColor->green;
	preferredMyStringDrawerViewColor.blue = pparamRGBColor->blue;
	preferredMyStringDrawerViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredStringGadgetHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredStringGadgetHighColor.red;
	pparamRGBColor->green = preferredStringGadgetHighColor.green;
	pparamRGBColor->blue = preferredStringGadgetHighColor.blue;
	pparamRGBColor->alpha = preferredStringGadgetHighColor.alpha;
}//end


void
MyPreferences	::	SetPreferredStringGadgetHighColor(	const rgb_color * pparamRGBColor)
{
	preferredStringGadgetHighColor.red = pparamRGBColor->red;
	preferredStringGadgetHighColor.green = pparamRGBColor->green;
	preferredStringGadgetHighColor.blue = pparamRGBColor->blue;
	preferredStringGadgetHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredStringGadgetLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredStringGadgetLowColor.red;
	pparamRGBColor->green = preferredStringGadgetLowColor.green;
	pparamRGBColor->blue = preferredStringGadgetLowColor.blue;
	pparamRGBColor->alpha = preferredStringGadgetLowColor.alpha;
}//end


void
MyPreferences	::	SetPreferredStringGadgetLowColor(	const rgb_color * pparamRGBColor)
{
	preferredStringGadgetLowColor.red = pparamRGBColor->red;
	preferredStringGadgetLowColor.green = pparamRGBColor->green;
	preferredStringGadgetLowColor.blue = pparamRGBColor->blue;
	preferredStringGadgetLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredStringGadgetViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredStringGadgetViewColor.red;
	pparamRGBColor->green = preferredStringGadgetViewColor.green;
	pparamRGBColor->blue = preferredStringGadgetViewColor.blue;
	pparamRGBColor->alpha = preferredStringGadgetViewColor.alpha;
}//end


void
MyPreferences	::	SetPreferredStringGadgetViewColor(	const rgb_color * pparamRGBColor)
{
	preferredStringGadgetViewColor.red = pparamRGBColor->red;
	preferredStringGadgetViewColor.green = pparamRGBColor->green;
	preferredStringGadgetViewColor.blue = pparamRGBColor->blue;
	preferredStringGadgetViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyRadioViewHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyRadioViewHighColor.red;
	pparamRGBColor->green = preferredMyRadioViewHighColor.green;
	pparamRGBColor->blue = preferredMyRadioViewHighColor.blue;
	pparamRGBColor->alpha = preferredMyRadioViewHighColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyRadioViewHighColor(	const rgb_color * pparamRGBColor)
{
	preferredMyRadioViewHighColor.red = pparamRGBColor->red;
	preferredMyRadioViewHighColor.green = pparamRGBColor->green;
	preferredMyRadioViewHighColor.blue = pparamRGBColor->blue;
	preferredMyRadioViewHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyRadioViewLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyRadioViewLowColor.red;
	pparamRGBColor->green = preferredMyRadioViewLowColor.green;
	pparamRGBColor->blue = preferredMyRadioViewLowColor.blue;
	pparamRGBColor->alpha = preferredMyRadioViewLowColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyRadioViewLowColor(	const rgb_color * pparamRGBColor)
{
	preferredMyRadioViewLowColor.red = pparamRGBColor->red;
	preferredMyRadioViewLowColor.green = pparamRGBColor->green;
	preferredMyRadioViewLowColor.blue = pparamRGBColor->blue;
	preferredMyRadioViewLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyRadioViewViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyRadioViewViewColor.red;
	pparamRGBColor->green = preferredMyRadioViewViewColor.green;
	pparamRGBColor->blue = preferredMyRadioViewViewColor.blue;
	pparamRGBColor->alpha = preferredMyRadioViewViewColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyRadioViewViewColor(	const rgb_color * pparamRGBColor)
{
	preferredMyRadioViewViewColor.red = pparamRGBColor->red;
	preferredMyRadioViewViewColor.green = pparamRGBColor->green;
	preferredMyRadioViewViewColor.blue = pparamRGBColor->blue;
	preferredMyRadioViewViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyTextViewHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyTextViewHighColor.red;
	pparamRGBColor->green = preferredMyTextViewHighColor.green;
	pparamRGBColor->blue = preferredMyTextViewHighColor.blue;
	pparamRGBColor->alpha = preferredMyTextViewHighColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyTextViewHighColor(	const rgb_color * pparamRGBColor)
{
	preferredMyTextViewHighColor.red = pparamRGBColor->red;
	preferredMyTextViewHighColor.green = pparamRGBColor->green;
	preferredMyTextViewHighColor.blue = pparamRGBColor->blue;
	preferredMyTextViewHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	SetPreferredMyTextViewLowColor(	const rgb_color * pparamRGBColor)
{
	preferredMyTextViewLowColor.red = pparamRGBColor->red;
	preferredMyTextViewLowColor.green = pparamRGBColor->green;
	preferredMyTextViewLowColor.blue = pparamRGBColor->blue;
	preferredMyTextViewLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyTextViewLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyTextViewLowColor.red;
	pparamRGBColor->green = preferredMyTextViewLowColor.green;
	pparamRGBColor->blue = preferredMyTextViewLowColor.blue;
	pparamRGBColor->alpha = preferredMyTextViewLowColor.alpha;
}//end


void
MyPreferences	::	GetPreferredMyTextViewViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyTextViewViewColor.red;
	pparamRGBColor->green = preferredMyTextViewViewColor.green;
	pparamRGBColor->blue = preferredMyTextViewViewColor.blue;
	pparamRGBColor->alpha = preferredMyTextViewViewColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyTextViewViewColor(	const rgb_color * pparamRGBColor)
{
	preferredMyTextViewViewColor.red = pparamRGBColor->red;
	preferredMyTextViewViewColor.green = pparamRGBColor->green;
	preferredMyTextViewViewColor.blue = pparamRGBColor->blue;
	preferredMyTextViewViewColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyListViewHighColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyListViewHighColor.red;
	pparamRGBColor->green = preferredMyListViewHighColor.green;
	pparamRGBColor->blue = preferredMyListViewHighColor.blue;
	pparamRGBColor->alpha = preferredMyListViewHighColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyListViewHighColor(	const rgb_color * pparamRGBColor)
{
	preferredMyListViewHighColor.red = pparamRGBColor->red;
	preferredMyListViewHighColor.green = pparamRGBColor->green;
	preferredMyListViewHighColor.blue = pparamRGBColor->blue;
	preferredMyListViewHighColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	SetPreferredMyListViewLowColor(	const rgb_color * pparamRGBColor)
{
	preferredMyListViewLowColor.red = pparamRGBColor->red;
	preferredMyListViewLowColor.green = pparamRGBColor->green;
	preferredMyListViewLowColor.blue = pparamRGBColor->blue;
	preferredMyListViewLowColor.alpha = pparamRGBColor->alpha;
}//end


void
MyPreferences	::	GetPreferredMyListViewLowColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyListViewLowColor.red;
	pparamRGBColor->green = preferredMyListViewLowColor.green;
	pparamRGBColor->blue = preferredMyListViewLowColor.blue;
	pparamRGBColor->alpha = preferredMyListViewLowColor.alpha;
}//end



void
MyPreferences	::	GetPreferredMyListViewViewColor(	rgb_color * pparamRGBColor) const
{
	pparamRGBColor->red = preferredMyListViewViewColor.red;
	pparamRGBColor->green = preferredMyListViewViewColor.green;
	pparamRGBColor->blue = preferredMyListViewViewColor.blue;
	pparamRGBColor->alpha = preferredMyListViewViewColor.alpha;
}//end


void
MyPreferences	::	SetPreferredMyListViewViewColor(	const rgb_color * pparamRGBColor)
{
	preferredMyListViewViewColor.red = pparamRGBColor->red;
	preferredMyListViewViewColor.green = pparamRGBColor->green;
	preferredMyListViewViewColor.blue = pparamRGBColor->blue;
	preferredMyListViewViewColor.alpha = pparamRGBColor->alpha;
}//end



float
MyPreferences	::	GetPreferredBarHeight(	void) const
{
	return preferredBarHeight;
}//end

void
MyPreferences	::	SetPreferredBarHeight(	const float fparamBarHeight)
{
	preferredBarHeight = fparamBarHeight;
}//end


void
MyPreferences		::	  OpenPreferencesPanel(	void)
{
	if (pPrefPanelWindow)
	{
		pPrefPanelWindow->Activate(true);
	}
	else
	{
		try 
		{
			BRect holdRect;
			GetPreferredPrefPanelWindowRect(&holdRect);
			pPrefPanelWindow = new PrefPanelWindow(	holdRect,
													PreferencePanelWindowTitle,
													"PrefPanel",
													"PrefPanelFrame");
			pPrefPanelWindow->Initialize();
		}
		catch (...) 
		{
			warning(NoPrefPanelWindow);
			throw;
		}
	}
}//end

