//myButton

#define BUILDING_LIB 1

#include <stdio.h>
#include <memory>
#include <SupportDefs.h>
//#include <string>
#include <String.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <float.h>
#include <errno.h>
#include <ctype.h>
#include <Application.h>
#include <Rect.h>
#include <Message.h>
#include <MenuItem.h>
#include <MenuBar.h>
#include <PopUpMenu.h>
#include <Window.h>
#include <View.h>
#include <SupportDefs.h>
#include <Beep.h>
#include <List.h>
#include <TextControl.h>
#include <TextView.h>
#include <ScrollView.h>
#include <Font.h>
#include <OS.h>
#include <Button.h>
#include <StatusBar.h>
#include <CheckBox.h>
#include <PictureButton.h>
#include <ColorControl.h>
#include <RadioButton.h>
#include <Point.h>
#include <TypeConstants.h>
#include <ListView.h>
#include <GraphicsDefs.h>
#include <File.h>
#include <Screen.h>
#include <Alert.h>
#include <Resources.h>
#include <StringView.h>
#include "DnumSpecificWindows.h"
#include "layoutMatrixItem.h"
#include "Preferences.h"
#include "myroColour.h"
#include "myButton.h"
#include "layoutMatrix.h"
#include "myPreferences.h"
#include "warning.h"

MyButton	::	~MyButton() 
{
	//left blank
};//end


//ctor
MyButton	::	MyButton(	const char * paramName, 
							const char * paramLabel,
							uint32 ui32paramMsg,
							LayoutMatrix * lpparamLayoutMatrix,
							bool bparamSetEnabled) 
				: 
					BButton(	BRect(0, 0, 32, 32), 
								paramName, 
								paramLabel,
								new BMessage(ui32paramMsg),
								B_FOLLOW_NONE, 
								B_WILL_DRAW),
					mpLabel(paramLabel)
{
	try
	{
		LayoutMatrixItem * lmi = new LayoutMatrixItem(	(void *)this,
														lpparamLayoutMatrix,
														KIND_MYBUTTON);
		lpparamLayoutMatrix->mpLayoutMatrixItems->AddItem((void *)lmi);
	}
	catch (...)
	{
		warning(myPrefs->FailMemory);
		return;
	}
	lpparamLayoutMatrix->AddToChildren((void *)this);
	SetFont(myPrefs->GetPreferredFont());
	if (!bparamSetEnabled)
	{
		SetEnabled(false);
	}
}//end


void 
MyButton	::	AttachedToWindow() 
{
	BView::AttachedToWindow();
	rgb_color tempRgbColor;
	myPrefs->GetPreferredMyButtonHighColor(&tempRgbColor);
	SetHighColor(tempRgbColor);
	myPrefs->GetPreferredMyButtonLowColor(&tempRgbColor);
	SetLowColor(tempRgbColor);
	myPrefs->GetPreferredMyButtonViewColor(&tempRgbColor);
	SetViewColor(tempRgbColor);
}//end


void
MyButton	::	MyGetPreferredSize(	float * fpparamWidth,
									float * fpparamHeight)
{
	BView	bv(BRect(0, 0, 32, 32), "NoShowView", B_FOLLOW_NONE, 0);
	bv.SetFont(myPrefs->GetPreferredFont());
	font_height	fontHeight;
	bv.GetFontHeight(&fontHeight);
	*fpparamHeight = fontHeight.ascent + fontHeight.descent + 11;//these pads would best be from a ratio of screen dimensions
	*fpparamWidth = bv.StringWidth(mpLabel) + 13;
}//end