//fontPrefWindow.cpp

#define BUILDING_LIB 1

#include <stdio.h>
#include <memory>
//#include <string>
#include <SupportDefs.h>
#include <String.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <float.h>
#include <errno.h>
#include <ctype.h>
#include <Application.h>
#include <Rect.h>
#include <Message.h>
#include <MenuItem.h>
#include <MenuBar.h>
#include <PopUpMenu.h>
#include <Window.h>
#include <View.h>
#include <SupportDefs.h>
#include <Beep.h>
#include <List.h>
#include <TextControl.h>
#include <TextView.h>
#include <ScrollView.h>
#include <Font.h>
#include <OS.h>
#include <Button.h>
#include <StatusBar.h>
#include <CheckBox.h>
#include <PictureButton.h>
#include <ColorControl.h>
#include <RadioButton.h>
#include <Point.h>
#include <TypeConstants.h>
#include <ListView.h>
#include <GraphicsDefs.h>
#include <File.h>
#include <Screen.h>
#include <Alert.h>
#include <Resources.h>
#include <StringView.h>
#include "DmenuMsg.h"
#include "DnumSpecificWindows.h"
#include "DtinySnooze.h"
#include "s2f.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "myButton.h"
#include "uInt32Gadget.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "myCheckBox.h"
#include "windowGuts.h"
#include "prefPanelWindow.h"
#include "fontPrefWindow.h"
#include "fontDisplayWindow.h"
#include "warning.h"
#include "Preferences.h"
#include "myroColour.h"
#include "verify.h"
#include "floatGadget.h"
#include "myPopUpMenu.h"
#include "myCheckBox.h"
#include "myPreferences.h"

//ctor
FontPrefWindow	::	FontPrefWindow(	BRect	paramBound,
									const char * paramWindowTitle,
									const char * paramScrollViewName,
									const char * paramNamePrefFrame)
				: 
				WindowGuts(	paramBound, 
							paramWindowTitle, 
							paramScrollViewName,
							paramNamePrefFrame,
							myPrefs->PrefSignature,
							myPrefs->mpPreferenceSet),
				mpcFullLine(NULL),
				mpSizeFloatGadget(NULL),
				mpFontDisplayWindow(NULL),
				mpFontFamilyPUM(NULL),
				mpFontStylePUM(NULL),
				mpDisplayFontCheckBox(NULL),
				mpAntiAliasFontCheckBox(NULL)
{
	sem_id calc_sem;
	if ((calc_sem = create_sem(1, "calc_sem")) < B_NO_ERROR)
	{
		warning(myPrefs->FailCreateSemaphore);
		return;
	}
	acquire_sem(calc_sem);
	try 
	{
		LayoutMatrix *	pholdFontPrefWindowLayoutMatrix = new LayoutMatrix(BESTSIZE, 7, 1, this);//rows,columns
/////////////////////////////////////////////////////////////////////////////////////////////
		BFont * pHBFont = new BFont(myPrefs->GetPreferredFont());
		float fontSize = pHBFont->Size();
		fontSize *= 3;
		if (fontSize > 200)
		{
			fontSize = 200;
		}
		pHBFont->SetSize(fontSize);
		pHBFont->SetShear(122);
		//calc font height for offset of PUMs--you could use a seperate matrix and get it's bottom
		float pumOffset;
		{
			BView view(BRect(0, 0, 32, 32), "NoShowView", B_FOLLOW_NONE, 0);
			view.SetFont(pHBFont);
			font_height	fontHeight;
			view.GetFontHeight(&fontHeight);
			pumOffset = fontHeight.ascent + fontHeight.descent + fontHeight.leading;
			view.RemoveSelf();
		}
		MyStringDrawer * pMyStringDrawer = new MyStringDrawer(	"fontPrefMyStringDrawer", 
																myPrefs->FontPrefWindowHeading1, 
																pHBFont,
																pholdFontPrefWindowLayoutMatrix);
////////////////////////////////////////////////////////////////////////////////
		MyButton * pholdBiggerFontMyButton = new MyButton(	"BiggerFontButton", 
															myPrefs->BiggerFontButtonLabel, 
															BIGGER_FONT,
															pholdFontPrefWindowLayoutMatrix);
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		MyButton * pholdSmallerFontMyButton = new MyButton(	"SmallerFontButton", 
															myPrefs->SmallerFontButtonLabel, 
															SMALLER_FONT,
															pholdFontPrefWindowLayoutMatrix);
//////////////////////////////////////////////////////////////////
		FloatGadget * pholdFloatGadget = new FloatGadget(	myPrefs->GetPreferredFont()->Size(),
															"FontSizeFloatGadget", 
															myPrefs->EnterFontSizeLabel, 
															FONT_SIZE_STR,
															0,
															pholdFontPrefWindowLayoutMatrix);
		mpSizeFloatGadget = pholdFloatGadget;
//////////////////////////////////////////////////////////////////
		mpDisplayFontCheckBox = new MyCheckBox(	"displayFont", 
												myPrefs->DisplayFontCheckBoxLabel,
												myPrefs->bOpenFontDisplay,
												DISPLAY_FONT,
												pholdFontPrefWindowLayoutMatrix);
/////////////////////////////////////////////
	BFont * currentFont = myPrefs->GetPreferredFont();
	currentFont->GetFamilyAndStyle(&mffFamilyName, &mfsStyleName);
	BList * PUMFontFamilyList = new BList();
	int32 numFamilies = count_font_families();
	for (	int i = 0; 
			i < numFamilies;
			i++ ) 
	{ 
		font_family family; 
   		uint32 flags; 
   		if ( get_font_family(i, &family, &flags) == B_OK ) 
   		{
			PopUpMenuData  * PUMFontFamilyData = new PopUpMenuData(family, PUMFontFamilyList);
   		} 
	}
	TextItem * pFontFamilyPUMLabelText = new TextItem(	myPrefs->FontFamilyPUMLabel,
														pholdFontPrefWindowLayoutMatrix);
	mpFontFamilyPUM = new MyPopUpMenu(	"fontFamilyPUM", 
										mffFamilyName,
										PUMFontFamilyList, 
										true,
										pFontFamilyPUMLabelText,
										pholdFontPrefWindowLayoutMatrix);
	if (!mpFontFamilyPUM->Initialize()) 
	{
		warning(myPrefs->FailPUMInitFontWindow);
	}
///////////////////////////////////////////////////////////////////////////
	BList * PUMFontStyleList = new BList();
	uint32 numStyles = count_font_styles(mffFamilyName);
	for (	uint32 j = 0;
			j < numStyles;
			j++ ) 
	{ 
	    font_style style;
   		uint32 flags; 
	    if ( get_font_style(mffFamilyName, j, &style, &flags) == B_OK ) 
	    { 
	    	PopUpMenuData * PUMDataFontStyle = new PopUpMenuData(style, PUMFontStyleList);
	    } 
	}
	TextItem * pFontStylePUMLabelText = new TextItem(	myPrefs->FontStylePUMLabel,
														pholdFontPrefWindowLayoutMatrix);
	mpFontStylePUM = new MyPopUpMenu(	"fontStylePUM", 
										mfsStyleName,
										PUMFontStyleList, 
										true,
										pFontStylePUMLabelText,
										pholdFontPrefWindowLayoutMatrix);
	if (!mpFontStylePUM->Initialize()) 
	{
		warning(myPrefs->FailPUMInitFontWindow);
	}
////////////////////////////////////////////////////
		LayoutMatrix *	pAntiAliasCBLayoutMatrix = new LayoutMatrix(BESTSIZE, 1, 1, this);//rows,columns
/////////////////////////////////////////////////////////////////////
		mpAntiAliasFontCheckBox = new MyCheckBox(	"antialiasFont", 
													myPrefs->AntiAliasFont,
													myPrefs->bAntiAliasFont,
													ANTIALIAS_FONT,
													pAntiAliasCBLayoutMatrix);
///////////////////////////////////////////////
		release_sem(calc_sem);
		pholdFontPrefWindowLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, MATRIXVERTICALOFFSET, calc_sem);
		pAntiAliasCBLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, pholdFontPrefWindowLayoutMatrix->bottom + 8, calc_sem);
	}
	catch (...)
	{
		warning(myPrefs->CaughtFontPrefWindowCTOR);
		release_sem(calc_sem);
		throw;
	}
	try 
	{
		BMenuItem *	menuItem;
		BMenu * APPMenu = new BMenu(myPrefs->AppMenuLabel);
		menuItem = new BMenuItem(	myPrefs->AboutMenuLabel, 
									new BMessage(ABOUT_FONTPREFWINDOW));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	myPrefs->CloseWindow, 
									new BMessage(B_QUIT_REQUESTED));
		APPMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	myPrefs->QuitMenuLabel, 
									new BMessage(QUIT_APP));
		APPMenu->AddItem(menuItem);
		pMenuBar->AddItem(APPMenu);
	}
	catch(...) 
	{
		throw;
	}
	if (myPrefs->bOpenFontDisplay) 
	{
		OpenFontDisplayWindow();
	}
}//end


//dtor
FontPrefWindow	::	~FontPrefWindow() 
{
	if (mpcFullLine)
	{
		delete[] mpcFullLine;
	}
	if (mpFontDisplayWindow)
	{
		mpFontDisplayWindow->PostMessage(B_QUIT_REQUESTED);
	}
	if (myPrefs->pPrefPanelWindow)//can get a race if not checked
	{
		myPrefs->pPrefPanelWindow->mpFontPrefWindow = NULL;
	}
	if (myPrefs->bPrefChangesMade)
	{
		if (myPrefs->pPrefPanelWindow)
		{
			myPrefs->pPrefPanelWindow->PostMessage(B_QUIT_REQUESTED);
		}
	}
}//end


void
FontPrefWindow	::	MessageReceived(	BMessage * pparamMessage) 
{
	switch(pparamMessage->what) 
	{
		case BIGGER_FONT:
		case SMALLER_FONT:
		{
	       	float oldSize = (myPrefs->GetPreferredFont())->Size();
			if (pparamMessage->what == BIGGER_FONT) 
			{
				oldSize++;
			}
			else
			{
				oldSize--;
			}
			ResetFontSize(oldSize);
		break;
		}
		case FONT_SIZE_STR:
		{
			ResetFontSize(s2f(mpSizeFloatGadget->Text()));
		break;
		}
		case DISPLAY_FONT:
			myPrefs->bOpenFontDisplay = mpDisplayFontCheckBox->Value();
			if (myPrefs->bOpenFontDisplay)
			{
				if (!mpFontDisplayWindow)
				{
					OpenFontDisplayWindow();
				}
				else
				{
					mpFontDisplayWindow->Activate();
				}
			}
			else
			{
				if (mpFontDisplayWindow)
				{
					mpFontDisplayWindow->PostMessage(B_QUIT_REQUESTED);
				}
			}
		break;
		case ANTIALIAS_FONT:
			if (mpAntiAliasFontCheckBox->Value())
			{
				myPrefs->bAntiAliasFont = false;
			}
			else
			{
				myPrefs->bAntiAliasFont = true;
			}
			myPrefs->GetPreferredFont()->SetFlags(myPrefs->bAntiAliasFont);
			if (myPrefs->bOpenFontDisplay)
			{
				OpenFontDisplayWindow();
			}
		break;
		case ABOUT_FONTPREFWINDOW:	
		{
			BString warn = myPrefs->AboutFontPrefWindowMsg1;
			warn += myPrefs->AboutFontPrefWindowMsg2;
			warn += myPrefs->AboutFontPrefWindowMsg3;
			warn += myPrefs->AboutFontPrefWindowMsg4;
			warn += myPrefs->AboutFontPrefWindowMsg5;
			warn += myPrefs->AboutFontPrefWindowMsg6;
			warning(warn.String());
		break;
		}
		case QUIT_APP:
			if (Verify(myPrefs->ReallyQuitApp))
			{
				be_app->PostMessage(B_QUIT_REQUESTED);
			}
		break;
		case BEGUIPUM:
		{
			BFont * currentFont = myPrefs->GetPreferredFont();
			const char * msgString;
			if (pparamMessage->FindString("menuName", &msgString) == B_OK) 
			{
				if (!strcmp(msgString, "fontFamilyPUM"))
				{
					if (pparamMessage->FindString("itemName", &msgString) == B_OK)
					{
						if (strcmp(mffFamilyName, msgString))
						{
							font_family oldFamily;
							font_style oldStyle;
							currentFont->GetFamilyAndStyle(&oldFamily, &oldStyle);
							currentFont->SetFamilyAndStyle(msgString, NULL);
							font_family newFamily;
							font_style newStyle;
							currentFont->GetFamilyAndStyle(&newFamily, &newStyle);
							myPrefs->bPrefChangesMade = true;
							BPopUpMenu * bpum = (BPopUpMenu *)mpFontStylePUM->ItemAt(0)->Submenu();
							int32 numItems = bpum->CountItems();
							for (	int32 j = (numItems - 1);
									j > -1;
									j--) 
							{
								BMenuItem * item = bpum->RemoveItem(j);
								delete item;
							}
							uint32 numStyles = count_font_styles(newFamily);
							bool reStyle = true;
							font_style styleOne;
							for (	uint32 j = 0;
									j < numStyles;
									j++ ) 
							{
								font_style style;
						   		uint32 flags; 
							    if ( get_font_style(newFamily, j, &style, &flags) == B_OK ) 
							    { 
							    	try
							    	{
								    	BMessage * msg = new BMessage(BEGUIPUM);
										msg->AddString("menuName", "fontStylePUM");
										msg->AddString("itemName", style);
										if (j == 0)
										{
											strcpy(styleOne, style);
										}
										if (!strcmp(style, oldStyle))
										{
											reStyle = false;
										}
								    	BMenuItem * item = new BMenuItem(style, msg);
								    	if (!bpum->AddItem(item))
								    	{
								    		warning(myPrefs->NoAdditem);
								    		throw;
								    	}
							    	}
							    	catch (...)
							    	{
							    		warning(myPrefs->failMenu);
							    		throw;
							    	}
							    } 
							}
							if (reStyle)
							{
								strcpy(mfsStyleName, styleOne);
								BPopUpMenu * bpum = (BPopUpMenu *)mpFontStylePUM->ItemAt(0)->Submenu();
								BMenuItem * bmi = bpum->ItemAt(0);
								bmi->SetMarked(true);
								currentFont->SetFamilyAndStyle(NULL, mfsStyleName);
							}
							strcpy(mffFamilyName, newFamily);
						}
					}
				}
				else if (!strcmp(msgString, "fontStylePUM"))
				{
					if (pparamMessage->FindString("itemName", &msgString) == B_OK)
					{
						if (strcmp(mfsStyleName, msgString))
						{
							currentFont->SetFamilyAndStyle(NULL, msgString);
							currentFont->GetFamilyAndStyle(&mffFamilyName, &mfsStyleName);
							myPrefs->bPrefChangesMade = true;
						}
					}
				}
			}
		break;
		}
		default:
			WindowGuts::MessageReceived(pparamMessage);
		break;
	}
	switch(pparamMessage->what) 
	{
		case BIGGER_FONT:
		case SMALLER_FONT:
		case FONT_SIZE_STR:
		case BEGUIPUM:
			if (mpDisplayFontCheckBox->Value())
			{
				OpenFontDisplayWindow();
			}
		break;
	}
}//end


bool
FontPrefWindow	::	QuitRequested(	void) 
{
	BRect frame = Frame();
	myPrefs->SetPreferredFontPrefWindowRect(frame);
	float fontSize = s2f(mpSizeFloatGadget->Text());
	if (fontSize != myPrefs->GetPreferredFont()->Size())
	{
		myPrefs->bPrefChangesMade = true;
		if (fontSize < 1)
		{
			warning(myPrefs->FailMinFontSize);
		}
		else if (fontSize > 51000)
		{
			warning(myPrefs->FailMaxFontSize);
		}
		else
		{
			myPrefs->GetPreferredFont()->SetSize(fontSize);
		}
	}
	return(WindowGuts::QuitRequested());
}//end


void
FontPrefWindow	::	OpenFontDisplayWindow(	void)
{
	if (mpFontDisplayWindow) 
	{
		int timeOut = 0;
		while (mpFontDisplayWindow && (timeOut < 100)) 
		{
			if (mpFontDisplayWindow->PostMessage(B_QUIT_REQUESTED))
			{
				mpFontDisplayWindow = NULL;
			}
			else
			{
				snooze(TINYSNOOZE);
				timeOut++;
			}
		}
	}
	if (!mpFontDisplayWindow) 
	{
		BString sFullLine = "";
		uint32 asciiStart = 48;
		for (	uint32 i = 0;
				i < 10;
				i++)
		{
			sFullLine += (i + asciiStart);
		}
		asciiStart = 65;
		for (	uint32 i = 0;
				i < 26;
				i++)
		{
			sFullLine += (i + asciiStart);
		}
		asciiStart = 97;
		for (	uint32 i = 0;
				i < 26;
				i++)
		{
			sFullLine += (i + asciiStart);
		}
		try 
		{
			mpcFullLine = new char[strlen(sFullLine.String()) + 1];
			strcpy(mpcFullLine, sFullLine.String());
			BRect holdRect;
			myPrefs->GetPreferredFontDisplayWindowRect(&holdRect);
			mpFontDisplayWindow = new FontDisplayWindow(	holdRect,
															"FontDisplayWindow",
															myPrefs->FontDisplayWindowTitle,
															"FontDisplayWindowFrame",
															mpcFullLine);
			mpFontDisplayWindow->Initialize();
		}
		catch (...) 
		{
			warning(myPrefs->FailFontDisplayWindow);
			throw;
		}
	}
	else
	{
		warning(myPrefs->FontDisplayNotNull);
		be_app->PostMessage(B_QUIT_REQUESTED);
	}
}//end


void
FontPrefWindow	::	ResetFontSize(	float newSize)
{
	myPrefs->bPrefChangesMade = true;
	char fontSizeStr[16];
	if (newSize < 1)
	{
		warning(myPrefs->FailMinFontSize);
		sprintf(fontSizeStr, "%f", myPrefs->GetPreferredFont()->Size());
		mpSizeFloatGadget->SetText(fontSizeStr);
	}
	else if (newSize > 51000)
	{
		warning(myPrefs->FailMaxFontSize);
		sprintf(fontSizeStr, "%f", myPrefs->GetPreferredFont()->Size());
		mpSizeFloatGadget->SetText(fontSizeStr);
	}
	else
	{
		myPrefs->GetPreferredFont()->SetSize(newSize);
		sprintf(fontSizeStr, "%f", myPrefs->GetPreferredFont()->Size());
		mpSizeFloatGadget->SetText(fontSizeStr);
	}
	if (myPrefs->bOpenFontDisplay) 
	{
		if (mpFontDisplayWindow)
		{
			if (mpFontDisplayWindow->LockLooper())
			{
				if (mpFontDisplayWindow->IsHidden())
				{
					do
					{
						mpFontDisplayWindow->Show();
					} while (mpFontDisplayWindow->IsHidden());
				}
				mpFontDisplayWindow->UnlockLooper();
			}
			else
			{
				warning(myPrefs->FailLockLooper);
			}
		}
		else
		{
			OpenFontDisplayWindow();
		}
	}
	else
	{
		if (mpFontDisplayWindow)
		{
			mpFontDisplayWindow->PostMessage(B_QUIT_REQUESTED);
		}
	}
}//end