//scrolling pref window

#define BUILDING_LIB 1

#include <stdio.h>
#include <memory>
//#include <string>
#include <SupportDefs.h>
#include <String.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <float.h>
#include <errno.h>
#include <ctype.h>
#include <Application.h>
#include <Rect.h>
#include <Message.h>
#include <MenuItem.h>
#include <MenuBar.h>
#include <PopUpMenu.h>
#include <Window.h>
#include <View.h>
#include <SupportDefs.h>
#include <Beep.h>
#include <List.h>
#include <TextControl.h>
#include <TextView.h>
#include <ScrollView.h>
#include <Font.h>
#include <OS.h>
#include <Button.h>
#include <StatusBar.h>
#include <CheckBox.h>
#include <PictureButton.h>
#include <ColorControl.h>
#include <RadioButton.h>
#include <Point.h>
#include <TypeConstants.h>
#include <ListView.h>
#include <GraphicsDefs.h>
#include <File.h>
#include <Screen.h>
#include <Alert.h>
#include <Resources.h>
#include <StringView.h>
#include "DmenuMsg.h"
#include "DnumSpecificWindows.h"
#include "textItem.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "myStringDrawer.h"
#include "warning.h"
#include "Preferences.h"
#include "myroColour.h"
#include "myCheckBox.h"
#include "windowGuts.h"
#include "prefPanelWindow.h"
#include "fontPrefWindow.h"
#include "fontDisplayWindow.h"
#include "verify.h"
#include "myPreferences.h"

//ctor
FontDisplayWindow	::	FontDisplayWindow(	BRect paramBound,
											const char * paramWindow,
											const char * paramScrollViewName,
											const char * paramNamePrefFrame,
											const char * paramPutString)
			: 
				WindowGuts(	paramBound, 
							paramWindow, 
							paramScrollViewName,
							paramNamePrefFrame,
							myPrefs->PrefSignature,
							myPrefs->mpPreferenceSet),
				mcpPutString(paramPutString)
{
	sem_id calc_sem;
	if ((calc_sem = create_sem(1, "calc_sem")) < B_NO_ERROR)
	{
		warning(myPrefs->FailCreateSemaphore);
		return;
	}
	acquire_sem(calc_sem);
	try 
	{
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		LayoutMatrix *	pholdStringDrawerLayoutMatrix = new LayoutMatrix(BESTSIZE, 1, 1, this);//rows,columns
/////////////////////////////////////////////////////////////////////////////////////////////
		MyStringDrawer * pMyStringDrawer = new MyStringDrawer(	"displayFontMyStringDrawer", 
																	mcpPutString, 
																	NULL,
																	pholdStringDrawerLayoutMatrix);
///////////////////////////////////////////////////////////////////////////////////////////////////////
		release_sem(calc_sem);
		pholdStringDrawerLayoutMatrix->Calc(	MATRIXHORIZONTALOFFSET, 
												MATRIXVERTICALOFFSET, 
												calc_sem);
	}
	catch (...)
	{
		release_sem(calc_sem);
		throw;
	}
	try 
	{
		BMenuItem *	menuItem;
		BMenu * appMenu = new BMenu(myPrefs->AppMenuLabel);
		menuItem = new BMenuItem(	myPrefs->AboutMenuLabel, 
									new BMessage(ABOUT_FONTDISPLAYWINDOW));
		appMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	myPrefs->CloseWindow, 
									new BMessage(B_QUIT_REQUESTED));
		appMenu->AddItem(menuItem);
		menuItem = new BMenuItem(	myPrefs->QuitMenuLabel, 
									new BMessage(QUIT_APP));
		appMenu->AddItem(menuItem);
		pMenuBar->AddItem(appMenu);
	}
	catch(...) 
	{
		throw;
	}
}//end


//dtor
FontDisplayWindow	::	~FontDisplayWindow() 
{
	if (myPrefs->pPrefPanelWindow)
	{
		if (myPrefs->pPrefPanelWindow->mpFontPrefWindow)
		{
			delete[] ((FontPrefWindow *)(myPrefs->pPrefPanelWindow->mpFontPrefWindow))->mpcFullLine;
			((FontPrefWindow *)(myPrefs->pPrefPanelWindow->mpFontPrefWindow))->mpcFullLine = NULL;
			((FontPrefWindow *)(myPrefs->pPrefPanelWindow->mpFontPrefWindow))->mpFontDisplayWindow = NULL;
		}
	}
}//end


void
FontDisplayWindow	::	MessageReceived(	BMessage * pparamMessage) 
{
	switch(pparamMessage->what) 
	{
		
		case ABOUT_FONTDISPLAYWINDOW:	
		{
			warning(myPrefs->AboutFontDisplayWindow);
		break;
		}
		case QUIT_APP:
			if (Verify(myPrefs->ReallyQuitApp))
			{
				be_app->PostMessage(B_QUIT_REQUESTED);
			}
		break;
		default:
			WindowGuts::MessageReceived(pparamMessage);
		break;
	}
}//end


bool
FontDisplayWindow	::	QuitRequested() 
{
	BRect frame = Frame();
	myPrefs->SetPreferredFontDisplayWindowRect(frame);
	return(WindowGuts::QuitRequested());
}//end
