//colorWell.cpp

#define BUILDING_LIB 1

#include <stdio.h>
#include <memory>
//#include <string>
#include <SupportDefs.h>

#include <String.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <float.h>
#include <errno.h>
#include <ctype.h>
#include <Application.h>
#include <Rect.h>
#include <Message.h>
#include <MenuItem.h>
#include <MenuBar.h>
#include <PopUpMenu.h>
#include <Window.h>
#include <View.h>
#include <SupportDefs.h>
#include <Beep.h>
#include <List.h>
#include <TextControl.h>
#include <TextView.h>
#include <ScrollView.h>
#include <Font.h>
#include <OS.h>
#include <Button.h>
#include <StatusBar.h>
#include <CheckBox.h>
#include <PictureButton.h>
#include <ColorControl.h>
#include <RadioButton.h>
#include <Point.h>
#include <TypeConstants.h>
#include <ListView.h>
#include <GraphicsDefs.h>
#include <File.h>
#include <Screen.h>
#include <Alert.h>
#include <Resources.h>
#include <StringView.h>
#include "DnumSpecificWindows.h"
#include "layoutMatrixItem.h"
#include "colorWell.h"
#include "Preferences.h"
#include "myroColour.h"
#include "layoutMatrix.h"
#include "textItem.h"
#include "myPreferences.h"
#include "warning.h"


ColorWell	::	~ColorWell() 
{
	delete mpLabelTextItem;
};//end


//ctor
ColorWell	::	ColorWell(	const char * cparamName, 
							int32 i32paramColorToChange,
							TextItem * pparamLabelTextItem,
							LayoutMatrix * lpparamLayoutMatrix) 
				: 
				BView(	BRect(0, 0, COLORWELLWIDTH, COLORWELLHEIGHT), 
						cparamName, 
						B_FOLLOW_NONE, 
						B_WILL_DRAW),
				mpLabelTextItem(pparamLabelTextItem),
				mColorToChange(i32paramColorToChange)
{
	try
	{
		LayoutMatrixItem * lmi = new LayoutMatrixItem(	(void *)this,
														lpparamLayoutMatrix,
														KIND_COLORWELLGADG);
		lpparamLayoutMatrix->mpLayoutMatrixItems->AddItem((void *)lmi);
	}
	catch (...)
	{
		warning(myPrefs->FailMemory);
		return;
	}
	lpparamLayoutMatrix->AddToChildren((void *)this);
}//end


void 
ColorWell	::	AttachedToWindow() 
{
	BView::AttachedToWindow();
	rgb_color tempRgbColor;
	myPrefs->GetPreferredColorWellHighColor(&tempRgbColor);
	SetHighColor(tempRgbColor);
	myPrefs->GetPreferredColorWellLowColor(&tempRgbColor);
	SetLowColor(tempRgbColor);
	myPrefs->GetPreferredColorWellViewColor(&tempRgbColor);
	SetViewColor(tempRgbColor);
}//end


void 
ColorWell	::	Draw(	BRect rect) 
{
	BView::Draw(rect);
	SetPenSize(1);
	rgb_color	originalColor(HighColor());
	rgb_color	newColor(originalColor);
	bool		redUp = false;
	bool		greenUp = false;
	bool		blueUp = false;
	BRect 		frame = Bounds();
	int32		stepsDown = frame.IntegerWidth();
	uint8		changeColorBy;
	uint8		colorRange;
	if (originalColor.red < originalColor.green ) 
	{
		if (originalColor.red < originalColor.blue ) 
		{
			redUp = true;
			colorRange = 255 - originalColor.red;
		}
		else
		{
			blueUp = true;
			colorRange = 255 - originalColor.blue;
		}
	}
	else
	{
		if (originalColor.green < originalColor.blue ) 
		{
			greenUp = true;
			colorRange = 255 - originalColor.green;
		}
		else
		{
			blueUp = true;
			colorRange = 255 - originalColor.blue;
		}
	}
	colorRange = colorRange;
	changeColorBy = colorRange / stepsDown;
	for (	int32 i = stepsDown;
			i > 0;
			i--)
	{
		if (redUp)
		{
			newColor.red += changeColorBy;
		}
		else 
		{
			if (greenUp)
			{
				newColor.green += changeColorBy;
			}
			else
			{
				newColor.blue += changeColorBy;
			}
		}
		SetHighColor(newColor);
		frame.InsetBy(1, 1);
		StrokeRect(frame);
	}
	SetHighColor(originalColor);
}//end


void 
ColorWell	::	MessageReceived(	BMessage * pparamMessage) 
{
	beep();//just so feedback occures
	pparamMessage->AddInt32("ColorToChange", mColorToChange);
	BView::MessageReceived(pparamMessage);
}//end


TextItem *
ColorWell	::	GetTextItem(void) const
{
	return mpLabelTextItem;
}//end


void
ColorWell	::	SetTop(	const float fparamTop)
{
	top = fparamTop;
}//end


float
ColorWell	::	GetTop(	void) const
{
	return top;
}//end


void
ColorWell	::	SetLeft(	const float fparamLeft)
{
	left = fparamLeft;
}//end


float
ColorWell	::	GetLeft(	void) const
{
	return left;
}//end