//myApp.cpp

#include <stdio.h>
#include <memory>
//#include <string>
#include <SupportDefs.h>
#include <String.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include <float.h>
#include <errno.h>
#include <ctype.h>
#include <Application.h>
#include <Rect.h>
#include <Message.h>
#include <MenuItem.h>
#include <MenuBar.h>
#include <PopUpMenu.h>
#include <Window.h>
#include <View.h>
#include <Beep.h>
#include <List.h>
#include <TextControl.h>
#include <TextView.h>
#include <ScrollView.h>
#include <Font.h>
#include <OS.h>
#include <Button.h>
#include <StatusBar.h>
#include <CheckBox.h>
#include <PictureButton.h>
#include <ColorControl.h>
#include <RadioButton.h>
#include <Point.h>
#include <TypeConstants.h>
#include <ListView.h>
#include <GraphicsDefs.h>
#include <File.h>
#include <Screen.h>
#include <Alert.h>
#include <Resources.h>
#include <StringView.h>
#include <Path.h>
#include "DtinySnooze.h"
#include "DnumSpecificWindows.h"
#include "Preferences.h"
#include "myPreferences.h"
#include "warning.h"
#include "windowGuts.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "myButton.h"
#include "myCheckBox.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "myPopUpMenu.h"
#include "myPictureButton.h"
#include "myColorControl.h"
#include "myStatusBar.h"
#include "myRadioView.h"
#include "myTextView.h"
#include "mySpacer.h"
#include "DmenuMsg.h"
#include "DcolorControlMessages.h"
#include "fontPrefWindow.h"
#include "specificColorWindow.h"
#include "basicColorWindow.h"
#include "prefPanelWindow.h"
#include "scrollView.h"
#define NOTX_MYAPP 1
#include "ToolBox2App.h"
#include "ToolBox2ToolPaletteWindow.h"
#include "ToolBox2TextEdWindow.h"


MyApp	::	MyApp()
		:	BApplication("application/x-vnd.EFM5.ToolPaletteDemo"),//if this sig changes change it in appStrings.r as well
			pTextEdWindow(NULL),
			mpPreferences(NULL),
			mpPreferenceSet(NULL),
			AppSignature(NULL),
			FailCreateSemaphore(NULL),
			CaughtToolPaletteWindowCTOR(NULL),
			CaughtTextEdWindowCTOR(NULL),
			AppMenuLabel(NULL),
			CloseWindow(NULL),
			QuitMenuLabel(NULL),
			ToolPaletteWindowTitle(NULL),
			TextEdWindowTitle(NULL),
			ReallyQuitApp(NULL),
			AboutToolPaletteWindowMsg1(NULL),
			AboutToolPaletteWindowMsg2(NULL),
			AboutToolPaletteWindowMsg3(NULL),
			AboutTextEdWindowMsg1(NULL),
			AboutTextEdWindowMsg2(NULL),
			AboutTextEdWindowMsg3(NULL),
			ProgramName(NULL),
			ProgramNameSubTitle(NULL),
			Button0(NULL),
			Button1(NULL),
			Button2(NULL),
			TextField(NULL),
			AppPrefFailInit(NULL),
			AppPrefSetFailInit(NULL),
			AppPrefNoSetData(NULL),
			AppsPrefsNoSave(NULL),
			tpbWidth(NULL),
			tpbHeight(NULL),
			DisplayTPCBoxLabel(NULL),
			FailMinPBWidth(NULL),
			FailMaxPBWidth(NULL),
			FailMinPBHeight(NULL),
			FailMaxPBHeight(NULL)
{
	myApp = this;
	BResources * appResources = AppResources();
	size_t len;
	AppSignature = (const char *)appResources->FindResource('CSTR', "AppSignature", &len);
	FailCreateSemaphore = (const char *)appResources->FindResource('CSTR', "FailCreateSemaphore", &len);
	CaughtToolPaletteWindowCTOR = (const char *)appResources->FindResource('CSTR', "CaughtToolPaletteWindowCTOR", &len);
	CaughtTextEdWindowCTOR = (const char *)appResources->FindResource('CSTR', "CaughtTextEdWindowCTOR", &len);
	AppMenuLabel = (const char *)appResources->FindResource('CSTR', "AppMenuLabel", &len);
	CloseWindow = (const char *)appResources->FindResource('CSTR', "CloseWindow", &len);
	QuitMenuLabel = (const char *)appResources->FindResource('CSTR', "QuitMenuLabel", &len);
	ToolPaletteWindowTitle = (const char *)appResources->FindResource('CSTR', "ToolPaletteWindowTitle", &len);
	TextEdWindowTitle = (const char *)appResources->FindResource('CSTR', "TextEdWindowTitle", &len);
	ReallyQuitApp = (const char *)appResources->FindResource('CSTR', "ReallyQuitApp", &len);
	AboutToolPaletteWindowMsg1 = (const char *)appResources->FindResource('CSTR', "AboutToolPaletteWindowMsg1", &len);
	AboutToolPaletteWindowMsg2 = (const char *)appResources->FindResource('CSTR', "AboutToolPaletteWindowMsg2", &len);
	AboutToolPaletteWindowMsg3 = (const char *)appResources->FindResource('CSTR', "AboutToolPaletteWindowMsg3", &len);
	AboutTextEdWindowMsg1 = (const char *)appResources->FindResource('CSTR', "AboutTextEdWindowMsg1", &len);
	AboutTextEdWindowMsg2 = (const char *)appResources->FindResource('CSTR', "AboutTextEdWindowMsg2", &len);
	AboutTextEdWindowMsg3 = (const char *)appResources->FindResource('CSTR', "AboutTextEdWindowMsg3", &len);
	ProgramName = (const char *)appResources->FindResource('CSTR', "ProgramName", &len);
	ProgramNameSubTitle = (const char *)appResources->FindResource('CSTR', "ProgramNameSubTitle", &len);
	Button0 = (const char *)appResources->FindResource('CSTR', "Button0", &len);
	Button1 = (const char *)appResources->FindResource('CSTR', "Button1", &len);
	Button2 = (const char *)appResources->FindResource('CSTR', "Button2", &len);
	TextField = (const char *)appResources->FindResource('CSTR', "TextField", &len);
	AppPrefFailInit = (const char *)appResources->FindResource('CSTR', "AppPrefFailInit", &len);
	AppPrefSetFailInit = (const char *)appResources->FindResource('CSTR', "AppPrefSetFailInit", &len);
	AppPrefNoSetData = (const char *)appResources->FindResource('CSTR', "AppPrefNoSetData", &len);
	AppsPrefsNoSave = (const char *)appResources->FindResource('CSTR', "AppsPrefsNoSave", &len);
	tpbWidth = (const char *)appResources->FindResource('CSTR', "tpbWidth", &len);
	tpbHeight = (const char *)appResources->FindResource('CSTR', "tpbHeight", &len);
	DisplayTPCBoxLabel = (const char *)appResources->FindResource('CSTR', "DisplayTPCBoxLabel", &len);
	FailMinPBWidth = (const char *)appResources->FindResource('CSTR', "FailMinPBWidth", &len);
	FailMaxPBWidth = (const char *)appResources->FindResource('CSTR', "FailMaxPBWidth", &len);
	FailMinPBHeight = (const char *)appResources->FindResource('CSTR', "FailMinPBHeight", &len);
	FailMaxPBHeight = (const char *)appResources->FindResource('CSTR', "FailMaxPBHeight", &len);

	mpPreferences = new Preferences(AppSignature);
	Preferences& mrPreferences = *mpPreferences;
	mpPreferenceSet = new PreferenceSet(	mrPreferences,  
											"hierarchical/extendable/settings", 
											true);
	if (mpPreferences->InitCheck())
	{
		puts(AppPrefFailInit);
		exit(1);
	}
	if (mpPreferenceSet->InitCheck())
	{
		puts(AppPrefSetFailInit);
		exit(2);
	}
	BRect	screenResolutionRect;
		{//I do screen like this so it goes away fast
			BScreen	screen(B_MAIN_SCREEN_ID);
			if(!screen.IsValid()) 
			{//may not be valid, if not, this is not a critical app--bail out as best we can
				puts(myPrefs->ScreenNotValid);
				exit(3);
			}
			screenResolutionRect = screen.Frame();
		}
	BRect windowPrefArea;
	const void * windowPrefAreaData;
	ssize_t windowPrefAreaSize;
	uint32 windowPrefAreaType = '    ';
	if (	mpPreferenceSet->GetData(	"ToolPaletteWindowFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
						//the - 17 and - 37 were determined based upon trial and error
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredToolPaletteWindowRect(windowPrefArea);
	if (	mpPreferenceSet->GetData(	"TextEdWindowFrame", 
										windowPrefAreaData, 
										windowPrefAreaSize, 
										windowPrefAreaType) 
			|| 
			(windowPrefAreaType != B_RECT_TYPE))
	{
		windowPrefArea.Set(	5,
							22, 
							screenResolutionRect.right - 17,
							screenResolutionRect.bottom - 37);
						//the - 17 and - 37 were determined based upon trial and error
	}
	else
	{
		memcpy(	&windowPrefArea, 
				windowPrefAreaData, 
				windowPrefAreaSize);
	}
	SetPreferredTextEdWindowRect(windowPrefArea);
	const void * prefData;
	ssize_t prefDataSize;
	uint32 prefDataType = '    ';
	float floatData;
	if (	mpPreferenceSet->GetData(	"ToolPaletteButtonWidth", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_FLOAT_TYPE))
	{
		floatData = 32;
	}
	else
	{
		memcpy(	&floatData, 
				prefData, 
				prefDataSize);
	}
	SetToolPaletteButtonWidth(floatData);
	if (	mpPreferenceSet->GetData(	"ToolPaletteButtonHeight", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_FLOAT_TYPE))
	{
		floatData = 32;
	}
	else
	{
		memcpy(	&floatData, 
				prefData, 
				prefDataSize);
	}
	SetToolPaletteButtonHeight(floatData);
	bool boolData;
	if (	mpPreferenceSet->GetData(	"DisplayToolPalette", 
										prefData, 
										prefDataSize, 
										prefDataType) 
			|| 
			(prefDataType != B_BOOL_TYPE))
	{
		boolData = true;
	}
	else
	{
		memcpy(	&boolData, 
				prefData, 
				prefDataSize);
	}
	SetDisplayToolPalette(boolData);
}//end


MyApp	::	~MyApp() 
{
	bool allSetsOK = true;
	bool tempBool = GetDisplayToolPalette();
	if (mpPreferenceSet->SetData(	"DisplayToolPalette", 
									&tempBool, 
									sizeof(tempBool), 
									B_BOOL_TYPE))
	{
		warning(AppPrefNoSetData);
		allSetsOK = false;
	}
	float tempFloat;
	if (allSetsOK) 
	{
		tempFloat = GetToolPaletteButtonWidth();
		if (mpPreferenceSet->SetData(	"ToolPaletteButtonWidth", 
										&tempFloat, 
										sizeof(tempFloat), 
										B_FLOAT_TYPE))
		{
			warning(AppPrefNoSetData);
			allSetsOK = false;
		}
	}
	if (allSetsOK) 
	{
		tempFloat = GetToolPaletteButtonHeight();
		if (mpPreferenceSet->SetData(	"ToolPaletteButtonHeight", 
										&tempFloat, 
										sizeof(tempFloat), 
										B_FLOAT_TYPE))
		{
			warning(AppPrefNoSetData);
			allSetsOK = false;
		}
	}
	if (allSetsOK)
	{
		if (mpPreferenceSet->Save())
		{
			warning(AppsPrefsNoSave);
		}
	}
	delete mpPreferenceSet;
	delete mpPreferences;
	free((char *)AppSignature);
	free((char *)FailCreateSemaphore);
	free((char *)CaughtToolPaletteWindowCTOR);
	free((char *)CaughtTextEdWindowCTOR);
	free((char *)AppMenuLabel);
	free((char *)CloseWindow);
	free((char *)QuitMenuLabel);
	free((char *)ToolPaletteWindowTitle);
	free((char *)TextEdWindowTitle);
	free((char *)ReallyQuitApp);
	free((char *)AboutToolPaletteWindowMsg1);
	free((char *)AboutToolPaletteWindowMsg2);
	free((char *)AboutToolPaletteWindowMsg3);
	free((char *)AboutTextEdWindowMsg1);
	free((char *)AboutTextEdWindowMsg2);
	free((char *)AboutTextEdWindowMsg3);
	free((char *)ProgramName);
	free((char *)ProgramNameSubTitle);
	free((char *)Button0);
	free((char *)Button1);
	free((char *)Button2);
	free((char *)TextField);
	free((char *)AppPrefFailInit);
	free((char *)AppPrefSetFailInit);
	free((char *)AppPrefNoSetData);
	free((char *)AppsPrefsNoSave);
	free((char *)tpbWidth);
	free((char *)tpbHeight);
	free((char *)DisplayTPCBoxLabel);
	free((char *)FailMinPBWidth);
	free((char *)FailMaxPBWidth);
	free((char *)FailMinPBHeight);
	free((char *)FailMaxPBHeight);
}//end


bool
MyApp	::	QuitRequested(	void) 
{
	if (pTextEdWindow)
	{
		pTextEdWindow->PostMessage(B_QUIT_REQUESTED);
	}
	return(BApplication	::	QuitRequested());
}//end


//all apps will need a main window to display on launch
void 
MyApp	::	ReadyToRun(	void) 
{
	OpenTextEdWindow();
}//end


void 
MyApp	::	MessageReceived(	BMessage *	message) 
{
	switch(message->what)
	{
		case REOPEN:
		{
			OpenTextEdWindow();
			if (myPrefs->pPrefPanelWindow)
			{
				int timeOut = 0;
				while (myPrefs->pPrefPanelWindow && (timeOut < 50)) 
				{
					myPrefs->pPrefPanelWindow->PostMessage(B_QUIT_REQUESTED);
					snooze(TINYSNOOZE);
					timeOut++;
				}
				if (!myPrefs->pPrefPanelWindow) 
				{
					myPrefs->OpenPreferencesPanel();
				}
			}
			myPrefs->bPrefChangesMade = false;
		break;
		}
//		case 0:	//I am wondering about this
//				//it only shows up when app is launched from 
//				//tracker and resources are present in the file
//				//when run via double-click on the app icon I get a message here
//				//with a message->what == zero
//			warning("got unexpected zero msg in app\n");
//		break;
//		default:
//			//I don't expect any msgs here
//			//warning("got unexpected msg in app\n");
//		break;
	}
}//end


void
MyApp	::	GetPreferredToolPaletteWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredToolPaletteWindowRect;
}//end


void
MyApp	::	SetPreferredToolPaletteWindowRect(	const BRect paramWindowRect)
{
	preferredToolPaletteWindowRect = paramWindowRect;
}//end


void
MyApp	::	GetPreferredTextEdWindowRect(	BRect * paramWindowRect) const
{
	*paramWindowRect = preferredTextEdWindowRect;
}//end


void
MyApp	::	SetPreferredTextEdWindowRect(	const BRect paramWindowRect)
{
	preferredTextEdWindowRect = paramWindowRect;
}//end


float
MyApp	::	GetToolPaletteButtonWidth(	void) const
{
	return mfToolPaletteButtonWidth;
}//end


void
MyApp	::	SetToolPaletteButtonWidth(	const float paramButtonWidth)
{
	mfToolPaletteButtonWidth = paramButtonWidth;
}//end


float
MyApp	::	GetToolPaletteButtonHeight(	void) const
{
	return mfToolPaletteButtonHeight;
}//end


void
MyApp	::	SetToolPaletteButtonHeight(	const float paramButtonHeight)
{
	mfToolPaletteButtonHeight = paramButtonHeight;
}//end


bool
MyApp	::	GetDisplayToolPalette(	void) const
{
	return mbDisplayToolPalette;
}//end


void
MyApp	::	SetDisplayToolPalette(	const bool paramDisplayToolPalette)
{
	mbDisplayToolPalette = paramDisplayToolPalette;
}//end


void
MyApp	::	OpenTextEdWindow(	void)
{
	int timeOut = 0;
	while (pTextEdWindow && (timeOut < 50)) 
	{
		if (pTextEdWindow->PostMessage(B_QUIT_REQUESTED))
		{
			pTextEdWindow = NULL;
		}
		else
		{
			snooze(TINYSNOOZE);
			timeOut++;
		}
	}
	if (!pTextEdWindow) 
	{
		try 
		{
			BRect holdRect;
			GetPreferredTextEdWindowRect(&holdRect);
			pTextEdWindow = new TextEdWindow(	holdRect,
												TextEdWindowTitle,
												"textEdWindow",
												"TextEdWindowFrame");
			pTextEdWindow->Initialize();
		}
		catch (...)
		{
			warning(CaughtTextEdWindowCTOR);
			PostMessage(B_QUIT_REQUESTED);
		}
	}
}//end