/*
	Indices.cpp
	
	Copyright Will Dyson
	
	Created: 01/06/99 19:05:21
	
	This program is freely distributable under the terms of
	the Gnu Public License. If you have a patch or new feature,
	please let me know. mailto:will@cs.earlham.edu
*/

//AppKit
#include <Application.h>

//InterfaceKit
#include <Window.h>
#include <ScrollView.h>
#include <ListView.h>
#include <MenuBar.h>
#include <MenuItem.h>
#include <Alert.h>

//StorageKit
#include <VolumeRoster.h>
#include <Volume.h>
#include <fs_index.h>

//posix
#include <dirent.h>

//local
#include "Indices.h"

//our message->what constant:
const uint32 MENU_UPDATE = 'MeUp';


IndexApp::IndexApp()
: BApplication(APP_SIG)
{
	volroster = new BVolumeRoster();
	
	BRect myrect(25, 75, 200, 300);
	new IndexWin(myrect);
}

IndexApp::~IndexApp()
{
	delete volroster;
}

IndexWin::IndexWin(BRect frame)
: BWindow(frame, "Indices", B_DOCUMENT_WINDOW, 0)
{
	BRect framerect = Bounds();
	
	_SetupMenus();
	_SetupView(framerect);
	_UpdateList();
	
	Show();
}

void IndexWin::_SetupMenus()
{
	BMenu* amenu;
	
	menubar = new BMenuBar(Bounds(), "menubar");
	amenu = new BMenu("Menu");
	amenu->AddItem(new BMenuItem("Update List", new BMessage(MENU_UPDATE), 'U'));
	
	menubar->AddItem(amenu);
	AddChild(menubar);
}

void IndexWin::_SetupView(BRect frame)
{
	//make room for scrollbar
	frame.right -= B_V_SCROLL_BAR_WIDTH; 
	
	//make room for menubar
	frame.top = menubar->Bounds().bottom + 1.0;
	
	displayview = new BListView(frame, "TheList", B_SINGLE_SELECTION_LIST, B_FOLLOW_ALL_SIDES);
	
	//this scrollview encapsulates the displayview
	AddChild(new BScrollView("scroll_indices", displayview,
			B_FOLLOW_ALL_SIDES, 0, false, true, B_NO_BORDER));
}

// get the list of indices and display them
void IndexWin::_UpdateList()
{
	BVolume myvol;
	//index_info info; // used for getting info on indices
	
	BListItem* listitem;
	BAlert* alert;
	DIR *indexdir;
	struct dirent* ent;
	
	// empty list
	listitem = displayview->RemoveItem(NULL);
	while (listitem != NULL)
	{
		delete listitem;
		listitem = displayview->RemoveItem(NULL);
	}	
	
	// rare case, but could happen...
	if (static_cast<IndexApp*>(be_app)->volroster->GetBootVolume(&myvol)!= B_NO_ERROR)
	{
		alert = new BAlert("alert", "Fatal error: Couldn't find boot volume!", "Shit!", NULL, NULL, B_WIDTH_AS_USUAL, B_STOP_ALERT);
		
		alert->Go();
		
		be_app->PostMessage(B_QUIT_REQUESTED);
		return;
	}
	
	indexdir = fs_open_index_dir(myvol.Device());
	if (!indexdir)
	{
		alert = new BAlert("alert", "Fatal error: Couldn't open index directory!", "Shit!", NULL, NULL, B_WIDTH_AS_USUAL, B_STOP_ALERT);
		
		alert->Go();
		
		be_app->PostMessage(B_QUIT_REQUESTED);
		return;
	}
	
   ent = fs_read_index_dir(indexdir);
	while (ent != NULL)
	{
		displayview->AddItem(new BStringItem(ent->d_name));
		ent = fs_read_index_dir(indexdir);
	}
	
	fs_close_index_dir(indexdir); 
}

bool IndexWin::QuitRequested()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return true;
}

void IndexWin::MessageReceived(BMessage* message)
{
	switch (message->what)
	{
		case MENU_UPDATE:
		{
			_UpdateList();
		}
		break;
		
		default:
		{
			BWindow::MessageReceived(message);
		}
	}
}

int main()
{
	IndexApp myapp;
	myapp.Run();
	return 0;
}
