/*
 * ID3tag
 *
 * TagWin.cpp - Window class
 * Copyright (c) 1999 Pieter Panman (ppanman@dds.nl)
 * Based very partially on ID3ren (by Robert Alto (badcrc@tscnet.com)
 * and its BeOS port by Shayne White (shayne@curvedspace.org))
 * (I only used the genre list and some ideas)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 * USA.
 */

#include "TagWin.h"				//Header file
#include "genre.h"				//All genres in one char[], genre_table[]

//	Window
const BRect WindowFrame (100,100,405,305);
const char* WindowName = "ID3tag";

//	Buttons
const BRect aButtonFrame (70, 175, 150, 190);
const char* aButtonName = "Apply to File";
const BRect dButtonFrame (155, 175, 235, 190);
const char* dButtonName = "Remove tag";
const BRect bButtonFrame (240, 175, 295, 190);
const char* bButtonName = "Browse";

//	ID3TAG TextControls + PopUpMenu
const BRect aTCFrame (5, 15, 290, 35);
const char* aTCName = "Artist";
const BRect sTCFrame (5, 40, 290, 60);
const char* sTCName = "Songname";
const BRect lTCFrame (5, 65, 290, 85);
const char* lTCName = "Album";
const BRect yTCFrame (5, 90, 100, 110);
const char* yTCName = "Year";
const BRect gMFFrame (115, 90, 290, 110);
const char* gMFName = "Genre";
const BRect cTCFrame (5, 115, 290, 135);
const char* cTCName = "Comments";

//  Filename Textcontrol
const BRect fTCFrame (10, 150, 295, 170);
const char* fTCName = "File";

/*
  ==========================================
	TagWin::TagWin()
  ==========================================
*/

TagWin::TagWin() :
	BWindow(WindowFrame, WindowName, B_TITLED_WINDOW, B_NOT_RESIZABLE | B_NOT_ZOOMABLE)
{

	mainBox = new BBox(BRect(0,0,421,301), "mainBox", B_FOLLOW_LEFT | B_FOLLOW_TOP, 
						B_WILL_DRAW | B_NAVIGABLE_JUMP, B_FANCY_BORDER);

	aButton = new BButton(aButtonFrame, aButtonName, aButtonName, 
					new BMessage(BUTTON_APP));
	dButton = new BButton(dButtonFrame, dButtonName, dButtonName, 
					new BMessage(BUTTON_DELETE_TAG));
	bButton = new BButton(bButtonFrame, bButtonName, bButtonName, 
					new BMessage(BUTTON_BROWSE));
	bButton->MakeDefault(true);

//	Artist
	aTC = new BTextControl(aTCFrame, aTCName, aTCName, "", new BMessage(TEXTCT_ARTIST)); 
	aTC->SetDivider(60);

//	Songname
	sTC = new BTextControl(sTCFrame, sTCName, sTCName, "", new BMessage(TEXTCT_SONGNAME)); 
	sTC->SetDivider(60);

//	Album
	lTC = new BTextControl(lTCFrame, lTCName, lTCName, "", new BMessage(TEXTCT_ALBUM)); 
	lTC->SetDivider(60);

//	Year
	yTC = new BTextControl(yTCFrame, yTCName, yTCName, "", new BMessage(TEXTCT_YEAR)); 
	yTC->SetDivider(60);

//	Genre
	BMenuItem *item;
	genrePopup = new BPopUpMenu("Genres");
	for (int x=0; x<genre_count; x++)
	{
		msg = new BMessage('GENR');
		msg->AddInt8("Genre", x);
		genrePopup->AddItem(item = new BMenuItem(genre_table[x], msg) );
	}
	msg = new BMessage('GENR');
	genrePopup->AddItem(item = new BMenuItem("Genres", msg));
	genrePopup->ItemAt(genrePopup->CountItems() - 1)->SetMarked(true);
	genreField = new BMenuField(gMFFrame, "Genre", "Genre", genrePopup);
	genreField->SetDivider(35);

//	Comments
	cTC = new BTextControl(cTCFrame, cTCName, cTCName, "", new BMessage(TEXTCT_COMMENTS)); 
	cTC->SetDivider(60);

//	File:
	fTC = new BTextControl(fTCFrame, fTCName, fTCName, "", new BMessage(TEXTCT_FILE)); 
	fTC->SetDivider(60);
	OpenPanel = new BFilePanel(B_OPEN_PANEL);

//	box
	box = new BBox(BRect(5,5,300,145), "mainBox", B_FOLLOW_LEFT | B_FOLLOW_TOP, 
						B_WILL_DRAW | B_NAVIGABLE_JUMP, B_PLAIN_BORDER);
	box->SetLabel("ID3-tag");

//	Adding Children to ID3tag Box
	box->AddChild(aTC);				//artist
	box->AddChild(sTC);				//songname
	box->AddChild(lTC);				//album
	box->AddChild(yTC);				//year
	box->AddChild(genreField);		//genre
	box->AddChild(cTC);				//comments
	mainBox->AddChild(box);			//ID3tag Box
	mainBox->AddChild(fTC);			//file
	mainBox->AddChild(aButton);		//apply button
	mainBox->AddChild(dButton);		//browse button
	mainBox->AddChild(bButton);		//browse button
	AddChild(mainBox);				//grey 3D background
}

/*
  ==========================================
	TagWin::QuitRequested()
  ==========================================
*/

bool
TagWin::QuitRequested()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return BWindow::QuitRequested();
}

/*
  ==========================================
	TagWin::MessageReceived(message)
  ==========================================
*/

void
TagWin::MessageReceived(BMessage* message)
{
	char path[100] = "\0";
	BFile myFile;

	memcpy(path, fTC->Text(), strlen(fTC->Text()));

	switch(message->what)
	{
		case 'APPL': 
			if (OpenFile((char *)path, &myFile, B_READ_WRITE))
			{
				ApplyToFile(&myFile);
				// Close file
				myFile.Unset();	
				bButton->MakeDefault(true);
			}
		break;
		case 'BRWS':
			OpenPanel->Show();
		break;
		case 'DELE':
			if (OpenFile((char *)path, &myFile, B_READ_WRITE))
			{
				OpenFile((char *)path, &myFile, B_READ_WRITE);
				RemoveID3tag(&myFile);
				// Close file
				myFile.Unset();
			}
		break;
		default:
			BWindow::MessageReceived(message);
	}
}

/*
  ==========================================
	TagWin::RetrieveFromFile(BFile)
  ==========================================
*/

void TagWin :: RetrieveFromFile(BFile* myFile)
{
	ssize_t amt_read; 
	id3struct id3tag = {"\0","\0","\0","\0","\0","\0",155};
	char buf[128] = "\0";

	// Read from file into buf
	myFile->Seek(-128, SEEK_END);
	amt_read = myFile->Read((void *)buf, 128);

	// If first part of buf = "TAG" (it has a tag), split buf up into id3 tag parts
	if (strncmp(buf, "TAG", 3) == 0)
	{
		memcpy(id3tag.tag     , buf      , 3 );
		memcpy(id3tag.songname, buf + 3  , 30);
		memcpy(id3tag.artist  , buf + 33 , 30);
		memcpy(id3tag.album   , buf + 63 , 30);
		memcpy(id3tag.year    , buf + 93 , 4 );
		memcpy(id3tag.comment , buf + 97 , 30);
		       id3tag.genre   = buf[127];
	}

	// Update values on the screen, even if it had no tag, show empty boxes
	Lock();
	aTC->SetText(id3tag.artist);
	sTC->SetText(id3tag.songname);
	lTC->SetText(id3tag.album);
	yTC->SetText(id3tag.year);
	cTC->SetText(id3tag.comment);
	// if it has legal genre value, tick it on the list
	if (id3tag.genre >= 0 && id3tag.genre < genre_count)
		genrePopup->ItemAt(buf[127])->SetMarked(true);
	// else, if already ticked, set label to "Genres" 
	else
		if (!(genrePopup->FindMarked() == NULL))
			genrePopup->ItemAt(genrePopup->CountItems() - 1)->SetMarked(true);
	Unlock();
}

/*
  ==========================================
	TagWin::ApplyToFile(BFile)
  ==========================================
*/

void TagWin :: ApplyToFile(BFile* myFile)
{
	char genre[2] = "\n", read[4] = "\n", buf[129] = "\n";
	genre[0] = 155;
	ssize_t amt_read, amt_written; 

	// Process id3tag into 'buf'
	memcpy(buf      , "TAG"      , 3 );
	memcpy(buf + 3  , sTC->Text(), 30);
	memcpy(buf + 33 , aTC->Text(), 30);
	memcpy(buf + 63 , lTC->Text(), 30);
	memcpy(buf + 93 , yTC->Text(), 4 );
	memcpy(buf + 97 , cTC->Text(), 30);
	if (!(genrePopup->FindMarked() == NULL) && //there is a genre marked
		 (genrePopup->IndexOf(genrePopup->FindMarked()) >= 0) && //It is a valid genre
		 (genrePopup->IndexOf(genrePopup->FindMarked()) < genre_count))
	{
		genre[0] = genrePopup->IndexOf(genrePopup->FindMarked());
		memcpy(buf + 127, genre, 1);
	}
	else // apply genre value 155 (invalid genre)
	{
		buf[127] = genre[0];
	}

	// If first part file = "TAG", tag already exists so write over it.
	myFile->Seek(-128, SEEK_END);
	amt_read = myFile->Read((void *)read, 3);
	if (strncmp(read, "TAG", 3) == 0)
	{
		if ((amt_written = myFile->Write(buf, 128)) < 0)
			ErrorDialog("title", "error writing file", "OK");
	}
	else // No tag exists, add it
	{
		myFile->Seek(0, SEEK_END);
		if ((amt_written = myFile->Write(buf, 128)) < 0)
			ErrorDialog("title", "error writing file", "OK");
	}	
}


/*
  ==========================================
	TagWin::RemoveID3tag(BFile)
  ==========================================
*/

void TagWin :: RemoveID3tag(BFile* myFile)
{
	ssize_t amt_read; 
	off_t fileSize;
	char read[4] = "\n";

	myFile->Seek(-128, SEEK_END);
	amt_read = myFile->Read((void *)read, 3);
	if (strncmp(read, "TAG", 3) == 0) // if tag exists
	{
		if (myFile->GetSize(&fileSize) == B_OK)
			;
		if ( !(myFile->SetSize(fileSize - 128) == B_OK) ) // Not ok removing 128 bytes?
			ErrorDialog("title", "Error removing ID3tag", "OK");
	}
	else // No tag to be deleted, return error
	{
		ErrorDialog("title", "There is no ID3tag to be removed", "OK");
	}	
	RetrieveFromFile(myFile);
}

/*
  ==========================================
	TagWin::OpenFile(char, BFile, int)
  ==========================================
*/

bool TagWin :: OpenFile(char* path, BFile* myFile, int openMode)
{
	char extension[5] = "\0";

	// if it is not an .mp3 file, return with error
	memcpy(extension, path + strlen(path) - 4, 4);
	if (!ValidExtension(extension))
	{
		ErrorDialog("title", "This is not an mp3 file", "Whoops...");
		return false;
	}

	// Open File (on error, return showing error)
	if (!(myFile->SetTo((char *)fTC->Text(), openMode) == B_OK))
	{
		ErrorDialog("title", "File not found...", "Oh..."); 
		return false;
	}
	return true;
}

/*
  ==========================================
	TagWin::ValidExtension(char)
  ==========================================
*/

bool TagWin :: ValidExtension(char* extension)
{
	if (( strncmp (extension, ".mp3", 4) == 0 ) || 
		( strncmp (extension, ".Mp3", 4) == 0 ) || 
		( strncmp (extension, ".mP3", 4) == 0 ) || 
		( strncmp (extension, ".MP3", 4) == 0 )   )
		return true;
	else
		return false; 
}

/*
  ==========================================
	TagWin::ErrorDialog(char, char, char)
  ==========================================
*/

void TagWin :: ErrorDialog(char* title, char* text, char* buttonText)
{
	BAlert *myAlert = new BAlert(title, text, buttonText,
		NULL, NULL, B_WIDTH_AS_USUAL, B_OFFSET_SPACING, B_WARNING_ALERT);
	myAlert->SetShortcut(0, B_ESCAPE);
	myAlert->Go();
}

/*
  ==========================================
	TagWin::FrameResized(float, float)
  ==========================================
*/
	
void TagWin :: FrameResized(float w, float h)
{
/*	mainBox->ResizeTo(w, h);
	aTC->ResizeTo(w - 105, 20);
	printf("%.0f %.0f\n",w,h);
	mainBox->Invalidate();
*/	
}
