// StyleGuideDefs.h for BeOS

#ifndef BEOS_STYLEGUIDEDEFS_H
#define BEOS_STYLEGUIDEDEFS_H

// Common BeOS type definitions
#include <SupportDefs.h>

// Boolean false
#ifndef FALSE
#define FALSE 0
#endif

// Boolean true
#ifndef TRUE
#define TRUE 1
#endif

// End-of-string marker
#ifndef EOS
#define EOS '\000'
#endif

// Invalid pointer
#ifndef NULL
#define NULL 0
#endif

typedef bool          tBool;

typedef char          tChar;
typedef unsigned char tUChar;

typedef int8          tInt8;
typedef uint8         tUInt8;

typedef int16         tInt16;
typedef uint16        tUInt16;

typedef int32         tInt32;
typedef uint32        tUInt32;

typedef int64         tInt64;
typedef uint64        tUInt64;

typedef float         tFloat;
typedef double        tDouble;
typedef long double   tLongDouble;

#endif // BEOS_STYLEGUIDEDEFS_H
