#ifndef HUSTLER_HUSTLER_H
#define HUSTLER_HUSTLER_H

// ***************************************************************************
// System Includes
// ***************************************************************************

#include <Bitmap.h>
#include <View.h>

// ***************************************************************************
// Project Includes
// ***************************************************************************

#include "StyleGuideDefs.h"         // Standard type and constant definitions.
#include "CdEngine.h"

// ***************************************************************************
// External Name Declarations
// ***************************************************************************

// ***************************************************************************
// External Variable Declarations
// ***************************************************************************

// ***************************************************************************
// Constant Definitions
// ***************************************************************************

// ***************************************************************************
// Type Definitions
// ***************************************************************************

// ***************************************************************************
// Class Definition
// ***************************************************************************

/**
 * The tHustler class forms the heart of the Hustler replicant. 
 *
 * When instantiated from the Deskbar (using the Instantiate() function),
 * this class creates a small view that contains the application's mini icon
 * (which more-or-less looks like a CD) and the number of the currently 
 * playing track (or "?" when no disc is loaded, and "-" when the CD is 
 * stopped). 
 *
 * Then it creates a CdEngine object, opens the first CD player device it
 * finds, and starts playing a CD if one is loaded. The tHustler object also
 * pops up a menu when the user clicks the mouse on the view, and handles
 * the selected item.
 *
 * @author Matthijs Hollemans <mahlzeit@bigfoot.com>
 * @version 1.0 (Saturday, 20 March 1999)
 *
 * @see Be's CDButton sample code on how to make Deskbar replicants.
 */
class tHustler : public BView {
public:
  // Constant Definitions ====================================================

  // Type Definitions ========================================================

  // Attribute Definitions ===================================================

  // Member Function Definitions =============================================

  // Lifecycle ---------------------------------------------------------------

  /**
   * Default constructor. 
   *
   * This constructor is used when the Hustler application is run. It takes
   * Hustler's small icon and stores it in a bitmap, so that Archive() can
   * put it in the replicant's message.
   */
  tHustler();

  /**
   * Creates a new tHustler object from a BMessage. 
   *
   * This constructor is used to "rehydrate" the archived tHustler object 
   * after the Deskbar (or any other BShelf) has received it. It is called by
   * Instantiate().
   */
  tHustler(BMessage* apMessage);
	
  /** Automatically generated copy constructor. */
  // tHustler(const tHustler& arOld);

  /**
   * Destructor. 
   *
   * Note that the destructor can be called in two different situations: 
   * after the Hustler application has sent the replicant to the Deskbar, it
   * deletes the tHustler object and then terminates itself; and when the 
   * Deskbar itself quits.
   */
  virtual ~tHustler();

  // Operators ---------------------------------------------------------------

  /** Automatically generated assignment operator. */
  // tHustler& operator=(tHustler& arRight);

  // Operations --------------------------------------------------------------

  /** 
   * Creates a new tHustler object from an archived BMessage.
   *
   * This function is called by the Deskbar's Shelf after it has received
   * the message that contains our replicant. (To enable the Deskbar to find
   * this function, we should export it from the executable.) 
   */
  static tHustler* Instantiate(BMessage* apArchive);

  /** 
   * Creates an archive of the data that we need in order to instantiate 
   * ourselves.
   */
  virtual status_t Archive(BMessage* apArchive, bool aDeep = true) const;

  /** Draws the view. */
  virtual void Draw(BRect aUpdateRect);

  /**
   * Creates the pop-up menu on-the-fly when the mouse is clicked inside the
   * view, and waits for the user to make a selection.
   */
  virtual void MouseDown(BPoint aPoint);

  /**
   * Handles the messages that the view receives. 
   *
   * All items from the pop-up menu send their messages directly to the view.
   */
  virtual void MessageReceived(BMessage* apMessage);

  /**
   * Does the things that need to happen at regular intervals (such as
   * telling the view to redraw itself, and blinking the track number in
   * pause mode).
   */
  virtual void Pulse(void);
       
  // Access ------------------------------------------------------------------

  // Inquiry -----------------------------------------------------------------

protected:
  // Constant Definitions ====================================================

  // Type Definitions ========================================================

  // Attribute Definitions ===================================================

  // Member Function Definitions =============================================

private:
  // Constant Definitions ====================================================

  // Type Definitions ========================================================

  /** The messages that are sent by the menu items. */
  enum {
    MSG_MENU_PLAY = 10000,
    MSG_MENU_PAUSE,
    MSG_MENU_STOP,
    MSG_MENU_PREVIOUS,
    MSG_MENU_NEXT,
    MSG_MENU_GO_TO,
    MSG_MENU_EJECT,
    MSG_MENU_DEVICE
  };
  
  // Attribute Definitions ===================================================

  /** Pointer to our CD engine. */    
  tCdEngine* mpCdEngine;

  /** The CD player device that we are currently using. */
  tInt8 mDeviceIndex;
  
  /** Pointer to the BBitmap that stores the application's mini icon. */
  BBitmap* mpIcon;
  
  /**
   * Whether we need to draw the track number. This is used to make the 
   * display blink in pause mode.
   */
  tBool mBlink;

  /** The state of the CD engine at the time Pulse() was last called. */
  tCdEngine::tCdState mOldState;

  /** The track that was playing at the time Pulse() was last called. */  
  tInt8 mOldTrack;
      
  // Member Function Definitions =============================================
};

// ***************************************************************************
// Global Variable Declarations
// ***************************************************************************

// ***************************************************************************
// Inline Function Definitions
// ***************************************************************************

// ***************************************************************************
// Helper Function Declarations
// ***************************************************************************

// ***************************************************************************
// Global Function Declarations
// ***************************************************************************

#endif // HUSTLER_HUSTLER_H
