//functions of MyStringDrawer

#include "preferences.h"
#include "myRoColor.h"
#include "myPreferences.h"
#include "myApp.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "layoutMatrix.h"


MyStringDrawer	::	~MyStringDrawer() 
{
	delete textItem;
	delete font;
};//end


//ctor--just initialize
MyStringDrawer	::	MyStringDrawer(	const char *	ccpparamName, 
									const char *	ccpparamText,
									uint32 			ui32ResizeFlags,
									uint32 			ui32Flags,
									BFont *			pparamFont) 
				: 
					BStringView(	BRect(0, 0, 32, 32),
									ccpparamName, 
									ccpparamText,
									ui32ResizeFlags,
									ui32Flags),
					textItem(	new TextItem(	ccpparamText)),
					font(	pparamFont)
{
//left blank
}//end


void 
MyStringDrawer	::	AttachedToWindow() 
{
	BView::AttachedToWindow();
	rgb_color tempRgbColor;
	myPrefs->GetPreferredMyStringDrawerHighColor(&tempRgbColor);
	SetHighColor(tempRgbColor);
	myPrefs->GetPreferredMyStringDrawerLowColor(&tempRgbColor);
	SetLowColor(tempRgbColor);
	myPrefs->GetPreferredMyStringDrawerViewColor(&tempRgbColor);
	SetViewColor(tempRgbColor);
}//end


void
MyStringDrawer	::	MyGetPreferredSize(	float * fpparamwidth,
										float * fpparamheight)
{
	BWindow bw(	BRect(0, 0, 32, 32), 
				"noshow", 
				B_DOCUMENT_WINDOW, 
				/*B_WILL_ACCEPT_FIRST_CLICK*/0);
	BRect	br(0, 0, 32, 32);
	BView	bv(br, "MyStringDrawer temp view", B_FOLLOW_NONE, B_WILL_DRAW);
	//need to attach these items to a BView before they can be measured
	bw.AddChild(&bv);
	bv.SetFont(font);
	font_height	fontHeight;
	bv.GetFontHeight(&fontHeight);
	descender = fontHeight.descent + fontHeight.leading;
	*fpparamheight = fontHeight.ascent + descender;
	*fpparamwidth = bv.StringWidth(((BStringView *)this)->Text());
	float shear = font->Shear();
	//shear will always be between 45 and 135
	if (shear < 90)
	{
		SetAlignment(B_ALIGN_RIGHT);
	}
	else if (shear > 90)
	{
		SetAlignment(B_ALIGN_LEFT);
	}
//	this next is the default:
//	else
//	{
//		SetAlignment(B_ALIGN_CENTER);
//	}
	bw.RemoveChild(&bv);
}//end


BFont *
MyStringDrawer	::	GetFont(	void)
{
	return font;
}//end


TextItem *
MyStringDrawer	::	GetTextItem(	void)
{
	return textItem;
}//end