//functions of MyStatusBar

#include "preferences.h"
#include "myRoColor.h"
#include "myPreferences.h"
#include "myApp.h"
#include "myStatusBar.h"
#include "layoutMatrix.h"


MyStatusBar	::	~MyStatusBar() 
{
//left blank
};//end


//ctor--just initialize
MyStatusBar	::	MyStatusBar(	BRect 			paramFrame,
										const char *	ccpparamName,
										const char *	ccpparamLabel,
										const char *	ccpparamTrailingLabel,
										float			fparamMaxValue) 
				: 
					BStatusBar(	paramFrame,
								ccpparamName,
								ccpparamLabel,
								ccpparamTrailingLabel)
{
	SetMaxValue(fparamMaxValue);
	SetText("leading changable text");
	SetTrailingText("trailing changable text");
}//end


void
MyStatusBar	::	MyGetPreferredSize(	float * fpparamwidth,
										float * fpparamheight)
{
	BWindow bw(	BRect(0, 0, 32, 32), 
				"noshow", 
				B_DOCUMENT_WINDOW, 
				/*B_WILL_ACCEPT_FIRST_CLICK*/0);
	BRect	br(0, 0, 32, 32);
	BView	bv(br, "MyStatusBar temp view", B_FOLLOW_NONE, B_WILL_DRAW);
	//need to attach these items to a BView before they can be measured
	bw.AddChild(&bv);
	float barHeight = 20;
	SetBarHeight(barHeight);//debug make a pref or ratio??
	bv.SetFont(myPrefs->GetPreferredFont());
	font_height	fontHeight;
	bv.GetFontHeight(&fontHeight);
	float textWidth = bv.StringWidth(Text());
	float trailingTextWidth = bv.StringWidth(TrailingText());
	float labelWidth = bv.StringWidth(Label());
	float trailingLabelWidth = bv.StringWidth(TrailingLabel());
	float totalWidth = textWidth + trailingTextWidth + labelWidth + trailingLabelWidth;//debug may need some padding??
	*fpparamwidth = totalWidth;
	*fpparamheight = (fontHeight.ascent + fontHeight.descent + fontHeight.leading) + barHeight;//will add height for bar later?? debug may need some padding??
	bw.RemoveChild(&bv);
}//end


void 
MyStatusBar	::	AttachedToWindow() 
{
	BView::AttachedToWindow();
	rgb_color tempRgbColor;
	myPrefs->GetPreferredMyStatusBarHighColor(&tempRgbColor);
	SetHighColor(tempRgbColor);
	myPrefs->GetPreferredMyStatusBarLowColor(&tempRgbColor);
	SetLowColor(tempRgbColor);
	myPrefs->GetPreferredMyStatusBarViewColor(&tempRgbColor);
	SetViewColor(tempRgbColor);
}//end