//functions of MyRadioView

#include <memory>
#include "myRadioView.h"
#include "warning.h"
#include "preferences.h"
#include "myPreferences.h"
#include "myApp.h"


MyRadioView	::	~MyRadioView() 
{
//left blank
//pmList deletd in Initialize()
};//end


//ctor--just initialize
MyRadioView	::	MyRadioView(	const char *	ccpparamName, 
								bool			bparamVertical,
								BList *			pparamList,
								BFont *			pparamFont) 
			: 
				BView(	BRect(0, 0, 32, 32), 
						ccpparamName, 
						B_FOLLOW_NONE, 
						B_WILL_DRAW),
				bmVertical(bparamVertical),
				pmList(pparamList),
				pmFont(pparamFont)
{
//left blank
}//end


//do all the real work of construction so we can fail gracefully
bool 
MyRadioView	::	Initialize(	void) 
{
	//sanity check:
	if (	!pmList 
			|| 
			!pmFont)
	{
		warning("Bad initialization of MyRadioView, NULL param\n");
		return false;
	}
	int32 numItems = pmList->CountItems();
	if (!numItems) return true;
	SetFont(pmFont);
	try
	{
		auto_ptr<BList> apButtonList(new BList(/*numItems*/));
		BList * pButtonList = apButtonList.get();
		for (uint32 i = 0; i < numItems; i++)
		{
			RadioViewData * rvd = (RadioViewData *)pmList->ItemAt(i);
			auto_ptr<BRadioButton> apBRadioButton(new BRadioButton(	BRect(0, 0, 32, 32), 
																	rvd->ccpmLabel,
																	rvd->ccpmLabel,
																	rvd->pmMsg,
																	B_FOLLOW_NONE,
																	B_WILL_DRAW));
			BRadioButton * brb = apBRadioButton.get();
			brb->SetFont(myPrefs->GetPreferredFont());
			AddChild(brb);
			brb->ResizeToPreferred();
			pButtonList->AddItem((void *)brb);
			apBRadioButton.release();
		}
		float pad = 2;
		float localLeft = pad;
		float localTop = pad;
		float widest = 0;
		float tallest = 0;
		float width;
		float height;
		for (uint32 i = 0; i < numItems; i++)
		{
			BRadioButton * brb = (BRadioButton *)pButtonList->ItemAt(i);
			brb->MoveTo(localLeft, localTop);
			width = brb->Frame().IntegerWidth();
			height = brb->Frame().IntegerHeight();
			if (width > widest) widest = width;
			if (height > tallest) tallest = height;
			if (bmVertical)
			{
				localTop = localTop + pad + height;
			}
			else//orient horizontal
			{
				localLeft = localLeft + pad + width;
			}
		}
		if (localTop != pad)
		{
			ResizeTo(widest + pad, localTop - pad);
		}
		else//orient horizontal
		{
			ResizeTo(localLeft - pad, tallest + pad);
		}
	}
	catch (...)
	{
		for (uint32 i = 0; i < numItems; i++)
		{
			RadioViewData * rvd = (RadioViewData *)pmList->ItemAt(i);
			delete rvd;
		}
		delete pmList;
		warning("New failed.\n");
		return false;
	}
	for (uint32 i = 0; i < numItems; i++)
	{
		RadioViewData * rvd = (RadioViewData *)pmList->ItemAt(i);
		delete rvd;
	}
	delete pmList;
	return true;
}//end


void 
MyRadioView	::	AttachedToWindow() 
{
	BView::AttachedToWindow();
	rgb_color tempRgbColor;
	myPrefs->GetPreferredMyRadioViewHighColor(&tempRgbColor);
	SetHighColor(tempRgbColor);
	myPrefs->GetPreferredMyRadioViewLowColor(&tempRgbColor);
	SetLowColor(tempRgbColor);
	myPrefs->GetPreferredMyRadioViewViewColor(&tempRgbColor);
	SetViewColor(tempRgbColor);
}//end