//scrolling main window


#include "windowGuts.h"
#include <memory>
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "myButton.h"
#include "myCheckBox.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "stringGadget.h"
#include "myPopUpMenu.h"
#include "myPictureButton.h"
#include "myColorControl.h"
#include "myStatusBar.h"
#include "myRadioView.h"
#include "myTextView.h"
#include "prefPanelWindow.h"
#include "mainWindow.h"
#include "zipWindow.h"
#include "warning.h"
#include "preferences.h"
#include "myRoColor.h"
#include "myPreferences.h"
#include "myApp.h"

//ctor
MainWindow	::	MainWindow(	BRect			paramBound,
							const char *	ccpparamWindowTitle,
							const char *	ccpparamScrollViewName,
							const char *	ccpparamNamePrefFrame)
			: 
				WindowGuts(	paramBound, 
							ccpparamWindowTitle, 
							ccpparamScrollViewName,
							ccpparamNamePrefFrame)
{
	sem_id calc_sem;
	if ((calc_sem = create_sem(1, "calc_sem")) < B_NO_ERROR)
	{
		warning("Could not create_sem.\n");
		return;
	}
	acquire_sem(calc_sem);
	try 
	{
		BWindow bw(	BRect(0, 0, 32, 32), 
					"noshow", 
					B_DOCUMENT_WINDOW, 
					/*B_WILL_ACCEPT_FIRST_CLICK*/0);
		auto_ptr<LayoutMatrix> apLayoutMatrix(new LayoutMatrix(&bw, BESTSIZE, 3, 1));//rows,columns
		LayoutMatrix *	pholdLayoutMatrix = apLayoutMatrix.get();
		apLayoutMatrix.release();
		AddToLayoutMatrixList(pholdLayoutMatrix);
/////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<BFont> apBFont(new BFont());//note-- using system be_plain_font
		BFont * pBFont = apBFont.get();//NOT preferredFont(), just for something different
		apBFont.release();
		float fontSize = pBFont->Size();
		fontSize *= 3;
		if (fontSize > 200)
		{
			fontSize = 200;
		}
		pBFont->SetSize(fontSize);
		pBFont->SetShear(122);
		auto_ptr<MyStringDrawer> apMyStringDrawer(new MyStringDrawer(	"localMyStringDrawer", 
																		"GUIZip", 
																		B_FOLLOW_NONE, 
																		B_WILL_DRAW,
																		pBFont));
		MyStringDrawer * pMyStringDrawer = apMyStringDrawer.get();
		apMyStringDrawer.release();
		pMyStringDrawer->SetFont(myPrefs->GetPreferredFont());
		pholdLayoutMatrix->AddToChildren((void *)pMyStringDrawer);
		auto_ptr<LayoutMatrixItem> apMyStringDrawerLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																							(void *)pMyStringDrawer, 
																							pholdLayoutMatrix->itemsList,
																							KIND_STRINGDRAWER));
///////////////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<BMessage> zipMsg(new BMessage(GUI_ZIP));
		auto_ptr<MyButton> apZipMyButton(new MyButton(	 
															"localZipButton", 
															"Zip", 
															zipMsg.get(), 
															B_FOLLOW_NONE, 
															B_WILL_DRAW));
		zipMsg.release();
		MyButton * pholdZipMyButton = apZipMyButton.get();
		apZipMyButton.release();
		pholdZipMyButton->SetFont(myPrefs->GetPreferredFont());
		pholdLayoutMatrix->AddToChildren((void *)pholdZipMyButton);
		auto_ptr<LayoutMatrixItem> apZipMyButtonLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																			(void *)pholdZipMyButton, 
																			pholdLayoutMatrix->itemsList,
																			KIND_MYBUTTON));
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<BMessage> unZipMsg(new BMessage(GUI_UNZIP));
		auto_ptr<MyButton> apUnZipMyButton(new MyButton(	"localUnZipButton", 
																		"Unzip", 
																		unZipMsg.get(),
																		B_FOLLOW_NONE, 
																		B_WILL_DRAW));
		unZipMsg.release();
		MyButton * pholdUnZipMyButton = apUnZipMyButton.get();
		apUnZipMyButton.release();
		pholdUnZipMyButton->SetFont(myPrefs->GetPreferredFont());
		pholdLayoutMatrix->AddToChildren((void *)pholdUnZipMyButton);
		auto_ptr<LayoutMatrixItem> apUnZipMyButtonLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																			(void *)pholdUnZipMyButton, 
																			pholdLayoutMatrix->itemsList,
																			KIND_MYBUTTON));
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
		release_sem(calc_sem);
		pholdLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, MATRIXVERTICALOFFSET, calc_sem);
	}
	catch (...)
	{
		warning("caught main window constructor\n");
		release_sem(calc_sem);
		throw;
	}
	BMenuItem *	menuItem;
	BMenu *		APPMenu = new BMenu("APP");
	try 
	{
		auto_ptr<BMessage> msg(new BMessage(ABOUT_MAINWINDOW));
		menuItem = new BMenuItem(	"About...", 
									msg.get());
		msg.release();
	}
	catch(...) 
	{
		throw;
	}
	APPMenu->AddItem(menuItem);
	try 
	{
		auto_ptr<BMessage> msg(new BMessage(SCROLL_PREFS));
		menuItem = new BMenuItem(	"Preferences...", 
									msg.get());
		msg.release();
	}
	catch(...) 
	{
		throw;
	}
	APPMenu->AddItem(menuItem);
	try 
	{
		auto_ptr<BMessage> msg(new BMessage(B_QUIT_REQUESTED));
		menuItem = new BMenuItem(	"Quit", 
									msg.get());
		msg.release();
	}
	catch(...) 
	{
		throw;
	}
	APPMenu->AddItem(menuItem);
	pMenuBar->AddItem(APPMenu);
}//end


//dtor
MainWindow	::	~MainWindow() 
{
	if (myPrefs->bPrefChangesMade)
	{
		myPrefs->bPrefChangesMade = false;
		be_app->PostMessage(REOPEN_MAIN);
	}
	else
	{
		if (myPrefs->pPrefPanelWindow)
		{
			myPrefs->pPrefPanelWindow->PostMessage(B_QUIT_REQUESTED);
		}
		if (myApp->pZipWindow)
		{
			myApp->pZipWindow->PostMessage(B_QUIT_REQUESTED);
		}
		be_app->PostMessage(B_QUIT_REQUESTED);
	}
	myApp->pMainWindow = NULL;
}//end


void
MainWindow	::	MessageReceived(	BMessage * pparamMessage) 
{
	switch(pparamMessage->what) 
	{
		case GUI_ZIP:
		{
			myApp->OpenZipPanel();
		break;
		}
		case GUI_UNZIP:
		{
			myApp->OpenUnzipPanel();
		break;
		}
		case ABOUT_MAINWINDOW:	
		{
			warning("about main window\n");
		break;
		}
		case SCROLL_PREFS:
		{
			myPrefs->OpenPreferencesPanel();
		break;
		}
		default:
			WindowGuts::MessageReceived(pparamMessage);
		break;
	}
}//end


bool
MainWindow	::	QuitRequested(	void) 
{
	BRect frame = Frame();
	myApp->SetPreferredGUIZipWindowRect(frame);
	return(WindowGuts::QuitRequested());
}//end