//functions of ColorWell

#include "colorWell.h"
#include "preferences.h"
#include "myRoColor.h"
#include "myPreferences.h"
#include "myApp.h"
#include "warning.h"
#include "textItem.h"
#include "layoutMatrix.h"


ColorWell	::	~ColorWell() 
{
	delete mpLabelTextItem;
};//end


//ctor--just initialize
ColorWell	::	ColorWell(	const char * cparamName, 
									uint32 ui32paramMode, 
									uint32 ui32paramFlags,
									int32 i32paramColorToChange,
									TextItem * pparamLabelTextItem) 
				: 
				BView(	BRect(0, 0, COLORWELLWIDTH, COLORWELLHEIGHT), 
						cparamName, 
						ui32paramMode, 
						ui32paramFlags),
				mColorToChange(i32paramColorToChange),
				mpLabelTextItem(pparamLabelTextItem)
{
	SetViewColor(B_TRANSPARENT_32_BIT);
}//end


void 
ColorWell	::	AttachedToWindow() 
{
	BView::AttachedToWindow();
	rgb_color tempRgbColor;
	myPrefs->GetPreferredColorWellHighColor(&tempRgbColor);
	SetHighColor(tempRgbColor);
	myPrefs->GetPreferredColorWellLowColor(&tempRgbColor);
	SetLowColor(tempRgbColor);
	myPrefs->GetPreferredColorWellViewColor(&tempRgbColor);
	SetViewColor(tempRgbColor);
}//end


void 
ColorWell	::	Draw(	BRect rect) 
{
	BView::Draw(rect);
	SetPenSize(1);
	rgb_color	originalColor(HighColor());
	rgb_color	newColor(originalColor);
	bool		redUp = false;
	bool		greenUp = false;
	bool		blueUp = false;
	BRect 		frame = Bounds();
	int32		stepsDown = frame.IntegerWidth();
	uint8		changeColorBy;
	uint8		colorRange;
	if (originalColor.red < originalColor.green ) 
	{
		if (originalColor.red < originalColor.blue ) 
		{
			redUp = true;
			colorRange = 255 - originalColor.red;
		}
		else
		{
			blueUp = true;
			colorRange = 255 - originalColor.blue;
		}
	}
	else
	{
		if (originalColor.green < originalColor.blue ) 
		{
			greenUp = true;
			colorRange = 255 - originalColor.green;
		}
		else
		{
			blueUp = true;
			colorRange = 255 - originalColor.blue;
		}
	}
	colorRange = colorRange;
	changeColorBy = colorRange / stepsDown;
	for (	int32 i = stepsDown; 
			i > 0; 
			i--)
	{
		if (redUp)
		{
			newColor.red += changeColorBy;
		}
		else 
		{
			if (greenUp)
			{
				newColor.green += changeColorBy;
			}
			else
			{
				newColor.blue += changeColorBy;
			}
		}
		SetHighColor(newColor);
		frame.InsetBy(1, 1);
		StrokeRect(frame);
	}
	SetHighColor(originalColor);
}//end


void 
ColorWell	::	MessageReceived(	BMessage * pparamMessage) 
{
	beep();//just so feedback occures
	pparamMessage->AddInt32("ColorToChange", mColorToChange);
	BView::MessageReceived(pparamMessage);
}//end


TextItem *
ColorWell	::	GetTextItem(void)
{
	return mpLabelTextItem;
}//end



void
ColorWell	::	SetTop(	float fparamTop)
{
	top = fparamTop;
}//end


float
ColorWell	::	GetTop(	void)
{
	return top;
}//end


void
ColorWell	::	SetLeft(	float fparamLeft)
{
	left = fparamLeft;
}//end


float
ColorWell	::	GetLeft(	void)
{
	return left;
}//end