//scrolling fontPref window


#include "windowGuts.h"
#include "s2f.h"
#include "layoutMatrixItem.h"
#include "layoutMatrix.h"
#include "textItem.h"
#include "myStringDrawer.h"
#include "preferences.h"
#include "myCheckBox.h"
#include "myColorControl.h"
#include "colorWell.h"
#include "prefPanelWindow.h"
#include "myPreferences.h"
#include "basicColorWindow.h"
#include "warning.h"
#include "preferences.h"
#include "myRoColor.h"
#include "myPreferences.h"
#include "myApp.h"
#include <memory>
//ctor
BasicColorWindow	::	BasicColorWindow(	BRect	paramBound,
									const char *	ccpparamWindowTitle,
									const char *	ccpparamScrollViewName,
									const char *	ccpparamNamePrefFrame)
				: 
				WindowGuts(	paramBound, 
							ccpparamWindowTitle, 
							ccpparamScrollViewName,
							ccpparamNamePrefFrame)
{
	sem_id calc_sem;
	if ((calc_sem = create_sem(1, "calc_sem")) < B_NO_ERROR)
	{
		warning("Could not create_sem.\n");
		return;
	}
	acquire_sem(calc_sem);
	try 
	{
		BWindow bw(	BRect(0, 0, 32, 32), 
					"noshow", 
					B_DOCUMENT_WINDOW, 
					/*B_WILL_ACCEPT_FIRST_CLICK*/0);
		auto_ptr<LayoutMatrix> apBasicColorWindowLayoutMatrix(new LayoutMatrix(&bw, BESTSIZE, 1, 1));//rows,columns
		LayoutMatrix *	pholdTitleLayoutMatrix = apBasicColorWindowLayoutMatrix.get();
		apBasicColorWindowLayoutMatrix.release();
		AddToLayoutMatrixList(pholdTitleLayoutMatrix);
/////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<BFont> apBFont(new BFont());//note-- using system be_plain_font
		BFont * pBFont = apBFont.get();//NOT preferredFont(), just for something different
		apBFont.release();
		float fontSize = pBFont->Size();
		fontSize *= 3;
		if (fontSize > 200)
		{
			fontSize = 200;
		}
		pBFont->SetSize(fontSize);
		pBFont->SetShear(122);
		//will need offset for demo--use a seperate matrix and get it's bottom
		auto_ptr<MyStringDrawer> apMyStringDrawer(new MyStringDrawer(	"fontPrefMyStringDrawer", 
																		"Underlying Colors", 
																		B_FOLLOW_NONE, 
																		B_WILL_DRAW,
																		pBFont));
		MyStringDrawer * pMyStringDrawer = apMyStringDrawer.get();
		apMyStringDrawer.release();
		pMyStringDrawer->SetFont(myPrefs->GetPreferredFont());
		pholdTitleLayoutMatrix->AddToChildren((void *)pMyStringDrawer);
		auto_ptr<LayoutMatrixItem> apMyStringDrawerLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																							(void *)pMyStringDrawer, 
																							pholdTitleLayoutMatrix->itemsList,
																							KIND_STRINGDRAWER));
/////////////////////////////
		LayoutMatrix *	pholdViewCCLayoutMatrix;
		auto_ptr<LayoutMatrix> apColorControlLayoutMatrix(new LayoutMatrix(&bw, BESTSIZE, 2, 1));//rows,columns
		pholdViewCCLayoutMatrix = apColorControlLayoutMatrix.get();
		apColorControlLayoutMatrix.release();
		AddToLayoutMatrixList(pholdViewCCLayoutMatrix);
		rgb_color color;//re-use for every setvalue
/////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<BFont> apBFontAXX(new BFont(myPrefs->GetPreferredFont()));
		BFont * pBFontAXX = apBFontAXX.get();
		apBFontAXX.release();
		auto_ptr<MyStringDrawer> apMyStringDrawerAXX(new MyStringDrawer(	"MyStringDrawerAXX", 
																			"Set View color:", 
																			B_FOLLOW_NONE, 
																			B_WILL_DRAW,
																			pBFontAXX));
		MyStringDrawer * pMyStringDrawerAXX = apMyStringDrawerAXX.get();
		apMyStringDrawerAXX.release();
		pholdViewCCLayoutMatrix->AddToChildren((void *)pMyStringDrawerAXX);
		auto_ptr<LayoutMatrixItem> apMyStringDrawerAXXLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)pMyStringDrawerAXX, 
																								pholdViewCCLayoutMatrix->itemsList,
																								KIND_STRINGDRAWER));
////////////////////////////////////////////////////////////////////
		auto_ptr<BMessage> colorControlAXXMsg(new BMessage(COLORCONTROL_VIEW));
		auto_ptr<MyColorControl> apColorControlAXX(new MyColorControl(	BPoint(1, 1), 
																				B_CELLS_8x32,//lots of other options! Make a pref??
																				1,
																				"ColorControlAXX", 
																				colorControlAXXMsg.get(), 
																				true,
																				this));
		colorControlAXXMsg.release();
		pmViewColorControl = apColorControlAXX.get();
		apColorControlAXX.release();
		myPrefs->GetPreferredViewColor(&color);
		pmViewColorControl->SetValue(color);
		pholdViewCCLayoutMatrix->AddToChildren((void *)pmViewColorControl);
		auto_ptr<LayoutMatrixItem> apColorControlAXXLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																							(void *)pmViewColorControl, 
																							pholdViewCCLayoutMatrix->itemsList,
																							KIND_MYCOLORCONTROL));
/////////////////////
		LayoutMatrix *	pholdHighCCLayoutMatrix;
		auto_ptr<LayoutMatrix> apHighColorControlLayoutMatrix(new LayoutMatrix(&bw, BESTSIZE, 2, 1));//rows,columns
		pholdHighCCLayoutMatrix = apHighColorControlLayoutMatrix.get();
		apHighColorControlLayoutMatrix.release();
		AddToLayoutMatrixList(pholdHighCCLayoutMatrix);
////////////////////////////////
		auto_ptr<BFont> apBFontBXX(new BFont(myPrefs->GetPreferredFont()));
		BFont * pBFontBXX = apBFontBXX.get();
		apBFontBXX.release();
		auto_ptr<MyStringDrawer> apMyStringDrawerBXX(new MyStringDrawer(	"MyStringDrawerBXX", 
																		"Set High color:", 
																		B_FOLLOW_NONE, 
																		B_WILL_DRAW,
																		pBFontBXX));
		MyStringDrawer * pMyStringDrawerBXX = apMyStringDrawerBXX.get();
		apMyStringDrawerBXX.release();
		pholdHighCCLayoutMatrix->AddToChildren((void *)pMyStringDrawerBXX);
		auto_ptr<LayoutMatrixItem> apMyStringDrawerBXXLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)pMyStringDrawerBXX, 
																								pholdHighCCLayoutMatrix->itemsList,
																								KIND_STRINGDRAWER));
/////////////////////////////////////////////
		auto_ptr<BMessage> colorControlBXXMsg(new BMessage(COLORCONTROL_HIGH));
		auto_ptr<MyColorControl> apHighColorControlBXX(new MyColorControl(	BPoint(1, 1), 
																					B_CELLS_8x32,
																					1,
																					"HighColorControlBXX", 
																					colorControlBXXMsg.get(), 
																					true,
																					this));
		colorControlBXXMsg.release();
		pmHighColorControl = apHighColorControlBXX.get();
		apHighColorControlBXX.release();
		myPrefs->GetPreferredHighColor(&color);
		pmHighColorControl->SetValue(color);
		pholdHighCCLayoutMatrix->AddToChildren((void *)pmHighColorControl);
		auto_ptr<LayoutMatrixItem> apHighColorControlBXXLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																							(void *)pmHighColorControl, 
																							pholdHighCCLayoutMatrix->itemsList,
																							KIND_MYCOLORCONTROL));
//////////////////////////////////////////////////////////////
		LayoutMatrix *	pholdLowCCLayoutMatrix;
		auto_ptr<LayoutMatrix> apLowColorControlLayoutMatrix(new LayoutMatrix(&bw, BESTSIZE, 2, 1));//rows,columns
		pholdLowCCLayoutMatrix = apLowColorControlLayoutMatrix.get();
		apLowColorControlLayoutMatrix.release();
		AddToLayoutMatrixList(pholdLowCCLayoutMatrix);
///////////////////////////////////////////////////
		auto_ptr<BFont> apBFontCXX(new BFont(myPrefs->GetPreferredFont()));
		BFont * pBFontCXX = apBFontCXX.get();
		apBFontCXX.release();
		auto_ptr<MyStringDrawer> apMyStringDrawerCXX(new MyStringDrawer(	"MyStringDrawerCXX", 
																		"Set Low color:", 
																		B_FOLLOW_NONE, 
																		B_WILL_DRAW,
																		pBFontCXX));
		MyStringDrawer * pMyStringDrawerCXX = apMyStringDrawerCXX.get();
		apMyStringDrawerCXX.release();
		pholdLowCCLayoutMatrix->AddToChildren((void *)pMyStringDrawerCXX);
		auto_ptr<LayoutMatrixItem> apMyStringDrawerCXXLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																								(void *)pMyStringDrawerCXX, 
																								pholdLowCCLayoutMatrix->itemsList,
																								KIND_STRINGDRAWER));
///////////////////////////////////////////////////////////////////
		auto_ptr<BMessage> colorControlCXXMsg(new BMessage(COLORCONTROL_LOW));
		auto_ptr<MyColorControl> apLowColorControlCXX(new MyColorControl(	BPoint(1, 1), 
																					B_CELLS_8x32,
																					1,
																					"LowColorControlCXX", 
																					colorControlCXXMsg.get(), 
																					true,
																					this));
		colorControlCXXMsg.release();
		pmLowColorControl = apLowColorControlCXX.get();
		apLowColorControlCXX.release();
		myPrefs->GetPreferredLowColor(&color);
		pmLowColorControl->SetValue(color);
		//pmLowColorControl->SetFont(myPrefs->GetPreferredFont());
		pholdLowCCLayoutMatrix->AddToChildren((void *)pmLowColorControl);
		auto_ptr<LayoutMatrixItem> apLowColorControlCXXLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																							(void *)pmLowColorControl, 
																							pholdLowCCLayoutMatrix->itemsList,
																							KIND_MYCOLORCONTROL));
////////////////////////
		LayoutMatrix * pholdColorWellLayoutMatrix;
		auto_ptr<LayoutMatrix> apColorWellLayoutMatrix(new LayoutMatrix(&bw, BESTSIZE, 3, 1));//rows,columns
		pholdColorWellLayoutMatrix = apColorWellLayoutMatrix.get();
		apColorWellLayoutMatrix.release();
		AddToLayoutMatrixList(pholdColorWellLayoutMatrix);
//////////////
		auto_ptr<TextItem> apMainViewColorWellText(new TextItem("main view roColor>"));
		TextItem * pholdMainViewColorWellText = apMainViewColorWellText.get();
		apMainViewColorWellText.release();
		pholdColorWellLayoutMatrix->AddToDraw((void *)pholdMainViewColorWellText);
		auto_ptr<ColorWell> apMainViewColorWell(new ColorWell(	"ColorWellViewColorPref", 
																			B_FOLLOW_NONE, 
																			B_WILL_DRAW,
																			VIEW_COLOR,
																			pholdMainViewColorWellText));
		ColorWell * pholdMainViewColorWell = apMainViewColorWell.get();
		apMainViewColorWell.release();
		pholdColorWellLayoutMatrix->AddToChildren((void *)pholdMainViewColorWell);
		auto_ptr<LayoutMatrixItem> apMainViewLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																					(void *)pholdMainViewColorWell, 
																					pholdColorWellLayoutMatrix->itemsList,
																					KIND_COLORWELLGADG));
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<TextItem> apMainHighColorWellText(new TextItem("main high roColor>"));
		TextItem * pholdMainHighColorWellText = apMainHighColorWellText.get();
		apMainHighColorWellText.release();
		pholdColorWellLayoutMatrix->AddToDraw((void *)pholdMainHighColorWellText);
		auto_ptr<ColorWell> apMainHighColorWell(new ColorWell(	"ColorWellHighColorPref", 
																			B_FOLLOW_NONE, 
																			B_WILL_DRAW,
																			HIGH_COLOR,
																			pholdMainHighColorWellText));
		ColorWell * pholdMainHighColorWell = apMainHighColorWell.get();
		apMainHighColorWell.release();
		pholdColorWellLayoutMatrix->AddToChildren((void *)pholdMainHighColorWell);
		auto_ptr<LayoutMatrixItem> apMainHighLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																					(void *)pholdMainHighColorWell, 
																					pholdColorWellLayoutMatrix->itemsList,
																					KIND_COLORWELLGADG));
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
		auto_ptr<TextItem> apMainLowColorWellText(new TextItem("main low roColor>"));
		TextItem * pholdMainLowColorWellText = apMainLowColorWellText.get();
		apMainLowColorWellText.release();
		pholdColorWellLayoutMatrix->AddToDraw((void *)pholdMainLowColorWellText);
		auto_ptr<ColorWell> apMainLowColorWell(new ColorWell(	"ColorWellLowColorPref", 
																			B_FOLLOW_NONE, 
																			B_WILL_DRAW,
																			LOW_COLOR,
																			pholdMainLowColorWellText));
		ColorWell * pholdMainLowColorWell = apMainLowColorWell.get();
		apMainLowColorWell.release();
		pholdColorWellLayoutMatrix->AddToChildren((void *)pholdMainLowColorWell);
		auto_ptr<LayoutMatrixItem> apMainLowLayoutMatrixItem(new LayoutMatrixItem(	&bw, 
																					(void *)pholdMainLowColorWell, 
																					pholdColorWellLayoutMatrix->itemsList,
																					KIND_COLORWELLGADG));
//////////////
		release_sem(calc_sem);
		pholdTitleLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, MATRIXVERTICALOFFSET, calc_sem);
		pholdViewCCLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, pholdTitleLayoutMatrix->bottom, calc_sem);
		pholdHighCCLayoutMatrix->Calc(pholdViewCCLayoutMatrix->right, pholdTitleLayoutMatrix->bottom, calc_sem);
		pholdLowCCLayoutMatrix->Calc(pholdHighCCLayoutMatrix->right, pholdTitleLayoutMatrix->bottom, calc_sem);
		pholdColorWellLayoutMatrix->Calc(MATRIXHORIZONTALOFFSET, pholdLowCCLayoutMatrix->bottom, calc_sem);
	}
	catch (...)
	{
		warning("caught basic color window constructor\n");
		release_sem(calc_sem);
		throw;
	}
	BMenuItem *	menuItem;
	BMenu *		APPMenu = new BMenu("app");
	try 
	{
		auto_ptr<BMessage> msg(new BMessage(ABOUT_BASICCOLORFWINDOW));
		menuItem = new BMenuItem(	"About...", 
									msg.get());
		msg.release();
	}
	catch(...) 
	{
		throw;
	}
	APPMenu->AddItem(menuItem);
	try 
	{
		auto_ptr<BMessage> msg(new BMessage(B_QUIT_REQUESTED));
		menuItem = new BMenuItem(	"Close window", 
									msg.get());
		msg.release();
	}
	catch(...) 
	{
		throw;
	}
	APPMenu->AddItem(menuItem);
	pMenuBar->AddItem(APPMenu);
}//end


//dtor
BasicColorWindow	::	~BasicColorWindow() 
{
	if (myPrefs->pPrefPanelWindow)//can get a race if not checked
	{
		myPrefs->pPrefPanelWindow->mpPrefWindows[PP_BASIC] = NULL;
	}
}//end


bool
BasicColorWindow	::	QuitRequested(	void) 
{
	BRect frame = Frame();
	myPrefs->SetPreferredBasicColorWindowRect(frame);
	rgb_color color(pmViewColorControl->ValueAsColor());
	myPrefs->SetPreferredViewColor(&color);
	color = pmHighColorControl->ValueAsColor();
	myPrefs->SetPreferredHighColor(&color);
	color = pmLowColorControl->ValueAsColor();
	myPrefs->SetPreferredLowColor(&color);
	return(WindowGuts::QuitRequested());
}//end


void
BasicColorWindow	::	ResetDemo(	void)
{
	myPrefs->bPrefChangesMade = true;
}//end


void
BasicColorWindow	::	MessageReceived(	BMessage * pparamMessage) 
{
	switch(pparamMessage->what) 
	{
		case ABOUT_BASICCOLORFWINDOW:	
			warning("about basic color window\n");
		break;
		case COLORCONTROL_VIEW:
		case COLORCONTROL_HIGH:
		case COLORCONTROL_LOW:
			ResetDemo();
		break;
		case ROCOLORDROPPEDMESSAGE: 
		{
    		rgb_color * pRGBColor;
    		rgb_color color;    		
    		int32 numRGBBytes = sizeof(struct rgb_color);
	        if (	pparamMessage->FindData(	"RGBColor",
		       									B_RGB_COLOR_TYPE, 
												(void**)&pRGBColor, 
												&numRGBBytes ) 
					== B_OK)
	        {
	           	color = *pRGBColor;
	            if (pparamMessage->WasDropped()) 
	            { 
					int32 colorToChange;
					if (	pparamMessage->FindInt32(	"ColorToChange",
														&colorToChange)
							 == B_OK)
					{
						switch(colorToChange)
						{
							case VIEW_COLOR:
								myPrefs->SetPreferredViewColor(&color);
								pmViewColorControl->SetValue(color);
							break;
							case HIGH_COLOR:
								myPrefs->SetPreferredHighColor(&color);
								pmHighColorControl->SetValue(color);
							break;
							case LOW_COLOR:
								myPrefs->SetPreferredLowColor(&color);
								pmLowColorControl->SetValue(color);
							break;
							case NO_COLOR:
								warning("Demo roColorWell does not make any changes!\n");
							break;
							default:
								warning("roColor sent basic a bad colorToChange\n");
								throw;
							break;
						}
						ResetDemo();
					}
				}
			}
		break;
		}
		default:
			WindowGuts::MessageReceived(pparamMessage);
		break;
	}
}//end