#!/boot/local/bin/perl
eval 'exec perl -S $0 "$@"'
	if $running_under_some_shell;

###########################################################
#
# EudoraToBeMail v1.0
#
# Tom Hays, trh@lns598.lns.cornell.edu
# 30 Nov 1997
# Converts Macintosh Eudora 3.0 mailboxes into BeMail files.
#
# This code is freely distributable under the Gnu Copyleft License.
#
###########################################################

#####################################################################
#
# Brief documentation.
#
# usage:
#
# EudoraToBeMail.pl mailbox1 [mailbox2] ...
# 
# or
#
# EudoraToBeMail.pl < mailbox1 [mailbox2] ...
#
# where mailbox1, etc. are the Eudora mailboxes (text files)
# using the Be end-of-line convention.  See below for Mac to
# Be text file conversion suggestions.
#
# Each mail message in the Eudora mailbox will be converted into a 
# single BFS file.  The Eudora mailbox is treated as read only and is not
# affected by this operation. The each mail message is given the
# appropriate MIME code and the e-mail attributes.  Status is assigned
# as "Read" since I assume that the mail was already read on the Mac.
# If someone can suggest a better strategy to deal with the Status:
# line, I would be happy to hear it.
# 
# The priority is not assigned.
#
# I haven't tried this script out on any other forms of Eudora
# mailboxes.  I think that it should work with older versions of
# Eudora and probably the EudoraLite series.
#
# This code uses the following bash command line operations:
#  date
#  addattr
#
# so if these are broken on your system, you are out of luck.
#
#
# This script requires that the mailboxes follow the Be EOL convention.
# So, you will have to execute
#  tr '\r' '\n' < mailbox.mac > mailbox.be ;
#
#
# You probably have your own bash script, but a simple one I use to convert
# many files in place is this:
#
#        for arg in $*
#        do
#          tr '\r' '\n' < $arg > $arg.tmp;
#          mv $arg.tmp $arg;
#        done     
#
# Give this bash script many files on the command line via wildcards.
# 
# Another alternative is to use a drag and drop approach with 
# "BeStripper" by Yclept Microsystems.
# As of version 1.0, BeStripper doesn't allow you to drag folders.
# The bash script above will permit folders (even nested) using 
# an appropriate wildcard sequence.
#
# BFS filename construction:
#
# Each message is assigned a filename constructed from the From:
# field of the e-mail message.  Quotes are removed and slashes are
# converted to colons.  The end of the filename has an underscore
# and a six digit sequence constructed from the From field at the
# beginning of the message.  This indicates when the message was 
# downloaded from the mail server.  After the six digit date
# is a colon and a number to ensure a unique filename.

# Possible failure modes:
#
# I have tried to test this on a wide variety of messages.
# Some tricks to deal with double quotes, single quotes, and
# slashes were developed.  There may certainly be some things
# that I have missed.
#
# One fragile part is the detection of mail message boundaries
# in the Eudora file.  I currently use the very first line of
# each message.  It begins with "From " and ends with a date.
#
# Should the body of a message have a line that resembles
#
# From Doodleman Sat May 31 01:31:58 1997
#
# An erroneous boundary will be found with unpredictable results.
# The next legitimate boundary should cause the Perl script to
# act normally for subsequent mail messages.
#
# The code is biased towards English.  International character sets
# are not handled gracefully here.


# Now for the Perl code...


# set up a conversion to map the month onto a two digit number
$monthnum{"Jan"} = "01";
$monthnum{"Feb"} = "02";
$monthnum{"Mar"} = "03";
$monthnum{"Apr"} = "04";
$monthnum{"May"} = "05";
$monthnum{"Jun"} = "06";
$monthnum{"Jul"} = "07";
$monthnum{"Aug"} = "08";
$monthnum{"Sep"} = "09";
$monthnum{"Oct"} = "10";
$monthnum{"Nov"} = "11";
$monthnum{"Dec"} = "12";

$status = "start";
while (<>) {
  if ($status eq "start"){
      if (/^From \S+ [MTWFS][a-z][a-z] [JFMASOND][a-z][a-z] \d\d \d\d:\d\d:\d\d \d\d\d\d/){  # e.g.,    From ???@??? Sat Dec 07 09:41:34 1996
          # found boundary marker and looking for filename
          ($dummy,$dummy,$dummy,$month,$day,$dummy,$year) = split(" ");
          $dateCode = &MakeDateCode($_);  # code to indicate when mail was acquired
          $header = "";  # start accumulating header info until a filename is found.
          # do not write the boundary marker in the message data.
      
          # clear the current attributes
          while (($attrName,$attrValue) = each(%attr)){
             delete $attr{$attrName};
          }
      $status = "inheader";
      }
  } elsif ($status eq "inheader") { # looking for the filename
      $theline = $_;
      chop($theline);
      &CheckForAttribute($_);
      $theline = $theline."\r"."\n";  # This is a special EOL for Be mail messages.
      $header = $header . $theline;   # Accumulate lines until a filename is found.
      if (/^From: /){          # Found info for filename on this line.
         $thefileline = $_;
         chop($thefileline);
         #Quotes make things tricky so remove them.
         $thefileline =~ s/\"//g;
         #Slashes will screw up things so replace them with colons.
         $thefileline =~ s/\//:/g;
         $thefile = substr($thefileline,6)."_".$dateCode;
         $theFileKey = $thefile;  # Use the filename as a key to keep track of 
                              # multiple messages from same person on same day.
         if ($nameIncrement{$theFileKey}){
             $nameIncrement{$theFileKey}++;  
         } else {
           $nameIncrement{$theFileKey} = 1;
         }
         $thefile = $thefile.":".$nameIncrement{$theFileKey};

         # open file and write lines accumulated so far.
         open(FILEOUT,">$thefile") || die "I couldn't open $thefile.";
         print FILEOUT $header;
         $status = "inbody";  
      }          
  } elsif ($status eq "inbody") {     
     if (/^From \S+ [MTWFS][a-z][a-z] [JFMASOND][a-z][a-z] \d\d \d\d:\d\d:\d\d \d\d\d\d/){
        if (FILEOUT){ #checking just to be cautious.           
            # close file and add attributes.
            close(FILEOUT);
            while (($theAttribute,$theValue) = each(%attr)) {
              if ($theAttribute eq "MAIL:when"){
                `addattr -t llong "$theAttribute" "$theValue" "$thefile"`;
              } else {   
                `addattr -t string "$theAttribute" "$theValue" "$thefile"`;
              } #end if else
            } # end while over attributes
            # make the status type Read
            `addattr -t mime "MAIL:status" "Read" "$thefile"`;
            # make the mime type text/x-email
            `addattr -t mime "BEOS:TYPE" "text/x-email" "$thefile"`;
         } #end if FILEOUT 
         # found boundary marker and looking for filename
         ($dummy,$dummy,$dummy,$month,$day,$dummy,$year) = split(" ");
         $dateCode = &MakeDateCode($_);  # code to indicate when mail was acquired
         $header = "";  # start accumulating header info until a filename is found.
         # do not write the boundary marker in the message data.
      
         # clear the current attributes
         while (($attrName,$attrValue) = each(%attr)){
             delete $attr{$attrName};
         }
         $status = "inheader";
     } else {
        $theline = $_;
        chop($theline);
        &CheckForAttribute($_);
        $theline = $theline."\r"."\n";  # deal with the EOL convention
        if (FILEOUT) {
           print FILEOUT $theline;
        }
     }
     #end if line beqins with From ???@??? etc.
     
  } 

} #end while loop over lines of input.

# close last open file and write attributes.
if (FILEOUT){ #checking just to be cautious.           
   # close file and add attributes.
   close(FILEOUT);
   while (($theAttribute,$theValue) = each(%attr)) {
      if ($theAttribute eq "MAIL:when"){
         `addattr -t llong "$theAttribute" "$theValue" "$thefile"`;
      } else {   
         `addattr -t string "$theAttribute" "$theValue" "$thefile"`;
      } #end if else
   } # end while over attributes
   # make the status type Read
   `addattr -t mime "MAIL:status" "Read" "$thefile"`;
   # make the mime type text/x-email
   `addattr -t mime "BEOS:TYPE" "text/x-email" "$thefile"`;
} #end if FILEOUT 



# Subroutines
sub MakeDateCode{
  local($dummy,$datecode,$month,$day,$year,$monthnum,$datecode);

  ($dummy,$dummy,$dummy,$month,$day,$dummy,$year) = split(" ",$_[0]);
  $year =~ s/19([0-9][0-9])/$1/;
  $monthnum{$month};
  $datecode = $monthnum{$month}.$day.$year;    
 
  $datecode;    # return value
}

sub CheckForAttribute{
  local($theline,$seconds,$dummy);
  
  $theline = $_[0];
    
  # The presence of quotes messes up the command line use of 'addattr' so
  # I will escape any quotes now.
  $theline =~ s/"/\\"/g;        

  # The checks for values already defined helps when the mail message contains
  # lines of the same format.  This occurs a lot with e-mail digests.
  
  if (!$attr{"MAIL:to"}){ 
     if($theline =~ /^To: (.*)/){
      $attr{"MAIL:to"} = $1;
     }
  }

  if (!$attr{"MAIL:from"}){   
     if($theline =~ /^From: (.*)/){
      $attr{"MAIL:from"} = $1;
     }
  }
  
  if (!$attr{"MAIL:subject"}){   
     if($theline =~ /^Subject: (.*)/){
      $attr{"MAIL:subject"} = $1;
     }
  }

  if (!$attr{"MAIL:reply"}){   
     if($theline =~ /^Reply-To: (.*)/){
      $attr{"MAIL:reply"} = $1;
     }
  }
  
  if (!$attr{"MAIL:when"}){   
     if($theline =~ /^Date: (.*)/){    
        $seconds = `date --date "$1" +%s`;   # use the Gnu date command to do the hard work.
        chop($seconds);   
        $attr{"MAIL:when"} = $seconds;
     }
  }

  if (!$attr{"MAIL:name"}){
# This tries to find the real name if present.  If not use whatever is there.
     if($theline =~ /^From: (\\")?([^"]*)(\\")? <.*@.*>/){   # e.g., John Smith <js@isp.com>
      $attr{"MAIL:name"} = $2;
     } elsif ($theline =~ /^From: .*@.*\W*\((.*)\)/){ # e.g., js@isp.com (John Smith)
      $attr{"MAIL:name"} = $1;
     } elsif ($theline =~ /^From: (.*)/){
      $attr{"MAIL:name"} = $1;
     }
  }
# I am ignoring a handful of other attributes (e.g., recipients, cc, status) since they
# are very rarely used by me and some are a bit difficult to code properly.

}
