/*
 * Psion wve format, based on the au format file. Hacked by
 * Richard Caley (R.Caley@ed.ac.uk)
 */

#include "st.h"
#include "g72x.h"

/* Magic numbers used in Psion audio files */
#define PSION_MAGIC     "ALawSoundFile**"
#define PSION_VERSION   ((short)3856)
#define PSION_HDRSIZE	32

struct wvepriv
    {
    unsigned int length;
    short padding;
    short repeats;
    };

IMPORT wvewriteheader(P1(ft_t ft));

int wvestartread(ft_t ft) 
{
    char magic[16];
    short version;
    unsigned int length;

	register int i;
	char *buf;
	struct wvepriv *p = (struct wvepriv *) ft->priv;

	/* Sanity check */
	if (sizeof(struct wvepriv) > PRIVSIZE)
		return 0;
//		fail("struct wvepriv is too big (%d); change PRIVSIZE in st.h and recompile sox",sizeof(struct wvepriv));

	/* Check the magic word */
        fread(magic, 16, 1, ft->fp);
	if (strcmp(magic, PSION_MAGIC)==0) {
		ft->swap = 0;
//		report("Found Psion magic word");
	}
	else
		return 0;
//		fail("Psion header doesn't start with magic word\nTry the '.al' file type with '-t al -r 8000 filename'");

        version=rshort(ft);

	if (version != PSION_VERSION)
		return 0;
//		fail("Wron version in Psion header");

     	p->length=rlong(ft);

	p->padding=rshort(ft);

	p->repeats=rshort(ft);

 	(void)rshort(ft);
 	(void)rshort(ft);
 	(void)rshort(ft);
    
	ft->info.style = ALAW;
	ft->info.size = BYTE;

	ft->info.rate = 8000;

	ft->info.channels = 1;
	
	return 1;
}

wveread(ft_t ft, long *buf, int samp)
{
	return rawread(ft, buf, samp);
}

wvestopread(ft_t ft)
{
};