/*
 * Sounder/Sndtool format handler: W V Neisius, February 1992
 *
 * June 28, 93: force output to mono.
 */

#include <math.h>
#include "st.h"
#ifdef	VMS
#include <errno.h>
#include <perror.h>
#endif

/* Private data used by writer */
struct sndpriv {
        unsigned long nsamples;
};

#ifndef	SEEK_CUR
#define	SEEK_CUR	1
#endif

/*======================================================================*/
/*                         SNDSTARTREAD                                */
/*======================================================================*/

int sndtstartread(ft_t ft)
{
struct sndpriv *p = (struct sndpriv *) ft->priv;

char buf[97];

long rate;

rate = 0;

/* determine file type */
        /* if first 5 bytes == SOUND then this is probably a sndtool sound */
        /* if first word (16 bits) == 0 
         and second word is between 4000 & 25000 then this is sounder sound */
        /* otherwise, its probably raw, not handled here */

if (fread(buf, 1, 2, ft->fp) != 2)
	return 0;
//	fail("SND: unexpected EOF");
if (strncmp(buf,"\0\0",2) == 0)
	{
	/* sounder */
	rate = rlshort(ft);
	if (rate < 4000 || rate > 25000 )
		return 0;
//		fail ("SND: sample rate out of range");
	fseek(ft->fp,4,SEEK_CUR);
	}
else
	{
	/* sndtool ? */
	fread(&buf[2],1,6,ft->fp);
	if (strncmp(buf,"SOUND",5))
		return 0;
//		fail ("SND: unrecognized SND format");
	fseek(ft->fp,12,SEEK_CUR);
	rate = rlshort(ft);
	fseek(ft->fp,6,SEEK_CUR);
	if (fread(buf,1,96,ft->fp) != 96)
		return 0;
//		fail ("SND: unexpected EOF in SND header");
//	report ("%s",buf);
	}

ft->info.channels = 1;
ft->info.rate = rate;
ft->info.style = UNSIGNED;
ft->info.size = BYTE;

	return 1;
}
