
/*
 * July 5, 1991
 * Copyright 1991 Lance Norskog And Sundry Contributors
 * This source code is freely redistributable and may be used for
 * any purpose.  This copyright notice must be maintained. 
 * Lance Norskog And Sundry Contributors are not responsible for 
 * the consequences of using this software.
 */

/*
 * Sound Tools text format file.  Tom Littlejohn, March 93.
 *
 * Reads/writes sound files as text for use with fft and graph.
 *
 * June 28, 93: force output to mono.
 */

#include "st.h"
#include "libst.h"
#include <stdio.h>

/* Private data for dat file */
typedef struct dat {
	double timevalue, deltat;
} *dat_t;

long roundoff(double x)
{
    if (x < 0.0) return(x - 0.5);
    else return(x + 0.5);
    }

int datstartread(ft_t ft)
{
   char inpstr[82];
   char sc;

   while (ft->info.rate == 0) {
      fgets(inpstr,82,ft->fp);
      sscanf(inpstr," %c",&sc);
      if (sc != ';') 
      	return 0;
//      	fail("Cannot determine sample rate.");
      sscanf(inpstr," ; Sample Rate %ld",&ft->info.rate);
      }

   /* size and style are really not necessary except to satisfy caller. */

   ft->info.size = DOUBLE;
   ft->info.style = SIGN2;
   
   return 1;
}

datread(ft_t ft, long *buf, int nsamp)
{
    dat_t dat = (dat_t) ft->priv;
    char inpstr[82];
    double sampval;
    int retc;
    int done = 0;
    char sc;

    while (done < nsamp) {
        do {
          fgets(inpstr,82,ft->fp);
          if(feof(ft->fp)) return done;
          sscanf(inpstr," %c",&sc);
          }
          while(sc == ';');  /* eliminate comments */
        retc = sscanf(inpstr,"%*s %lg",&sampval);
        if (retc != 1) 
	        return 0;
//        	fail("Unable to read sample.");
        *buf++ = roundoff(sampval * 2.147483648e9);
        ++done;
    }
    return done;
}

datstopread(ft_t ft)
{
}