/*
 *  CPU.h - 6510 emulation
 *
 *  SIDPlayer (C) 1996-1997 Christian Bauer
 */

#ifndef _CPU_H
#define _CPU_H

#include "Types.h"


class MOS6581;


// Class for 6510 emulation
class MOS6510 {
public:
	MOS6510();

	void Emulate(UWORD startadr, UBYTE ra, UBYTE rx, UBYTE ry);

	UBYTE *RAM;			// Pointer to main RAM
	MOS6581 *TheSID;	// Pointer to SID

protected:
	UBYTE read_byte(UWORD adr);
	UWORD read_word(UWORD adr);
	void write_byte(UWORD adr, UBYTE byte);

	UBYTE read_zp(UWORD adr);
	UWORD read_zp_word(UWORD adr);
	void write_zp(UWORD adr, UBYTE byte);

	UBYTE pop_byte(void);
	UWORD pop_word(void);
	void push_byte(UBYTE byte);
	void pop_flags(void);
	void push_flags(bool b_flag);

	void jump(UWORD adr);

	void do_adc(UBYTE byte);
	void do_sbc(UBYTE byte);

	UBYTE n_flag, z_flag;
	bool v_flag, d_flag, i_flag, c_flag;
	UBYTE a, x, y, sp;
	UBYTE *pc, *pc_base;

	bool stack_underflow;	// Stack underflow, stop emulation
};

#endif
