/*
 --> The MMIO Portable Memory Management functions
  -> Divine Entertainment GameDev Libraries

 Copyright  1997 by Jake Stine and Divine Entertainment

*/
#include "mmio.h"

// Same as malloc, but sets error variable _mm_error when it failed
void *_mm_malloc(size_t size)
{
    char *d;

    if((d=(char *)malloc(size))==NULL)
    {
       	_mm_error = ERROR_OUT_OF_MEMORY;
	}
	else
     	memset(d,0,size);

   return d;
}


// Same as calloc, but sets error variable _mm_error when it failed
void *_mm_calloc(size_t nitems, size_t size)
{
   	void *d;

   	if((d=malloc((nitems*size)))==NULL)
     	_mm_error = ERROR_OUT_OF_MEMORY;
	else     
   		memset(d,0,nitems*size);

   	return d;
}


#ifndef __WATCOMC__
#ifndef __BEOS__
// Same as Watcom's strdup function - allocates memory for a string
// and makes a copy of it.  Ruturns NULL if failed.
CHAR *strdup(CHAR *src)
{
   CHAR *buf;

   if((buf = (CHAR *)_mm_malloc(strlen(src)+1)) == NULL) return NULL;
   strcpy(buf,src);
   return buf;
}
#endif
#endif

