/* 

    TiMidity -- Experimental MIDI to WAVE converter
    Copyright (C) 1995 Tuukka Toivonen <toivonen@clinet.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    output.c
    
    Audio output (to file / device) functions.
*/

#include "config.h"
#include "output.h"
#include "tables.h"


/* These are very likely mutually exclusive.. */
#ifdef AU_DEC
extern PlayMode dec_play_mode;
#define DEFAULT_PLAY_MODE &dec_play_mode
#endif

#ifdef AU_LINUX
extern PlayMode linux_play_mode;
#define DEFAULT_PLAY_MODE &linux_play_mode
#endif

#ifdef AU_HPUX
extern PlayMode hpux_play_mode;
#define DEFAULT_PLAY_MODE &hpux_play_mode
#endif

#ifdef AU_SUN
extern PlayMode sun_play_mode;
#define DEFAULT_PLAY_MODE &sun_play_mode
#endif

#ifdef AU_WIN32
extern PlayMode win32_play_mode;
#define DEFAULT_PLAY_MODE &win32_play_mode
#endif

#ifdef __BEOS__
extern PlayMode beos_play_mode;
#define DEFAULT_PLAY_MODE &beos_play_mode
#endif

/* These are always compiled in. */
extern PlayMode raw_play_mode, wave_play_mode;

PlayMode *play_mode_list[] = {
#ifdef DEFAULT_PLAY_MODE
  DEFAULT_PLAY_MODE,
#endif
  &wave_play_mode,
  &raw_play_mode,
  0
};

#ifdef DEFAULT_PLAY_MODE
  PlayMode *play_mode=DEFAULT_PLAY_MODE;
#else
  PlayMode *play_mode=&wave_play_mode;
#endif

/*****************************************************************/
/* Some functions to convert signed 32-bit data to other formats */

