/*
 *	Simple interpolate processor V1.0
 *
 *  Sources are copyrighted by Tinic Urou in 1997. All rights reserved.
 */

#include <AppKit.h>
#include "Post.h"

#define POST_NAME 		"Interpolate"			
#define POST_ACTIVATED 	"InterpolateActivated"	

struct instance_struct							// instance of our class
{
	BView		*view;
	short 		oldvaluel;
	short		oldvaluer;
};

/*
 	Dispatcher of our zOOnic class
*/

long class_dispatcher(Class *c, Object *o, ulong MethodID, ulong *data)
{
	instance_struct *inst=(instance_struct *)o->Instance(c);

	o->SetError(B_NO_ERROR);

	switch(MethodID)
	{
		case	B_METHOD_CONSTRUCT:				// like the C++ constructor method
				{
					inst->view=new BView(BRect(0,0,0,0),"",NULL,B_WILL_DRAW);
					return 0;
				}

		case	B_METHOD_DESTROY:				// Destructor method
				{
					delete inst->view;
					return 0;
				}


		case	PO_STREAM:						// void (char *buffer, int size)
				{
					short *buffer	=(short *)	data[0];
					int size		=(int)		data[1]/2;					
					
					for(int c=0;c<size;c+=2)
					{
						inst->oldvaluel=buffer[c+0]=(buffer[c+0]+inst->oldvaluel)/2;
						inst->oldvaluer=buffer[c+1]=(buffer[c+1]+inst->oldvaluer)/2;
					}
					
					return 0;
				}
				
		case	PO_NEWFILE:						// void (BAudioSubscriber *auds)
				{	
					inst->oldvaluel=0;
					inst->oldvaluer=0;
					return 0;
				}
		
		case	PO_ENDFILE:						// void (void)
				{
					return 0;
				}

		case	PO_GETATTR:						
				{
					ulong ATTR =(ulong)data[0];
					ulong DATA =(ulong)data[1];

					switch(ATTR)
					{
						case	PO_ATTR_ID:			
								*((char **)DATA)=POST_NAME;
								return 0;
						case	PO_ATTR_BVIEW:			
								*((BView **)DATA)=inst->view;
								return 0;
						default:
								return o->DoSuperMethod(c,PO_GETATTR,data);
					}
				}

		default:
				return o->DoSuperMethod(c,MethodID,data);
	}
}

char *class_superclass()
{
	return "dualplayer/post/baseprocessor.zclass";
};

long class_instancesize()
{
	return sizeof(struct instance_struct);
};

long class_superversion()
{
	return 1;
};

long class_version()
{
	return 1;
};
