//
// Calculator.h
//
// The calculator object (or model)
//

#pragma once

class Calculator 
{
public:
	typedef enum {
		OP_PLUS, OP_SUBTRACT, OP_MULTIPLY, OP_DIVIDE, OP_EQUALS, OP_AND, 
		OP_OR, OP_NOT, OP_XOR
	} Operator;
	
	typedef enum {
		RADIX_BINARY = 2, RADIX_OCTAL = 8, RADIX_DECIMAL = 10, RADIX_HEX = 16
	} RADIX;
	
	Calculator();
	
	void Clear();
	void ClearAll();
	void EnterDigit(const char* digitStr);
	void EnterOp(Operator op);
	void GetResults(char* buf, uint32 bufSize);
	void Not();
	void SetRadix(RADIX newRadix);
	RADIX Radix();
	void UnaryMinus();
	void SetX(double d);
	double X();
	
private:
	bool 	enterFlag;
	bool 	yFlag;
	int		operation;
	double	x;
	double	y;
	int8	digitsEntered;
	double	decimal;
	RADIX	radix;
};
