//
// AboutWindow.cpp
//

#include "AboutWindow.h"
#include "DvBeUtils.h"

class AboutView : public BView
{
public:
	AboutView();
	void AttachedToWindow();
	
protected:
	BView* CreateStringView(BRect *frame, const char*name, const char* title, 
		float fontSize);
	void CreateKeyHelp(BRect r);
};

AboutWindow::AboutWindow() 
	: BWindow(BRect(0, 0, 0, 0), "About DevaCalc", B_TITLED_WINDOW, 
		B_NOT_RESIZABLE | B_NOT_ZOOMABLE) 
{
	const float width = 200;
	const float height = 260;
	
	// Calculate centered coordinates for app's current screen.
	//
	BRect screen = BScreen(be_app->WindowAt(0)).Frame();
	BRect frame;
	frame.left = (screen.Width() - width) / 2;
	frame.right = frame.left + width;
	frame.top = (screen.Height() - height) / 2;
	frame.bottom = frame.top + height;

	// Center the window
	//
	MoveTo(frame.LeftTop());
	ResizeTo(width, height);
	
	// Now create the view
	AddChild(new AboutView);
}

// AboutView
/////////////

static void ResizeViewToFontHeight(BView* v, float fontSize)
{
	font_height h;
	v->SetFontSize(fontSize);	
	v->GetFontHeight(&h);
	
	BRect r = v->Bounds();
	v->ResizeTo(r.Width(), h.ascent + h.descent + h.leading);
}

static void DisplayRect(BRect r, const char* title)
{
	char buf[81];
	sprintf(buf, "%s: {left:%g, top:%g, right:%g, bottom:%g}", 
		title, r.left, r.top, r.right, r.bottom);
	DoAlert(buf);
}

AboutView::AboutView() : BView(BRect(0, 0, 200, 260), "AboutView", B_FOLLOW_ALL_SIDES, 
	B_WILL_DRAW | B_FRAME_EVENTS)
{
	SetViewColor(168, 204, 240);	// light blue background
	BRect r = Bounds();
	r.InsetBy(5, 5);
	CreateStringView(&r, "Title", "DevaCalc v1.0", 20);
	CreateStringView(&r, "By", "by", 12);
	CreateStringView(&r, "Author", "Rod Schmidt", 14);
	CreateStringView(&r, "Company", "Devachan Software", 14);
	r.OffsetBy(0, r.Height() / 2);
	CreateStringView(&r, "Copyright", "Copyright © 1998, Devachan Software", 10);
	CreateStringView(&r, "AllRights", "All Rights Reserved.", 10);

	// Display the keyboard shortcuts
	//	
	CreateKeyHelp(r);
}

void AboutView::AttachedToWindow()
{
	// Make view take up entire window
	//
	BRect r = Window()->Bounds();
	ResizeTo(r.Width(), r.Height());
	
	BView::AttachedToWindow();
}

BView* AboutView::CreateStringView(BRect* frame, const char*name, const char* title, 
	float fontSize)
{
	BStringView* v = new BStringView(*frame, name, title, B_FOLLOW_LEFT_RIGHT);
	v->SetAlignment(B_ALIGN_CENTER);
	v->SetHighColor(64, 0, 128);	// dark purple
	ResizeViewToFontHeight(v, fontSize);
	AddChild(v);
	
	// Now adjust frame to position of next string
	//
	*frame = v->Frame();
	frame->OffsetBy(0, frame->Height());
	return v;
}

static void DisplaySel(BTextView* tv)
{
	int32 start, finish;
	tv->GetSelection(&start, &finish);
	
	char buf[81];
	sprintf(buf, "start: %d, finish: %d", start, finish);
	DoAlert(buf);
}

void AboutView::CreateKeyHelp(BRect r)
{
	BRect frame = r;
	frame.OffsetBy(0, r.Height() / 2);
	BRect bounds = Bounds();
	bounds.InsetBy(5, 5);
	frame.right = bounds.right;
	frame.bottom = bounds.bottom;	

	BBox* box = new BBox(frame);
	box->SetLabel("Non-obvious Keys");
	AddChild(box);
		
	frame = box->Bounds();
	frame.InsetBy(5, 5);
	frame.top += 10;
	BRect textRect(0, 0, frame.Width(), frame.Height());
	BTextView* tv = new BTextView(frame, NULL, textRect, B_FOLLOW_ALL, B_WILL_DRAW);
	tv->MakeEditable(false);
	tv->MakeSelectable(false);
	box->AddChild(tv);
	
	// Here are the key shortcuts
	//
	//	=		Enter
	//	C		Escape
	//	CA		Del
	//	+/-		n or N
	//	And		&
	//	Or		| or o or O
	//	Xor		x, X, or ^
	//	Not		~, !
	//
	BFont font;
	tv->GetFontAndColor(&font, NULL);
	
	rgb_color color = {0, 0, 0, 0};
	tv->SetFontAndColor(&font, B_FONT_FACE, &color);
	tv->Insert("Button\tKey\n");
	
	color.blue = 255;
	tv->SetFontAndColor(&font, B_FONT_FACE, &color);
	tv->Insert("=\t\tEnter");	
	tv->Insert("\nC\t\tEscape");
	tv->Insert("\nCA\t\tDelete");
	tv->Insert("\n+/-\t\tN");
	tv->Insert("\nAnd\t\t&");
	tv->Insert("\nOr\t\t| or O");
	tv->Insert("\nXor\t\t^ or X");
	tv->Insert("\nNot\t\t~ or !");
}
