#pragma once
#include <Application.h>
#include <Window.h>
#include <MenuItem.h>
#include <Menu.h>
#include <View.h>
#define ABOUT 'ABOU'
#define BOGUS 'NOTT'
#define TEXT ""
#define INFO "DeskPad 1.0 beta 1\n\nDerek White\nfunksta@earthlink.net"
#define HELP "DeskPad is a program to write needed info down on like phone numbers, web sites, email addresses, servers, etc. that would normally be hard to remember."

//------------------------------------------------------------------
class WWindow : public BWindow
{
	public:
					WWindow(BRect frame, const char *title);
	virtual bool	QuitRequested();
	virtual void	MessageReceived(BMessage*	message);
	virtual void	AboutRequested();
	private:
					
};

//------------------------------------------------------------------
class AboutWindow : public BWindow
{
	public:
					AboutWindow(BRect frame, const char *title);
	private:
					BButton		*okButton;
};
//------------------------------------------------------------------


main()
{
	BApplication		*pad;
	BRect				frame;
	frame = BRect(50,100,300,400);
	pad = new BApplication('DPAD');
	WWindow				*Window;
	Window = new WWindow(frame, "DeskPad");
	Window->Show();
	pad->Run();
	
	delete(pad);
	return(0);
};

WWindow::WWindow(BRect frame, const char *title)
			: BWindow(frame, title, B_TITLED_WINDOW, 0)
{
	BRect		w_rect;
	BMenu		*wmenu;
	BMenu		*wedit;
	BMenuBar	*menubar;
	BMenuItem	*item;
	w_rect = frame;
	
	w_rect.OffsetTo(B_ORIGIN);
	BView	*view;
	view = new BView(w_rect, "view", B_FOLLOW_ALL, B_WILL_DRAW);
	AddChild(view);

	//Make Menubar.
	w_rect.Set(0,0,1000,19);
	menubar = new BMenuBar(w_rect, "MB", B_FULL_UPDATE_ON_RESIZE, B_ITEMS_IN_ROW, FALSE);
	wmenu = new BMenu("File", B_ITEMS_IN_COLUMN);
	wmenu->AddItem(new BMenuItem("Get Info", new BMessage(ABOUT), 'I', NULL));
	wmenu->AddSeparatorItem();
	wmenu->AddItem(new BMenuItem("Quit", new BMessage(B_QUIT_REQUESTED), 'Q', NULL));
	wedit = new BMenu("Edit", B_ITEMS_IN_COLUMN);
	wedit->SetEnabled(false);
	wedit->AddItem(new BMenuItem("Cut", new BMessage(BOGUS), 'X', NULL));
	wedit->AddItem(new BMenuItem("Copy", new BMessage(BOGUS), 'C', NULL));
	wedit->AddItem(new BMenuItem("Paste", new BMessage(BOGUS), 'V', NULL));
	menubar->AddItem(wmenu);
	menubar->AddItem(wedit);
	// Add menubar to the veiw.
	view->AddChild(menubar);
	
	// Set up main BTextView.
	w_rect.Set(0,10,400,450);
	BTextView *text;
	text = new BTextView(w_rect, "Title", w_rect, B_FOLLOW_ALL, B_WILL_DRAW);
	text->MakeEditable(true);
	text->MakeFocus();
	text->SetAlignment(B_ALIGN_LEFT);
	text->MakeSelectable(true);
	text->SetStylable(true);
	view->AddChild(text);
};

bool WWindow::QuitRequested()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return(TRUE);
};

void WWindow::AboutRequested()
{
	BRect		frame;
	AboutWindow		*aw;
	frame = BRect(100,40,275,250);
	aw = new AboutWindow(frame, "Get Info");
	aw->Show();
};

AboutWindow::AboutWindow(BRect frame, const char	*title)
				: BWindow(frame, title, B_MODAL_WINDOW, B_NOT_RESIZABLE, 0)
{
	frame.Set(0,7,170,70);
	BTextView *info;
	info = new BTextView(frame, "Get Info", frame, B_FOLLOW_ALL, B_WILL_DRAW);
	info->SetText(INFO,sizeof(INFO));
	info->MakeEditable(false);
	info->SetAlignment(B_ALIGN_CENTER);
	info->MakeSelectable(false);
	info->SetStylable(true);
	AddChild(info);
	frame.Set(0,40,170,170);
	BTextView	*help;
	help = new BTextView(frame, "", frame, B_FOLLOW_ALL, B_WILL_DRAW);
	help->SetText(HELP,sizeof(HELP));
	help->MakeEditable(false);
	help->SetAlignment(B_ALIGN_CENTER);
	help->MakeSelectable(false);
	help->SetStylable(true);
	AddChild(help);
	frame.Set(65,175,115,200);
	okButton = new BButton(frame, "OK", "OK", new BMessage(B_QUIT_REQUESTED));
	AddChild(okButton);
};

void WWindow::MessageReceived(BMessage*	message)
{
	switch(message->what)
	{
		case ABOUT:
			AboutRequested();
		break;

	}
}
