/*
 * Chron
 * Copyright Jonathan Booth, Oct 13, 1996
 *
 * Last Update: Oct 13, 1996
 *
 * A rewrite of the X-windows clock 'Chron', except prettier.
 */

#include <Alert.h>
#include "App.h"
#include "Clock.h"

// Dimensions and offset
const int	LenX = 110;
const int	LenY = 110;
const int	OffsetX = 50;
const int	OffsetY = 50;

Application::Application()
	: BApplication("application/x-VND.jbooth-Chron") {
	win = NULL;
}

Application::~Application() {}

bool Application::QuitRequested()
{
	if (win) {
		BMessage *msg = new BMessage(B_QUIT_REQUESTED);
		PostMessage(msg,win);
	}
	
	return TRUE;
}

void Application::ReadyToRun()
{
	BApplication::ReadyToRun();
	
	win = new BWindow(BRect(OffsetX,OffsetY,LenX + OffsetX,
			 LenY + OffsetY) ,"Chron 1.11",
	         B_MODAL_WINDOW_LOOK,B_NORMAL_WINDOW_FEEL,
	         B_NOT_RESIZABLE|B_NOT_ZOOMABLE,
	         B_CURRENT_WORKSPACE);

	// Set up stuff
	Clock *image = new Clock(win->Bounds(),B_COLOR_8_BIT);
		
	// Put it in
	win->AddChild(image);
	image->Pulse();
	win->Show(); 
	
	// Set the size min & max
	win->SetSizeLimits(110,110,110,110);

	AboutRequested();
}

void Application::AboutRequested()
{
	BAlert *about = new BAlert("","Chron, Copyright October 21, 1996\n"
							   "Jonathan Booth (kamikaze@imsa.edu)\n\n"
							   "If you use Chron, please send an e-mail\n"
							   "to me. If you feel generous and wish to\n"
							   "make a contribution to the author\n"
							   "(#include PoorStarvingCollegeStudent.h)\n"
							   "send it to:\n\n"
							   "   Jonathan Booth\n"
							   "   29W131 Batavia Road\n"
							   "   Warrenville IL, 60555\n\n",
							   "Ok!");
	about->Go();
}