/*
 * Copyright (C) 1999 Daisuke Sato
 * Author : D.Sato <satozzz@cadvision.com>
 *
 * There are no warranties of any kind for this program. If you use this
 * program, you do so at your own risk. The authors are not responsible for any
 * damages  that might result from using this program.
 */
#include <Be.h>

#include "CRcView.h" 
#include "constant.h"
#include "CRcWindow.h" 
#include "convflg.h"
#include "convCR.h"

CRcView::CRcView( BRect frame ) 
    :BView( frame, PGMNAME, B_FOLLOW_ALL, B_WILL_DRAW )  
{ 
     convcr = new convCR() ;
    
    _initWindow( frame ) ;
}


CRcView::~CRcView()
{
    _deleteWindow() ;

    delete convcr ;
    delete savename ;
}


void CRcView::AttachedToWindow() 
{ 
    _setColor() ;
} 


void CRcView::_initWindow( BRect frame )
{
    base = new BBox( frame, 
                     "base", 
                     B_FOLLOW_ALL, 
                     B_WILL_DRAW,
                     B_PLAIN_BORDER ) ;             

    BRect buttonFrame0( 210, 15, 275, 42 ) ; 
    inputButton = new BButton( buttonFrame0, "beepbutton", BTN0_NAME, 
                               new BMessage( MSG_OPEN_PRESSED ) ) ;  
    AddChild( inputButton ) ; 
    
    BRect buttonFrame10( 210, 50, 275, 77 ) ; 
    outputButton = new BButton( buttonFrame10, "beepbutton", BTN1_NAME, 
                               new BMessage( MSG_SAVE_PRESSED ) ) ; 
    outputButton->SetEnabled( false ) ;
    AddChild( outputButton ) ;    

    BRect buttonFrame20( 210, 123, 275, 150 ) ; 
    exeButton = new BButton( buttonFrame20, "beepbutton", BTN2_NAME, 
                               new BMessage( MSG_EXEC_PRESSED ) ) ; 
    exeButton->SetEnabled( false ) ;
    exeButton->MakeDefault( true ) ;
    AddChild( exeButton ) ;        
    
    BRect buttonFrame30( 210, 158, 275, 185 ) ; 
    dismisButton = new BButton( buttonFrame30, "beepbutton", BTN3_NAME, 
                               new BMessage( MSG_QUIT_PRESSED ) ) ; 
    AddChild( dismisButton );  
    
    BRect radioFrame0( 10, 20, 100, 20 ) ; 
    radio0 = new BRadioButton( radioFrame0, "radio1", RDO0_NAME 
                            , new BMessage( MSG_B2W_PRESSED ) ) ; 
    radio0->SetValue( 1 ) ;
    radio0->SetFont( be_fixed_font ) ;
    BRect radioFrame1( 10, 40, 100, 40 ) ; 
    radio1 = new BRadioButton( radioFrame1, "radio2", RDO1_NAME 
                            , new BMessage( MSG_B2M_PRESSED ) ) ; 
    radio1->SetFont( be_fixed_font ) ;
    BRect radioFrame2( 10, 60, 100, 60 ) ; 
    radio2 = new BRadioButton( radioFrame2, "radio3", RDO2_NAME 
                            , new BMessage( MSG_W2B_PRESSED ) ) ; 
    radio2->SetFont( be_fixed_font ) ;
    BRect radioFrame3( 10, 80, 100, 80 ); 
    radio3 = new BRadioButton( radioFrame3, "radio4", RDO3_NAME 
                            , new BMessage( MSG_M2B_PRESSED ) ) ; 
    radio3->SetFont( be_fixed_font ) ;
    
    BRect boxFrame0 ( 10, 10, 200, 42 ) ; 
    box0 = new BBox( boxFrame0, "box0" ) ; 
    box0->SetLabel( BOX0_NAME ) ;
    
    BRect rect( 8,11,186,30 ) ;
    inputtext = new BStringView( rect, "textview", "" ) ; 
    inputtext->SetFont(be_bold_font);   
    inputtext->SetFontSize(14);  
    box0->AddChild( inputtext ) ; 
    AddChild( box0 ) ; 

    BRect boxFrame10( 10, 45, 200, 77 ) ;  
    box10 = new BBox( boxFrame10, "box10" ) ; 
    box10->SetLabel( BOX1_NAME ) ; 
    
    outputtext = new BStringView( rect, "textview", "" ) ;
    outputtext->SetFont(be_bold_font);   
    outputtext->SetFontSize(14);  
	box10->AddChild( outputtext ); 
    AddChild( box10 ) ; 
	
    BRect boxFrame20( 10, 80, 200, 185 ) ;   
    box20 = new BBox( boxFrame20, "box1" ) ; 
    box20->SetLabel( BOX2_NAME ) ; 
    box20->AddChild( radio0 ) ; 
    box20->AddChild( radio1 ) ; 
    box20->AddChild( radio2 ) ; 
    box20->AddChild( radio3 ) ; 
    AddChild( box20 ) ; 

    AddChild( base ) ;
}


void CRcView::_setColor()
{
    rgb_color viewcolor = { 220, 220, 220 } ; 
    SetViewColor( viewcolor ) ; 
}


void CRcView::_deleteWindow()
{
    delete base ;
    delete radio0 ;
    delete radio1 ;
    delete radio2 ;
    delete radio3 ; 
    delete inputButton ; 
    delete outputButton ; 
    delete exeButton ; 
    delete dismisButton ; 
    delete inputtext ; 
    delete outputtext ; 
    delete box0 ; 
    delete box10 ;
    delete box20 ;
}


void CRcView::_BAlert( alert_type type, char *msg )
{
    (new BAlert( B_EMPTY_STRING,
            msg,
            "OK",
            NULL,
            NULL,
            B_WIDTH_AS_USUAL,
            type ))->Go() ;   
}


void CRcView::openpanel()
{
    if( openPanel == NULL ){
        openPanel = new BFilePanel ; 
    }
    openPanel->Show() ;	
}


void CRcView::savepanel()
{
    if( savePanel == NULL ){
	    savePanel = new BFilePanel( B_SAVE_PANEL,
	                                new BMessenger( this ),
	                                NULL,			               
				                    0,
				                    false ) ;    
    } 
    savePanel->Show() ;	
}


void CRcView::getOpenfname( BMessage *msg ) 
{
   	if( msg->FindRef( "refs", &openref ) != B_OK ) return ;
   	
   	retmsg = convcr->readSorceFile( &openref ) ;
    if( retmsg != NULL ){
        _BAlert( B_WARNING_ALERT, retmsg ) ;
        return ;
    }
    convFlg = convcr->crCode() ;
    switch( convFlg ){
        case WIN_TO_BE :
            radio2->SetValue( 1 ) ;
            break ;
        case MAC_TO_BE :
            radio3->SetValue( 1 ) ;
            break ;
        case BE_TO_WIN :
        default :
            radio0->SetValue( 1 ) ;
            break ;
    }
   	inputtext->SetText( openref.name ) ;
   	outputButton->SetEnabled( true ) ;
}


void CRcView::getSavefname( BMessage *msg ) 
{
    char *sn ;

    msg->FindString( "name", &sn ) ;
    if( savename ) delete savename ;
    savename = new char[ strlen( sn ) +1 ] ;
    strcpy( savename, sn ) ;
    
    msg->FindRef( "directory",  &saveref ) ;
    outputtext->SetText( savename ) ;
    exeButton->SetEnabled( true ) ;   
}


void CRcView::resetSaveFname()
{
    outputtext->SetText( NULL ) ;
    exeButton->SetEnabled( false ) ;   
}


void CRcView::setConvflg( int flg )
{
    convFlg = flg ;
}


void CRcView::convertCR()
{
    retmsg = convcr->createSaveFile( &saveref, savename ) ;
    if( retmsg != NULL ){
        goto ERROR ;
    }
    
    convcr->convert( convFlg ) ;
    _BAlert( B_INFO_ALERT, "The Convertion was completed." ) ;
    
    retmsg = convcr->saveclose() ;
    if( retmsg != NULL ){
        goto ERROR ;
    }
    
    return ;
    
    ERROR:
        _BAlert( B_WARNING_ALERT, retmsg ) ;
        return ;
}
/*
 * End.
 */
