/*
 * Copyright (C) 1999 Daisuke Sato
 * Author : D.Sato <satozzz@cadvision.com>
 *
 * There are no warranties of any kind for this program. If you use this
 * program, you do so at your own risk. The authors are not responsible for any
 * damages  that might result from using this program.
 */
#include "convCR.h"
#include "corsrep.h"

convCR::convCR( entry_ref *openref, 
                entry_ref *saveref, 
                char      *savename ) 
       :fileUtil( openref, saveref, savename ) 
{
    sor = new charORstrReplace() ;
}


convCR::convCR():fileUtil()
{
    sor = new charORstrReplace() ;
}


convCR::~convCR()
{
    delete sor ;
}


char *convCR::readSorceFile( entry_ref *openref )
{
    retmsg = openread( openref ) ;
    if( retmsg != NULL ) return retmsg ;
    return NULL ;
}


char *convCR::createSaveFile( entry_ref *saveref, char *savename )
{
    retmsg = savecreate( saveref, savename ) ;
    if( retmsg != NULL ) return retmsg ;
    return NULL ;
}


int convCR::crCode()
{
    static int crtype ;
    
    buff = filebuff( &buflen ) ;
    if( sor->strcount( buff, WIN_CR ) > 0 ){
        crtype = WIN_TO_BE ;
        goto RETURN ;
    }
    if( sor->strcount( buff, MAC_CR ) > 0 ){
        crtype = MAC_TO_BE ;
        goto RETURN ;
    }
    crtype = BE_TO_WIN ;
    
    RETURN :
    return crtype ;
}


void convCR::convert( int convflg )
{
    char  *cr ;

    buff = ( char * )filebuff( &buflen ) ;
    keepbuf = new char[ buflen ] ; 
    memcpy( keepbuf,  buff,  buflen ) ;
    
    cr = _retCRstr( convflg ) ; 
    sor->replace( saveStream(), keepbuf, cr, SEEK_CHAR ) ;
    saveclose() ;
    
    delete keepbuf ;
}


char *convCR::_retCRstr( int convflg )
{
    switch( convflg ){
        case BE_TO_WIN : return WIN_CR ;
        case BE_TO_MAC : return MAC_CR ;
        default :        return BE_CR ;
    }
}
/*
 * End.
 */