#include <stdio.h>
#include "constant.h"
#include "args.h"

getargs::getargs()
{
    inpath  = NULL ;
    outpath = NULL ;
}

getargs::~getargs()
{
    inpath  = NULL ;
    outpath = NULL ;
}

int getargs::args_check( int argc, char *argv[] )
{
    register int    i ;
    int             error = 0 ;

    for ( i = 1; i < argc; i++ ){
        if ( argv[i][0] == '-' ){
            switch( (int)argv[i][1] ){
            case 'h': _print_help() ; return ARGS_ERROR ;
            case 'i':
                if( i++ >= argc ){ error++; break; }
                inpath = argv[ i ] ;
                break ;
            }/* switch end */
        }
        else{
            error++;
        }
    }
    if( error ){
        _print_help() ;
        return ARGS_ERROR ;
    }
    return ARGS_OK ;
}


void getargs::_print_help()
{
    register int i ;
    static char *msg[] = {
        "where options include:\n",
        "  -help  print out this message\n",
        "\n        -------- Options --------\n",
        "  -in  <input file pathname>   # file pathname (ascii code file)\n",
        "" 
    } ;
    fprintf( stderr, "USAGE: %s [-options ...]\n\n", PGMNAME ) ;
    for( i = 0; msg[i][0] != ( char )NULL; i++ ) fprintf( stderr, "%s", msg[ i ] ) ;
}