/*
 * Copyright (C) 1999 Daisuke Sato
 * Author : D.Sato <satozzz@cadvision.com>
 *
 * There are no warranties of any kind for this program. If you use this
 * program, you do so at your own risk. The authors are not responsible for
 * any damages  that might result from using this program.
 */
#include "constant.h"
#include "CRcApp.h" 
#include "args.h"

int main() 
{ 
    CRcApp app ;
    app.Run() ; 
    
    return 0 ; 
}


CRcApp::CRcApp():BApplication( APP_SIGNATURE )
{ 
    BRect frame; 
    
    frame.Set( 100, 100, 385, 300 ); 
    window = new CRcWindow( frame ); 
    window->Show(); 
} 


void CRcApp::RefsReceived( BMessage *msg )
{
    uint32    type;
    int32     count;

    msg->GetInfo( "refs", &type, &count ) ;
    if( type != B_REF_TYPE ) return ;                               

    err = msg->FindRef( "refs", 0, &ref ) ;                                  
	if( err != B_OK ) return ;
	BMessage aMessage( B_SIMPLE_DATA ) ;
	aMessage.AddRef( "refs", &ref ) ;

	window->Lock() ;
	BView *view = window->ChildAt( 0 ) ;
    window->Unlock() ;
    window->PostMessage( &aMessage, view ) ;
}


void CRcApp::ArgvReceived( int32 argc, char *argv[] )
{
    getargs   args ;
    int       ret_args ;  
    BMessage *message = 0 ;

    ret_args = args.args_check( argc, argv ) ;
    if( args.inpath ){          
        err = get_ref_for_path( args.inpath , &ref ) ;
        if( err != B_OK ) return ;
     
        if( !message ){
            message = new BMessage;
            message->what = B_REFS_RECEIVED ;
        }
        message->AddRef( "refs", &ref ) ;     
        if( message ) RefsReceived( message ) ; 
    } 
}
/*
 * End.
 */